---
tags:
- sentence-transformers
- sentence-similarity
- feature-extraction
- generated_from_trainer
- dataset_size:5566780
- loss:HierarchyTransformerLoss
base_model: sentence-transformers/all-MiniLM-L12-v2
widget:
- source_sentence: glycoprotein o-fatty-acyltransferase
  sentences:
  - transtympanic micropressure therapy
  - protein
  - genus actinocorallia
- source_sentence: female pelvic cellulitis
  sentences:
  - inflammatory disorder of genitourinary system
  - carbon monoxide fumes from conflagration in farm outbuildings
  - vascular disease of abdomen
- source_sentence: protein-glutamate methylesterase
  sentences:
  - laparoscopic hysterectomy
  - protein
  - laparoscopic repair of obstructed femoral hernia
- source_sentence: preparation of written report for lawyer
  sentences:
  - audio and visual equipment
  - product containing only gliclazide in oral dose form
  - medicolegal procedure
- source_sentence: entire ansa lenticularis
  sentences:
  - infection of tendon sheath
  - structure of ansa lenticularis
  - ambulatory surgery center
pipeline_tag: sentence-similarity
library_name: sentence-transformers
---

# HierarchyTransformer based on sentence-transformers/all-MiniLM-L12-v2

This is a [sentence-transformers](https://www.SBERT.net) model finetuned from [sentence-transformers/all-MiniLM-L12-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L12-v2). It maps sentences & paragraphs to a 384-dimensional dense vector space and can be used for semantic textual similarity, semantic search, paraphrase mining, text classification, clustering, and more.

## Model Details

### Model Description
- **Model Type:** Sentence Transformer
- **Base model:** [sentence-transformers/all-MiniLM-L12-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L12-v2) <!-- at revision c004d8e3e901237d8fa7e9fff12774962e391ce5 -->
- **Maximum Sequence Length:** 128 tokens
- **Output Dimensionality:** 384 dimensions
- **Similarity Function:** Cosine Similarity
<!-- - **Training Dataset:** Unknown -->
<!-- - **Language:** Unknown -->
<!-- - **License:** Unknown -->

### Model Sources

- **Documentation:** [Sentence Transformers Documentation](https://sbert.net)
- **Repository:** [Sentence Transformers on GitHub](https://github.com/UKPLab/sentence-transformers)
- **Hugging Face:** [Sentence Transformers on Hugging Face](https://huggingface.co/models?library=sentence-transformers)

### Full Model Architecture

```
HierarchyTransformer(
  (0): Transformer({'max_seq_length': 128, 'do_lower_case': False}) with Transformer model: BertModel 
  (1): Pooling({'word_embedding_dimension': 384, 'pooling_mode_cls_token': False, 'pooling_mode_mean_tokens': True, 'pooling_mode_max_tokens': False, 'pooling_mode_mean_sqrt_len_tokens': False, 'pooling_mode_weightedmean_tokens': False, 'pooling_mode_lasttoken': False, 'include_prompt': True})
)
```

## Usage

### Direct Usage (Sentence Transformers)

First install the Sentence Transformers library:

```bash
pip install -U sentence-transformers
```

Then you can load this model and run inference.
```python
from sentence_transformers import SentenceTransformer

# Download from the 🤗 Hub
model = SentenceTransformer("sentence_transformers_model_id")
# Run inference
sentences = [
    'entire ansa lenticularis',
    'structure of ansa lenticularis',
    'ambulatory surgery center',
]
embeddings = model.encode(sentences)
print(embeddings.shape)
# [3, 384]

# Get the similarity scores for the embeddings
similarities = model.similarity(embeddings, embeddings)
print(similarities.shape)
# [3, 3]
```

<!--
### Direct Usage (Transformers)

<details><summary>Click to see the direct usage in Transformers</summary>

</details>
-->

<!--
### Downstream Usage (Sentence Transformers)

You can finetune this model on your own dataset.

<details><summary>Click to expand</summary>

</details>
-->

<!--
### Out-of-Scope Use

*List how the model may foreseeably be misused and address what users ought not to do with the model.*
-->

<!--
## Bias, Risks and Limitations

*What are the known or foreseeable issues stemming from this model? You could also flag here known failure cases or weaknesses of the model.*
-->

<!--
### Recommendations

*What are recommendations with respect to the foreseeable issues? For example, filtering explicit content.*
-->

## Training Details

### Training Dataset

#### Unnamed Dataset

* Size: 5,566,780 training samples
* Columns: <code>child</code>, <code>parent</code>, and <code>negative</code>
* Approximate statistics based on the first 1000 samples:
  |         | child                                                                             | parent                                                                           | negative                                                                          |
  |:--------|:----------------------------------------------------------------------------------|:---------------------------------------------------------------------------------|:----------------------------------------------------------------------------------|
  | type    | string                                                                            | string                                                                           | string                                                                            |
  | details | <ul><li>min: 3 tokens</li><li>mean: 10.94 tokens</li><li>max: 33 tokens</li></ul> | <ul><li>min: 4 tokens</li><li>mean: 8.32 tokens</li><li>max: 22 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 10.14 tokens</li><li>max: 34 tokens</li></ul> |
* Samples:
  | child                                      | parent                                        | negative                                           |
  |:-------------------------------------------|:----------------------------------------------|:---------------------------------------------------|
  | <code>entire skin of shaft of penis</code> | <code>skin structure of shaft of penis</code> | <code>off-line blood photoimmunotherapy bag</code> |
  | <code>entire skin of shaft of penis</code> | <code>skin structure of shaft of penis</code> | <code>small vessel vasculitis</code>               |
  | <code>entire skin of shaft of penis</code> | <code>skin structure of shaft of penis</code> | <code>insect iridescent virus 17</code>            |
* Loss: <code>hierarchy_transformers.losses.hit_loss.HierarchyTransformerLoss</code> with these parameters:
  ```json
  {
      "distance_metric": "PoincareBall(c=0.0026041900273412466).dist and dist0",
      "HyperbolicClusteringLoss": {
          "weight": 1.0,
          "distance_metric": "PoincareBall(c=0.0026041900273412466).dist",
          "margin": 5.0
      },
      "HyperbolicCentripetalLoss": {
          "weight": 1.0,
          "distance_metric": "PoincareBall(c=0.0026041900273412466).dist0",
          "margin": 0.1
      }
  }
  ```

### Evaluation Dataset

#### Unnamed Dataset

* Size: 3,948,520 evaluation samples
* Columns: <code>child</code>, <code>parent</code>, and <code>negative</code>
* Approximate statistics based on the first 1000 samples:
  |         | child                                                                            | parent                                                                           | negative                                                                          |
  |:--------|:---------------------------------------------------------------------------------|:---------------------------------------------------------------------------------|:----------------------------------------------------------------------------------|
  | type    | string                                                                           | string                                                                           | string                                                                            |
  | details | <ul><li>min: 4 tokens</li><li>mean: 9.94 tokens</li><li>max: 24 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 8.22 tokens</li><li>max: 22 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 10.11 tokens</li><li>max: 38 tokens</li></ul> |
* Samples:
  | child                              | parent                         | negative                                                                         |
  |:-----------------------------------|:-------------------------------|:---------------------------------------------------------------------------------|
  | <code>phosphatidyl glycerol</code> | <code>phosphatidic acid</code> | <code>bone structure of patella</code>                                           |
  | <code>phosphatidyl glycerol</code> | <code>phosphatidic acid</code> | <code>familial erythrocytosis due to diphosphoglycerate mutase deficiency</code> |
  | <code>phosphatidyl glycerol</code> | <code>phosphatidic acid</code> | <code>epithelioid liposarcoma</code>                                             |
* Loss: <code>hierarchy_transformers.losses.hit_loss.HierarchyTransformerLoss</code> with these parameters:
  ```json
  {
      "distance_metric": "PoincareBall(c=0.0026041900273412466).dist and dist0",
      "HyperbolicClusteringLoss": {
          "weight": 1.0,
          "distance_metric": "PoincareBall(c=0.0026041900273412466).dist",
          "margin": 5.0
      },
      "HyperbolicCentripetalLoss": {
          "weight": 1.0,
          "distance_metric": "PoincareBall(c=0.0026041900273412466).dist0",
          "margin": 0.1
      }
  }
  ```

### Training Hyperparameters
#### Non-Default Hyperparameters

- `eval_strategy`: epoch
- `per_device_train_batch_size`: 256
- `per_device_eval_batch_size`: 512
- `learning_rate`: 1e-05
- `num_train_epochs`: 20
- `warmup_steps`: 500
- `load_best_model_at_end`: True

#### All Hyperparameters
<details><summary>Click to expand</summary>

- `overwrite_output_dir`: False
- `do_predict`: False
- `eval_strategy`: epoch
- `prediction_loss_only`: True
- `per_device_train_batch_size`: 256
- `per_device_eval_batch_size`: 512
- `per_gpu_train_batch_size`: None
- `per_gpu_eval_batch_size`: None
- `gradient_accumulation_steps`: 1
- `eval_accumulation_steps`: None
- `torch_empty_cache_steps`: None
- `learning_rate`: 1e-05
- `weight_decay`: 0.0
- `adam_beta1`: 0.9
- `adam_beta2`: 0.999
- `adam_epsilon`: 1e-08
- `max_grad_norm`: 1.0
- `num_train_epochs`: 20
- `max_steps`: -1
- `lr_scheduler_type`: linear
- `lr_scheduler_kwargs`: {}
- `warmup_ratio`: 0.0
- `warmup_steps`: 500
- `log_level`: passive
- `log_level_replica`: warning
- `log_on_each_node`: True
- `logging_nan_inf_filter`: True
- `save_safetensors`: True
- `save_on_each_node`: False
- `save_only_model`: False
- `restore_callback_states_from_checkpoint`: False
- `no_cuda`: False
- `use_cpu`: False
- `use_mps_device`: False
- `seed`: 42
- `data_seed`: None
- `jit_mode_eval`: False
- `use_ipex`: False
- `bf16`: False
- `fp16`: False
- `fp16_opt_level`: O1
- `half_precision_backend`: auto
- `bf16_full_eval`: False
- `fp16_full_eval`: False
- `tf32`: None
- `local_rank`: 0
- `ddp_backend`: None
- `tpu_num_cores`: None
- `tpu_metrics_debug`: False
- `debug`: []
- `dataloader_drop_last`: False
- `dataloader_num_workers`: 0
- `dataloader_prefetch_factor`: None
- `past_index`: -1
- `disable_tqdm`: False
- `remove_unused_columns`: True
- `label_names`: None
- `load_best_model_at_end`: True
- `ignore_data_skip`: False
- `fsdp`: []
- `fsdp_min_num_params`: 0
- `fsdp_config`: {'min_num_params': 0, 'xla': False, 'xla_fsdp_v2': False, 'xla_fsdp_grad_ckpt': False}
- `fsdp_transformer_layer_cls_to_wrap`: None
- `accelerator_config`: {'split_batches': False, 'dispatch_batches': None, 'even_batches': True, 'use_seedable_sampler': True, 'non_blocking': False, 'gradient_accumulation_kwargs': None}
- `deepspeed`: None
- `label_smoothing_factor`: 0.0
- `optim`: adamw_torch
- `optim_args`: None
- `adafactor`: False
- `group_by_length`: False
- `length_column_name`: length
- `ddp_find_unused_parameters`: None
- `ddp_bucket_cap_mb`: None
- `ddp_broadcast_buffers`: False
- `dataloader_pin_memory`: True
- `dataloader_persistent_workers`: False
- `skip_memory_metrics`: True
- `use_legacy_prediction_loop`: False
- `push_to_hub`: False
- `resume_from_checkpoint`: None
- `hub_model_id`: None
- `hub_strategy`: every_save
- `hub_private_repo`: None
- `hub_always_push`: False
- `hub_revision`: None
- `gradient_checkpointing`: False
- `gradient_checkpointing_kwargs`: None
- `include_inputs_for_metrics`: False
- `include_for_metrics`: []
- `eval_do_concat_batches`: True
- `fp16_backend`: auto
- `push_to_hub_model_id`: None
- `push_to_hub_organization`: None
- `mp_parameters`: 
- `auto_find_batch_size`: False
- `full_determinism`: False
- `torchdynamo`: None
- `ray_scope`: last
- `ddp_timeout`: 1800
- `torch_compile`: False
- `torch_compile_backend`: None
- `torch_compile_mode`: None
- `include_tokens_per_second`: False
- `include_num_input_tokens_seen`: False
- `neftune_noise_alpha`: None
- `optim_target_modules`: None
- `batch_eval_metrics`: False
- `eval_on_start`: False
- `use_liger_kernel`: False
- `liger_kernel_config`: None
- `eval_use_gather_object`: False
- `average_tokens_across_devices`: False
- `prompts`: None
- `batch_sampler`: batch_sampler
- `multi_dataset_batch_sampler`: proportional

</details>

### Training Logs
<details><summary>Click to expand</summary>

| Epoch    | Step       | Training Loss | Validation Loss |
|:--------:|:----------:|:-------------:|:---------------:|
| 0.0046   | 100        | 1.9737        | -               |
| 0.0092   | 200        | 0.9034        | -               |
| 0.0138   | 300        | 0.488         | -               |
| 0.0184   | 400        | 0.3572        | -               |
| 0.0230   | 500        | 0.2848        | -               |
| 0.0276   | 600        | 0.2458        | -               |
| 0.0322   | 700        | 0.2211        | -               |
| 0.0368   | 800        | 0.203         | -               |
| 0.0414   | 900        | 0.1864        | -               |
| 0.0460   | 1000       | 0.1873        | -               |
| 0.0506   | 1100       | 0.1636        | -               |
| 0.0552   | 1200       | 0.1654        | -               |
| 0.0598   | 1300       | 0.1573        | -               |
| 0.0644   | 1400       | 0.1535        | -               |
| 0.0690   | 1500       | 0.1525        | -               |
| 0.0736   | 1600       | 0.1358        | -               |
| 0.0782   | 1700       | 0.1372        | -               |
| 0.0828   | 1800       | 0.1365        | -               |
| 0.0874   | 1900       | 0.1306        | -               |
| 0.0920   | 2000       | 0.125         | -               |
| 0.0966   | 2100       | 0.1259        | -               |
| 0.1012   | 2200       | 0.1202        | -               |
| 0.1058   | 2300       | 0.125         | -               |
| 0.1104   | 2400       | 0.1177        | -               |
| 0.1150   | 2500       | 0.1148        | -               |
| 0.1196   | 2600       | 0.1088        | -               |
| 0.1242   | 2700       | 0.1161        | -               |
| 0.1288   | 2800       | 0.1096        | -               |
| 0.1334   | 2900       | 0.1063        | -               |
| 0.1380   | 3000       | 0.1053        | -               |
| 0.1426   | 3100       | 0.1048        | -               |
| 0.1472   | 3200       | 0.107         | -               |
| 0.1518   | 3300       | 0.1032        | -               |
| 0.1564   | 3400       | 0.0993        | -               |
| 0.1609   | 3500       | 0.0973        | -               |
| 0.1655   | 3600       | 0.0915        | -               |
| 0.1701   | 3700       | 0.093         | -               |
| 0.1747   | 3800       | 0.1001        | -               |
| 0.1793   | 3900       | 0.1009        | -               |
| 0.1839   | 4000       | 0.0945        | -               |
| 0.1885   | 4100       | 0.0948        | -               |
| 0.1931   | 4200       | 0.0896        | -               |
| 0.1977   | 4300       | 0.0917        | -               |
| 0.2023   | 4400       | 0.0887        | -               |
| 0.2069   | 4500       | 0.0864        | -               |
| 0.2115   | 4600       | 0.0869        | -               |
| 0.2161   | 4700       | 0.0811        | -               |
| 0.2207   | 4800       | 0.0915        | -               |
| 0.2253   | 4900       | 0.0829        | -               |
| 0.2299   | 5000       | 0.0873        | -               |
| 0.2345   | 5100       | 0.0852        | -               |
| 0.2391   | 5200       | 0.0776        | -               |
| 0.2437   | 5300       | 0.0831        | -               |
| 0.2483   | 5400       | 0.0864        | -               |
| 0.2529   | 5500       | 0.072         | -               |
| 0.2575   | 5600       | 0.0795        | -               |
| 0.2621   | 5700       | 0.0763        | -               |
| 0.2667   | 5800       | 0.0798        | -               |
| 0.2713   | 5900       | 0.0774        | -               |
| 0.2759   | 6000       | 0.076         | -               |
| 0.2805   | 6100       | 0.071         | -               |
| 0.2851   | 6200       | 0.07          | -               |
| 0.2897   | 6300       | 0.0796        | -               |
| 0.2943   | 6400       | 0.0774        | -               |
| 0.2989   | 6500       | 0.0688        | -               |
| 0.3035   | 6600       | 0.0741        | -               |
| 0.3081   | 6700       | 0.0762        | -               |
| 0.3127   | 6800       | 0.0702        | -               |
| 0.3173   | 6900       | 0.0736        | -               |
| 0.3219   | 7000       | 0.0713        | -               |
| 0.3265   | 7100       | 0.0653        | -               |
| 0.3311   | 7200       | 0.0732        | -               |
| 0.3357   | 7300       | 0.0679        | -               |
| 0.3403   | 7400       | 0.0702        | -               |
| 0.3449   | 7500       | 0.0726        | -               |
| 0.3495   | 7600       | 0.0653        | -               |
| 0.3541   | 7700       | 0.0666        | -               |
| 0.3587   | 7800       | 0.0676        | -               |
| 0.3633   | 7900       | 0.066         | -               |
| 0.3679   | 8000       | 0.0662        | -               |
| 0.3725   | 8100       | 0.0649        | -               |
| 0.3771   | 8200       | 0.0685        | -               |
| 0.3817   | 8300       | 0.0648        | -               |
| 0.3863   | 8400       | 0.0671        | -               |
| 0.3909   | 8500       | 0.0638        | -               |
| 0.3955   | 8600       | 0.0678        | -               |
| 0.4001   | 8700       | 0.0639        | -               |
| 0.4047   | 8800       | 0.0627        | -               |
| 0.4093   | 8900       | 0.0674        | -               |
| 0.4139   | 9000       | 0.0606        | -               |
| 0.4185   | 9100       | 0.0602        | -               |
| 0.4231   | 9200       | 0.0636        | -               |
| 0.4277   | 9300       | 0.0608        | -               |
| 0.4323   | 9400       | 0.0607        | -               |
| 0.4369   | 9500       | 0.0605        | -               |
| 0.4415   | 9600       | 0.0611        | -               |
| 0.4461   | 9700       | 0.0641        | -               |
| 0.4507   | 9800       | 0.0578        | -               |
| 0.4553   | 9900       | 0.0598        | -               |
| 0.4599   | 10000      | 0.0629        | -               |
| 0.4645   | 10100      | 0.0619        | -               |
| 0.4691   | 10200      | 0.0586        | -               |
| 0.4737   | 10300      | 0.0603        | -               |
| 0.4782   | 10400      | 0.06          | -               |
| 0.4828   | 10500      | 0.059         | -               |
| 0.4874   | 10600      | 0.059         | -               |
| 0.4920   | 10700      | 0.0561        | -               |
| 0.4966   | 10800      | 0.061         | -               |
| 0.5012   | 10900      | 0.053         | -               |
| 0.5058   | 11000      | 0.0548        | -               |
| 0.5104   | 11100      | 0.0535        | -               |
| 0.5150   | 11200      | 0.0584        | -               |
| 0.5196   | 11300      | 0.0531        | -               |
| 0.5242   | 11400      | 0.0558        | -               |
| 0.5288   | 11500      | 0.0553        | -               |
| 0.5334   | 11600      | 0.0578        | -               |
| 0.5380   | 11700      | 0.0536        | -               |
| 0.5426   | 11800      | 0.0523        | -               |
| 0.5472   | 11900      | 0.0552        | -               |
| 0.5518   | 12000      | 0.0493        | -               |
| 0.5564   | 12100      | 0.0522        | -               |
| 0.5610   | 12200      | 0.0499        | -               |
| 0.5656   | 12300      | 0.0498        | -               |
| 0.5702   | 12400      | 0.0518        | -               |
| 0.5748   | 12500      | 0.058         | -               |
| 0.5794   | 12600      | 0.0529        | -               |
| 0.5840   | 12700      | 0.0516        | -               |
| 0.5886   | 12800      | 0.0526        | -               |
| 0.5932   | 12900      | 0.0532        | -               |
| 0.5978   | 13000      | 0.0528        | -               |
| 0.6024   | 13100      | 0.0523        | -               |
| 0.6070   | 13200      | 0.0519        | -               |
| 0.6116   | 13300      | 0.0483        | -               |
| 0.6162   | 13400      | 0.0512        | -               |
| 0.6208   | 13500      | 0.0518        | -               |
| 0.6254   | 13600      | 0.0553        | -               |
| 0.6300   | 13700      | 0.0512        | -               |
| 0.6346   | 13800      | 0.053         | -               |
| 0.6392   | 13900      | 0.0526        | -               |
| 0.6438   | 14000      | 0.0476        | -               |
| 0.6484   | 14100      | 0.0484        | -               |
| 0.6530   | 14200      | 0.0479        | -               |
| 0.6576   | 14300      | 0.0439        | -               |
| 0.6622   | 14400      | 0.0498        | -               |
| 0.6668   | 14500      | 0.0523        | -               |
| 0.6714   | 14600      | 0.0487        | -               |
| 0.6760   | 14700      | 0.0482        | -               |
| 0.6806   | 14800      | 0.0479        | -               |
| 0.6852   | 14900      | 0.0471        | -               |
| 0.6898   | 15000      | 0.0481        | -               |
| 0.6944   | 15100      | 0.047         | -               |
| 0.6990   | 15200      | 0.0477        | -               |
| 0.7036   | 15300      | 0.0445        | -               |
| 0.7082   | 15400      | 0.0507        | -               |
| 0.7128   | 15500      | 0.0479        | -               |
| 0.7174   | 15600      | 0.0461        | -               |
| 0.7220   | 15700      | 0.0435        | -               |
| 0.7266   | 15800      | 0.0469        | -               |
| 0.7312   | 15900      | 0.0467        | -               |
| 0.7358   | 16000      | 0.0465        | -               |
| 0.7404   | 16100      | 0.0479        | -               |
| 0.7450   | 16200      | 0.0447        | -               |
| 0.7496   | 16300      | 0.0477        | -               |
| 0.7542   | 16400      | 0.046         | -               |
| 0.7588   | 16500      | 0.0456        | -               |
| 0.7634   | 16600      | 0.0467        | -               |
| 0.7680   | 16700      | 0.0477        | -               |
| 0.7726   | 16800      | 0.0457        | -               |
| 0.7772   | 16900      | 0.0425        | -               |
| 0.7818   | 17000      | 0.0452        | -               |
| 0.7864   | 17100      | 0.0462        | -               |
| 0.7910   | 17200      | 0.0434        | -               |
| 0.7955   | 17300      | 0.0456        | -               |
| 0.8001   | 17400      | 0.045         | -               |
| 0.8047   | 17500      | 0.0418        | -               |
| 0.8093   | 17600      | 0.0421        | -               |
| 0.8139   | 17700      | 0.0426        | -               |
| 0.8185   | 17800      | 0.0422        | -               |
| 0.8231   | 17900      | 0.0455        | -               |
| 0.8277   | 18000      | 0.0438        | -               |
| 0.8323   | 18100      | 0.0463        | -               |
| 0.8369   | 18200      | 0.0439        | -               |
| 0.8415   | 18300      | 0.0434        | -               |
| 0.8461   | 18400      | 0.046         | -               |
| 0.8507   | 18500      | 0.0439        | -               |
| 0.8553   | 18600      | 0.0406        | -               |
| 0.8599   | 18700      | 0.0406        | -               |
| 0.8645   | 18800      | 0.0429        | -               |
| 0.8691   | 18900      | 0.0411        | -               |
| 0.8737   | 19000      | 0.042         | -               |
| 0.8783   | 19100      | 0.041         | -               |
| 0.8829   | 19200      | 0.0399        | -               |
| 0.8875   | 19300      | 0.0405        | -               |
| 0.8921   | 19400      | 0.0409        | -               |
| 0.8967   | 19500      | 0.0397        | -               |
| 0.9013   | 19600      | 0.0417        | -               |
| 0.9059   | 19700      | 0.0453        | -               |
| 0.9105   | 19800      | 0.0387        | -               |
| 0.9151   | 19900      | 0.0414        | -               |
| 0.9197   | 20000      | 0.0399        | -               |
| 0.9243   | 20100      | 0.0417        | -               |
| 0.9289   | 20200      | 0.0423        | -               |
| 0.9335   | 20300      | 0.0409        | -               |
| 0.9381   | 20400      | 0.0418        | -               |
| 0.9427   | 20500      | 0.0391        | -               |
| 0.9473   | 20600      | 0.0396        | -               |
| 0.9519   | 20700      | 0.0386        | -               |
| 0.9565   | 20800      | 0.0422        | -               |
| 0.9611   | 20900      | 0.0363        | -               |
| 0.9657   | 21000      | 0.0424        | -               |
| 0.9703   | 21100      | 0.0427        | -               |
| 0.9749   | 21200      | 0.0375        | -               |
| 0.9795   | 21300      | 0.041         | -               |
| 0.9841   | 21400      | 0.0416        | -               |
| 0.9887   | 21500      | 0.0414        | -               |
| 0.9933   | 21600      | 0.0382        | -               |
| 0.9979   | 21700      | 0.039         | -               |
| 1.0      | 21746      | -             | 0.2740          |
| 1.0025   | 21800      | 0.0353        | -               |
| 1.0071   | 21900      | 0.0333        | -               |
| 1.0117   | 22000      | 0.0319        | -               |
| 1.0163   | 22100      | 0.0377        | -               |
| 1.0209   | 22200      | 0.0376        | -               |
| 1.0255   | 22300      | 0.0343        | -               |
| 1.0301   | 22400      | 0.0338        | -               |
| 1.0347   | 22500      | 0.032         | -               |
| 1.0393   | 22600      | 0.036         | -               |
| 1.0439   | 22700      | 0.0329        | -               |
| 1.0485   | 22800      | 0.0392        | -               |
| 1.0531   | 22900      | 0.034         | -               |
| 1.0577   | 23000      | 0.0332        | -               |
| 1.0623   | 23100      | 0.0335        | -               |
| 1.0669   | 23200      | 0.037         | -               |
| 1.0715   | 23300      | 0.0319        | -               |
| 1.0761   | 23400      | 0.0351        | -               |
| 1.0807   | 23500      | 0.0304        | -               |
| 1.0853   | 23600      | 0.0328        | -               |
| 1.0899   | 23700      | 0.0331        | -               |
| 1.0945   | 23800      | 0.0339        | -               |
| 1.0991   | 23900      | 0.0357        | -               |
| 1.1037   | 24000      | 0.0329        | -               |
| 1.1082   | 24100      | 0.0355        | -               |
| 1.1128   | 24200      | 0.0322        | -               |
| 1.1174   | 24300      | 0.0315        | -               |
| 1.1220   | 24400      | 0.0314        | -               |
| 1.1266   | 24500      | 0.0345        | -               |
| 1.1312   | 24600      | 0.0351        | -               |
| 1.1358   | 24700      | 0.0347        | -               |
| 1.1404   | 24800      | 0.0333        | -               |
| 1.1450   | 24900      | 0.0343        | -               |
| 1.1496   | 25000      | 0.0308        | -               |
| 1.1542   | 25100      | 0.0309        | -               |
| 1.1588   | 25200      | 0.0338        | -               |
| 1.1634   | 25300      | 0.0347        | -               |
| 1.1680   | 25400      | 0.0323        | -               |
| 1.1726   | 25500      | 0.0333        | -               |
| 1.1772   | 25600      | 0.031         | -               |
| 1.1818   | 25700      | 0.031         | -               |
| 1.1864   | 25800      | 0.0327        | -               |
| 1.1910   | 25900      | 0.0306        | -               |
| 1.1956   | 26000      | 0.029         | -               |
| 1.2002   | 26100      | 0.0327        | -               |
| 1.2048   | 26200      | 0.0316        | -               |
| 1.2094   | 26300      | 0.0298        | -               |
| 1.2140   | 26400      | 0.0293        | -               |
| 1.2186   | 26500      | 0.031         | -               |
| 1.2232   | 26600      | 0.0334        | -               |
| 1.2278   | 26700      | 0.0289        | -               |
| 1.2324   | 26800      | 0.0341        | -               |
| 1.2370   | 26900      | 0.0313        | -               |
| 1.2416   | 27000      | 0.0287        | -               |
| 1.2462   | 27100      | 0.0316        | -               |
| 1.2508   | 27200      | 0.0307        | -               |
| 1.2554   | 27300      | 0.0308        | -               |
| 1.2600   | 27400      | 0.0274        | -               |
| 1.2646   | 27500      | 0.0331        | -               |
| 1.2692   | 27600      | 0.0309        | -               |
| 1.2738   | 27700      | 0.0314        | -               |
| 1.2784   | 27800      | 0.0312        | -               |
| 1.2830   | 27900      | 0.0302        | -               |
| 1.2876   | 28000      | 0.0303        | -               |
| 1.2922   | 28100      | 0.0333        | -               |
| 1.2968   | 28200      | 0.0288        | -               |
| 1.3014   | 28300      | 0.0308        | -               |
| 1.3060   | 28400      | 0.0301        | -               |
| 1.3106   | 28500      | 0.0313        | -               |
| 1.3152   | 28600      | 0.0279        | -               |
| 1.3198   | 28700      | 0.0285        | -               |
| 1.3244   | 28800      | 0.0316        | -               |
| 1.3290   | 28900      | 0.0303        | -               |
| 1.3336   | 29000      | 0.0294        | -               |
| 1.3382   | 29100      | 0.0328        | -               |
| 1.3428   | 29200      | 0.0301        | -               |
| 1.3474   | 29300      | 0.0299        | -               |
| 1.3520   | 29400      | 0.0311        | -               |
| 1.3566   | 29500      | 0.0304        | -               |
| 1.3612   | 29600      | 0.0309        | -               |
| 1.3658   | 29700      | 0.03          | -               |
| 1.3704   | 29800      | 0.0304        | -               |
| 1.3750   | 29900      | 0.0288        | -               |
| 1.3796   | 30000      | 0.0285        | -               |
| 1.3842   | 30100      | 0.03          | -               |
| 1.3888   | 30200      | 0.0318        | -               |
| 1.3934   | 30300      | 0.0303        | -               |
| 1.3980   | 30400      | 0.0325        | -               |
| 1.4026   | 30500      | 0.0276        | -               |
| 1.4072   | 30600      | 0.0283        | -               |
| 1.4118   | 30700      | 0.0262        | -               |
| 1.4164   | 30800      | 0.0267        | -               |
| 1.4210   | 30900      | 0.0316        | -               |
| 1.4255   | 31000      | 0.0251        | -               |
| 1.4301   | 31100      | 0.0284        | -               |
| 1.4347   | 31200      | 0.0281        | -               |
| 1.4393   | 31300      | 0.0291        | -               |
| 1.4439   | 31400      | 0.0292        | -               |
| 1.4485   | 31500      | 0.0294        | -               |
| 1.4531   | 31600      | 0.0287        | -               |
| 1.4577   | 31700      | 0.0275        | -               |
| 1.4623   | 31800      | 0.0286        | -               |
| 1.4669   | 31900      | 0.0291        | -               |
| 1.4715   | 32000      | 0.0287        | -               |
| 1.4761   | 32100      | 0.0278        | -               |
| 1.4807   | 32200      | 0.0275        | -               |
| 1.4853   | 32300      | 0.0288        | -               |
| 1.4899   | 32400      | 0.0298        | -               |
| 1.4945   | 32500      | 0.0292        | -               |
| 1.4991   | 32600      | 0.0312        | -               |
| 1.5037   | 32700      | 0.0288        | -               |
| 1.5083   | 32800      | 0.0274        | -               |
| 1.5129   | 32900      | 0.0309        | -               |
| 1.5175   | 33000      | 0.0277        | -               |
| 1.5221   | 33100      | 0.0273        | -               |
| 1.5267   | 33200      | 0.0254        | -               |
| 1.5313   | 33300      | 0.0256        | -               |
| 1.5359   | 33400      | 0.0289        | -               |
| 1.5405   | 33500      | 0.0279        | -               |
| 1.5451   | 33600      | 0.0261        | -               |
| 1.5497   | 33700      | 0.0275        | -               |
| 1.5543   | 33800      | 0.0273        | -               |
| 1.5589   | 33900      | 0.026         | -               |
| 1.5635   | 34000      | 0.0283        | -               |
| 1.5681   | 34100      | 0.0271        | -               |
| 1.5727   | 34200      | 0.0248        | -               |
| 1.5773   | 34300      | 0.0279        | -               |
| 1.5819   | 34400      | 0.0259        | -               |
| 1.5865   | 34500      | 0.0268        | -               |
| 1.5911   | 34600      | 0.0267        | -               |
| 1.5957   | 34700      | 0.0252        | -               |
| 1.6003   | 34800      | 0.0241        | -               |
| 1.6049   | 34900      | 0.0266        | -               |
| 1.6095   | 35000      | 0.0268        | -               |
| 1.6141   | 35100      | 0.0279        | -               |
| 1.6187   | 35200      | 0.0297        | -               |
| 1.6233   | 35300      | 0.0313        | -               |
| 1.6279   | 35400      | 0.0289        | -               |
| 1.6325   | 35500      | 0.0248        | -               |
| 1.6371   | 35600      | 0.0244        | -               |
| 1.6417   | 35700      | 0.0289        | -               |
| 1.6463   | 35800      | 0.0278        | -               |
| 1.6509   | 35900      | 0.0264        | -               |
| 1.6555   | 36000      | 0.0244        | -               |
| 1.6601   | 36100      | 0.0237        | -               |
| 1.6647   | 36200      | 0.0291        | -               |
| 1.6693   | 36300      | 0.0246        | -               |
| 1.6739   | 36400      | 0.0295        | -               |
| 1.6785   | 36500      | 0.0275        | -               |
| 1.6831   | 36600      | 0.0233        | -               |
| 1.6877   | 36700      | 0.0284        | -               |
| 1.6923   | 36800      | 0.0251        | -               |
| 1.6969   | 36900      | 0.0284        | -               |
| 1.7015   | 37000      | 0.0272        | -               |
| 1.7061   | 37100      | 0.025         | -               |
| 1.7107   | 37200      | 0.025         | -               |
| 1.7153   | 37300      | 0.0254        | -               |
| 1.7199   | 37400      | 0.0262        | -               |
| 1.7245   | 37500      | 0.0276        | -               |
| 1.7291   | 37600      | 0.0272        | -               |
| 1.7337   | 37700      | 0.0272        | -               |
| 1.7383   | 37800      | 0.0248        | -               |
| 1.7428   | 37900      | 0.0259        | -               |
| 1.7474   | 38000      | 0.025         | -               |
| 1.7520   | 38100      | 0.0251        | -               |
| 1.7566   | 38200      | 0.0254        | -               |
| 1.7612   | 38300      | 0.0249        | -               |
| 1.7658   | 38400      | 0.0235        | -               |
| 1.7704   | 38500      | 0.0248        | -               |
| 1.7750   | 38600      | 0.0274        | -               |
| 1.7796   | 38700      | 0.0277        | -               |
| 1.7842   | 38800      | 0.0252        | -               |
| 1.7888   | 38900      | 0.0228        | -               |
| 1.7934   | 39000      | 0.0265        | -               |
| 1.7980   | 39100      | 0.0245        | -               |
| 1.8026   | 39200      | 0.0217        | -               |
| 1.8072   | 39300      | 0.0235        | -               |
| 1.8118   | 39400      | 0.0238        | -               |
| 1.8164   | 39500      | 0.0247        | -               |
| 1.8210   | 39600      | 0.0233        | -               |
| 1.8256   | 39700      | 0.0219        | -               |
| 1.8302   | 39800      | 0.0273        | -               |
| 1.8348   | 39900      | 0.026         | -               |
| 1.8394   | 40000      | 0.025         | -               |
| 1.8440   | 40100      | 0.027         | -               |
| 1.8486   | 40200      | 0.0232        | -               |
| 1.8532   | 40300      | 0.0238        | -               |
| 1.8578   | 40400      | 0.0245        | -               |
| 1.8624   | 40500      | 0.024         | -               |
| 1.8670   | 40600      | 0.0258        | -               |
| 1.8716   | 40700      | 0.0253        | -               |
| 1.8762   | 40800      | 0.0237        | -               |
| 1.8808   | 40900      | 0.0247        | -               |
| 1.8854   | 41000      | 0.0235        | -               |
| 1.8900   | 41100      | 0.0245        | -               |
| 1.8946   | 41200      | 0.0258        | -               |
| 1.8992   | 41300      | 0.0247        | -               |
| 1.9038   | 41400      | 0.024         | -               |
| 1.9084   | 41500      | 0.0229        | -               |
| 1.9130   | 41600      | 0.028         | -               |
| 1.9176   | 41700      | 0.0251        | -               |
| 1.9222   | 41800      | 0.0238        | -               |
| 1.9268   | 41900      | 0.0241        | -               |
| 1.9314   | 42000      | 0.0248        | -               |
| 1.9360   | 42100      | 0.0233        | -               |
| 1.9406   | 42200      | 0.0203        | -               |
| 1.9452   | 42300      | 0.0219        | -               |
| 1.9498   | 42400      | 0.0229        | -               |
| 1.9544   | 42500      | 0.0242        | -               |
| 1.9590   | 42600      | 0.0238        | -               |
| 1.9636   | 42700      | 0.0233        | -               |
| 1.9682   | 42800      | 0.0227        | -               |
| 1.9728   | 42900      | 0.0257        | -               |
| 1.9774   | 43000      | 0.0227        | -               |
| 1.9820   | 43100      | 0.0217        | -               |
| 1.9866   | 43200      | 0.0227        | -               |
| 1.9912   | 43300      | 0.024         | -               |
| 1.9958   | 43400      | 0.0235        | -               |
| 2.0      | 43492      | -             | 0.1816          |
| 2.0004   | 43500      | 0.0223        | -               |
| 2.0050   | 43600      | 0.0184        | -               |
| 2.0096   | 43700      | 0.0172        | -               |
| 2.0142   | 43800      | 0.0216        | -               |
| 2.0188   | 43900      | 0.0201        | -               |
| 2.0234   | 44000      | 0.0195        | -               |
| 2.0280   | 44100      | 0.018         | -               |
| 2.0326   | 44200      | 0.0188        | -               |
| 2.0372   | 44300      | 0.0206        | -               |
| 2.0418   | 44400      | 0.0223        | -               |
| 2.0464   | 44500      | 0.0206        | -               |
| 2.0510   | 44600      | 0.0213        | -               |
| 2.0556   | 44700      | 0.0194        | -               |
| 2.0601   | 44800      | 0.0201        | -               |
| 2.0647   | 44900      | 0.0187        | -               |
| 2.0693   | 45000      | 0.0182        | -               |
| 2.0739   | 45100      | 0.0194        | -               |
| 2.0785   | 45200      | 0.0199        | -               |
| 2.0831   | 45300      | 0.0177        | -               |
| 2.0877   | 45400      | 0.022         | -               |
| 2.0923   | 45500      | 0.0207        | -               |
| 2.0969   | 45600      | 0.0201        | -               |
| 2.1015   | 45700      | 0.0203        | -               |
| 2.1061   | 45800      | 0.0199        | -               |
| 2.1107   | 45900      | 0.0182        | -               |
| 2.1153   | 46000      | 0.0189        | -               |
| 2.1199   | 46100      | 0.022         | -               |
| 2.1245   | 46200      | 0.0201        | -               |
| 2.1291   | 46300      | 0.0175        | -               |
| 2.1337   | 46400      | 0.0193        | -               |
| 2.1383   | 46500      | 0.0198        | -               |
| 2.1429   | 46600      | 0.0196        | -               |
| 2.1475   | 46700      | 0.0191        | -               |
| 2.1521   | 46800      | 0.0193        | -               |
| 2.1567   | 46900      | 0.0222        | -               |
| 2.1613   | 47000      | 0.0199        | -               |
| 2.1659   | 47100      | 0.0206        | -               |
| 2.1705   | 47200      | 0.0206        | -               |
| 2.1751   | 47300      | 0.0201        | -               |
| 2.1797   | 47400      | 0.0201        | -               |
| 2.1843   | 47500      | 0.0184        | -               |
| 2.1889   | 47600      | 0.0193        | -               |
| 2.1935   | 47700      | 0.0171        | -               |
| 2.1981   | 47800      | 0.0187        | -               |
| 2.2027   | 47900      | 0.0192        | -               |
| 2.2073   | 48000      | 0.0198        | -               |
| 2.2119   | 48100      | 0.0187        | -               |
| 2.2165   | 48200      | 0.021         | -               |
| 2.2211   | 48300      | 0.0168        | -               |
| 2.2257   | 48400      | 0.0178        | -               |
| 2.2303   | 48500      | 0.0191        | -               |
| 2.2349   | 48600      | 0.0194        | -               |
| 2.2395   | 48700      | 0.0205        | -               |
| 2.2441   | 48800      | 0.0204        | -               |
| 2.2487   | 48900      | 0.0195        | -               |
| 2.2533   | 49000      | 0.019         | -               |
| 2.2579   | 49100      | 0.02          | -               |
| 2.2625   | 49200      | 0.0183        | -               |
| 2.2671   | 49300      | 0.0185        | -               |
| 2.2717   | 49400      | 0.0221        | -               |
| 2.2763   | 49500      | 0.0191        | -               |
| 2.2809   | 49600      | 0.0177        | -               |
| 2.2855   | 49700      | 0.0195        | -               |
| 2.2901   | 49800      | 0.0188        | -               |
| 2.2947   | 49900      | 0.0199        | -               |
| 2.2993   | 50000      | 0.0171        | -               |
| 2.3039   | 50100      | 0.0189        | -               |
| 2.3085   | 50200      | 0.0204        | -               |
| 2.3131   | 50300      | 0.0196        | -               |
| 2.3177   | 50400      | 0.0167        | -               |
| 2.3223   | 50500      | 0.0193        | -               |
| 2.3269   | 50600      | 0.019         | -               |
| 2.3315   | 50700      | 0.0191        | -               |
| 2.3361   | 50800      | 0.019         | -               |
| 2.3407   | 50900      | 0.0185        | -               |
| 2.3453   | 51000      | 0.022         | -               |
| 2.3499   | 51100      | 0.0192        | -               |
| 2.3545   | 51200      | 0.0215        | -               |
| 2.3591   | 51300      | 0.0178        | -               |
| 2.3637   | 51400      | 0.0174        | -               |
| 2.3683   | 51500      | 0.0166        | -               |
| 2.3729   | 51600      | 0.018         | -               |
| 2.3774   | 51700      | 0.0197        | -               |
| 2.3820   | 51800      | 0.0171        | -               |
| 2.3866   | 51900      | 0.0206        | -               |
| 2.3912   | 52000      | 0.0138        | -               |
| 2.3958   | 52100      | 0.019         | -               |
| 2.4004   | 52200      | 0.0172        | -               |
| 2.4050   | 52300      | 0.0183        | -               |
| 2.4096   | 52400      | 0.0199        | -               |
| 2.4142   | 52500      | 0.0165        | -               |
| 2.4188   | 52600      | 0.0179        | -               |
| 2.4234   | 52700      | 0.017         | -               |
| 2.4280   | 52800      | 0.0186        | -               |
| 2.4326   | 52900      | 0.0187        | -               |
| 2.4372   | 53000      | 0.0183        | -               |
| 2.4418   | 53100      | 0.019         | -               |
| 2.4464   | 53200      | 0.0189        | -               |
| 2.4510   | 53300      | 0.018         | -               |
| 2.4556   | 53400      | 0.0166        | -               |
| 2.4602   | 53500      | 0.0179        | -               |
| 2.4648   | 53600      | 0.0183        | -               |
| 2.4694   | 53700      | 0.0194        | -               |
| 2.4740   | 53800      | 0.0183        | -               |
| 2.4786   | 53900      | 0.019         | -               |
| 2.4832   | 54000      | 0.0166        | -               |
| 2.4878   | 54100      | 0.0183        | -               |
| 2.4924   | 54200      | 0.0162        | -               |
| 2.4970   | 54300      | 0.0181        | -               |
| 2.5016   | 54400      | 0.0184        | -               |
| 2.5062   | 54500      | 0.0172        | -               |
| 2.5108   | 54600      | 0.0175        | -               |
| 2.5154   | 54700      | 0.0162        | -               |
| 2.5200   | 54800      | 0.0204        | -               |
| 2.5246   | 54900      | 0.0173        | -               |
| 2.5292   | 55000      | 0.0174        | -               |
| 2.5338   | 55100      | 0.0199        | -               |
| 2.5384   | 55200      | 0.0198        | -               |
| 2.5430   | 55300      | 0.0173        | -               |
| 2.5476   | 55400      | 0.0173        | -               |
| 2.5522   | 55500      | 0.0177        | -               |
| 2.5568   | 55600      | 0.0147        | -               |
| 2.5614   | 55700      | 0.0182        | -               |
| 2.5660   | 55800      | 0.0186        | -               |
| 2.5706   | 55900      | 0.0188        | -               |
| 2.5752   | 56000      | 0.0183        | -               |
| 2.5798   | 56100      | 0.0182        | -               |
| 2.5844   | 56200      | 0.0191        | -               |
| 2.5890   | 56300      | 0.0194        | -               |
| 2.5936   | 56400      | 0.0175        | -               |
| 2.5982   | 56500      | 0.0162        | -               |
| 2.6028   | 56600      | 0.0172        | -               |
| 2.6074   | 56700      | 0.0181        | -               |
| 2.6120   | 56800      | 0.0181        | -               |
| 2.6166   | 56900      | 0.0169        | -               |
| 2.6212   | 57000      | 0.0163        | -               |
| 2.6258   | 57100      | 0.0149        | -               |
| 2.6304   | 57200      | 0.0205        | -               |
| 2.6350   | 57300      | 0.0187        | -               |
| 2.6396   | 57400      | 0.0178        | -               |
| 2.6442   | 57500      | 0.0189        | -               |
| 2.6488   | 57600      | 0.0165        | -               |
| 2.6534   | 57700      | 0.0182        | -               |
| 2.6580   | 57800      | 0.0181        | -               |
| 2.6626   | 57900      | 0.0193        | -               |
| 2.6672   | 58000      | 0.0191        | -               |
| 2.6718   | 58100      | 0.0173        | -               |
| 2.6764   | 58200      | 0.02          | -               |
| 2.6810   | 58300      | 0.0173        | -               |
| 2.6856   | 58400      | 0.0188        | -               |
| 2.6901   | 58500      | 0.0174        | -               |
| 2.6947   | 58600      | 0.0174        | -               |
| 2.6993   | 58700      | 0.0184        | -               |
| 2.7039   | 58800      | 0.016         | -               |
| 2.7085   | 58900      | 0.0177        | -               |
| 2.7131   | 59000      | 0.0156        | -               |
| 2.7177   | 59100      | 0.0168        | -               |
| 2.7223   | 59200      | 0.0159        | -               |
| 2.7269   | 59300      | 0.0167        | -               |
| 2.7315   | 59400      | 0.016         | -               |
| 2.7361   | 59500      | 0.0181        | -               |
| 2.7407   | 59600      | 0.0179        | -               |
| 2.7453   | 59700      | 0.0195        | -               |
| 2.7499   | 59800      | 0.0158        | -               |
| 2.7545   | 59900      | 0.0173        | -               |
| 2.7591   | 60000      | 0.0159        | -               |
| 2.7637   | 60100      | 0.0171        | -               |
| 2.7683   | 60200      | 0.018         | -               |
| 2.7729   | 60300      | 0.0154        | -               |
| 2.7775   | 60400      | 0.0168        | -               |
| 2.7821   | 60500      | 0.0172        | -               |
| 2.7867   | 60600      | 0.0189        | -               |
| 2.7913   | 60700      | 0.017         | -               |
| 2.7959   | 60800      | 0.0169        | -               |
| 2.8005   | 60900      | 0.0189        | -               |
| 2.8051   | 61000      | 0.0182        | -               |
| 2.8097   | 61100      | 0.0176        | -               |
| 2.8143   | 61200      | 0.0178        | -               |
| 2.8189   | 61300      | 0.0161        | -               |
| 2.8235   | 61400      | 0.0155        | -               |
| 2.8281   | 61500      | 0.0181        | -               |
| 2.8327   | 61600      | 0.0185        | -               |
| 2.8373   | 61700      | 0.0167        | -               |
| 2.8419   | 61800      | 0.0166        | -               |
| 2.8465   | 61900      | 0.0159        | -               |
| 2.8511   | 62000      | 0.0159        | -               |
| 2.8557   | 62100      | 0.0188        | -               |
| 2.8603   | 62200      | 0.0163        | -               |
| 2.8649   | 62300      | 0.0177        | -               |
| 2.8695   | 62400      | 0.0175        | -               |
| 2.8741   | 62500      | 0.0161        | -               |
| 2.8787   | 62600      | 0.0169        | -               |
| 2.8833   | 62700      | 0.016         | -               |
| 2.8879   | 62800      | 0.0162        | -               |
| 2.8925   | 62900      | 0.0166        | -               |
| 2.8971   | 63000      | 0.0156        | -               |
| 2.9017   | 63100      | 0.0187        | -               |
| 2.9063   | 63200      | 0.0202        | -               |
| 2.9109   | 63300      | 0.0146        | -               |
| 2.9155   | 63400      | 0.0171        | -               |
| 2.9201   | 63500      | 0.0176        | -               |
| 2.9247   | 63600      | 0.0164        | -               |
| 2.9293   | 63700      | 0.0144        | -               |
| 2.9339   | 63800      | 0.0171        | -               |
| 2.9385   | 63900      | 0.017         | -               |
| 2.9431   | 64000      | 0.0184        | -               |
| 2.9477   | 64100      | 0.0171        | -               |
| 2.9523   | 64200      | 0.0152        | -               |
| 2.9569   | 64300      | 0.0174        | -               |
| 2.9615   | 64400      | 0.0164        | -               |
| 2.9661   | 64500      | 0.0161        | -               |
| 2.9707   | 64600      | 0.0176        | -               |
| 2.9753   | 64700      | 0.0168        | -               |
| 2.9799   | 64800      | 0.0168        | -               |
| 2.9845   | 64900      | 0.018         | -               |
| 2.9891   | 65000      | 0.0147        | -               |
| 2.9937   | 65100      | 0.019         | -               |
| 2.9983   | 65200      | 0.0144        | -               |
| 3.0      | 65238      | -             | 0.1239          |
| 3.0029   | 65300      | 0.0147        | -               |
| 3.0074   | 65400      | 0.0145        | -               |
| 3.0120   | 65500      | 0.0123        | -               |
| 3.0166   | 65600      | 0.0136        | -               |
| 3.0212   | 65700      | 0.014         | -               |
| 3.0258   | 65800      | 0.0116        | -               |
| 3.0304   | 65900      | 0.0157        | -               |
| 3.0350   | 66000      | 0.0124        | -               |
| 3.0396   | 66100      | 0.013         | -               |
| 3.0442   | 66200      | 0.014         | -               |
| 3.0488   | 66300      | 0.0127        | -               |
| 3.0534   | 66400      | 0.0151        | -               |
| 3.0580   | 66500      | 0.0126        | -               |
| 3.0626   | 66600      | 0.0137        | -               |
| 3.0672   | 66700      | 0.0138        | -               |
| 3.0718   | 66800      | 0.0127        | -               |
| 3.0764   | 66900      | 0.0145        | -               |
| 3.0810   | 67000      | 0.0131        | -               |
| 3.0856   | 67100      | 0.0128        | -               |
| 3.0902   | 67200      | 0.0151        | -               |
| 3.0948   | 67300      | 0.0131        | -               |
| 3.0994   | 67400      | 0.0153        | -               |
| 3.1040   | 67500      | 0.0144        | -               |
| 3.1086   | 67600      | 0.0123        | -               |
| 3.1132   | 67700      | 0.0141        | -               |
| 3.1178   | 67800      | 0.0127        | -               |
| 3.1224   | 67900      | 0.0154        | -               |
| 3.1270   | 68000      | 0.015         | -               |
| 3.1316   | 68100      | 0.013         | -               |
| 3.1362   | 68200      | 0.0156        | -               |
| 3.1408   | 68300      | 0.0138        | -               |
| 3.1454   | 68400      | 0.016         | -               |
| 3.1500   | 68500      | 0.013         | -               |
| 3.1546   | 68600      | 0.0141        | -               |
| 3.1592   | 68700      | 0.0141        | -               |
| 3.1638   | 68800      | 0.0142        | -               |
| 3.1684   | 68900      | 0.0133        | -               |
| 3.1730   | 69000      | 0.0129        | -               |
| 3.1776   | 69100      | 0.012         | -               |
| 3.1822   | 69200      | 0.0135        | -               |
| 3.1868   | 69300      | 0.0145        | -               |
| 3.1914   | 69400      | 0.0137        | -               |
| 3.1960   | 69500      | 0.0143        | -               |
| 3.2006   | 69600      | 0.0118        | -               |
| 3.2052   | 69700      | 0.0149        | -               |
| 3.2098   | 69800      | 0.0127        | -               |
| 3.2144   | 69900      | 0.0127        | -               |
| 3.2190   | 70000      | 0.0148        | -               |
| 3.2236   | 70100      | 0.0134        | -               |
| 3.2282   | 70200      | 0.0133        | -               |
| 3.2328   | 70300      | 0.0112        | -               |
| 3.2374   | 70400      | 0.0137        | -               |
| 3.2420   | 70500      | 0.0138        | -               |
| 3.2466   | 70600      | 0.0135        | -               |
| 3.2512   | 70700      | 0.0131        | -               |
| 3.2558   | 70800      | 0.0138        | -               |
| 3.2604   | 70900      | 0.0122        | -               |
| 3.2650   | 71000      | 0.013         | -               |
| 3.2696   | 71100      | 0.0132        | -               |
| 3.2742   | 71200      | 0.0157        | -               |
| 3.2788   | 71300      | 0.0132        | -               |
| 3.2834   | 71400      | 0.0129        | -               |
| 3.2880   | 71500      | 0.0138        | -               |
| 3.2926   | 71600      | 0.013         | -               |
| 3.2972   | 71700      | 0.0129        | -               |
| 3.3018   | 71800      | 0.0137        | -               |
| 3.3064   | 71900      | 0.0137        | -               |
| 3.3110   | 72000      | 0.013         | -               |
| 3.3156   | 72100      | 0.0129        | -               |
| 3.3202   | 72200      | 0.0132        | -               |
| 3.3247   | 72300      | 0.0134        | -               |
| 3.3293   | 72400      | 0.0135        | -               |
| 3.3339   | 72500      | 0.0148        | -               |
| 3.3385   | 72600      | 0.0151        | -               |
| 3.3431   | 72700      | 0.0123        | -               |
| 3.3477   | 72800      | 0.0134        | -               |
| 3.3523   | 72900      | 0.0118        | -               |
| 3.3569   | 73000      | 0.0123        | -               |
| 3.3615   | 73100      | 0.0144        | -               |
| 3.3661   | 73200      | 0.0136        | -               |
| 3.3707   | 73300      | 0.014         | -               |
| 3.3753   | 73400      | 0.0122        | -               |
| 3.3799   | 73500      | 0.0133        | -               |
| 3.3845   | 73600      | 0.0125        | -               |
| 3.3891   | 73700      | 0.0141        | -               |
| 3.3937   | 73800      | 0.0126        | -               |
| 3.3983   | 73900      | 0.012         | -               |
| 3.4029   | 74000      | 0.0123        | -               |
| 3.4075   | 74100      | 0.0121        | -               |
| 3.4121   | 74200      | 0.0133        | -               |
| 3.4167   | 74300      | 0.0133        | -               |
| 3.4213   | 74400      | 0.013         | -               |
| 3.4259   | 74500      | 0.0134        | -               |
| 3.4305   | 74600      | 0.012         | -               |
| 3.4351   | 74700      | 0.0132        | -               |
| 3.4397   | 74800      | 0.0132        | -               |
| 3.4443   | 74900      | 0.0144        | -               |
| 3.4489   | 75000      | 0.0132        | -               |
| 3.4535   | 75100      | 0.0138        | -               |
| 3.4581   | 75200      | 0.0132        | -               |
| 3.4627   | 75300      | 0.0128        | -               |
| 3.4673   | 75400      | 0.0154        | -               |
| 3.4719   | 75500      | 0.0131        | -               |
| 3.4765   | 75600      | 0.0133        | -               |
| 3.4811   | 75700      | 0.0115        | -               |
| 3.4857   | 75800      | 0.0116        | -               |
| 3.4903   | 75900      | 0.013         | -               |
| 3.4949   | 76000      | 0.0119        | -               |
| 3.4995   | 76100      | 0.0126        | -               |
| 3.5041   | 76200      | 0.0122        | -               |
| 3.5087   | 76300      | 0.0109        | -               |
| 3.5133   | 76400      | 0.0124        | -               |
| 3.5179   | 76500      | 0.0128        | -               |
| 3.5225   | 76600      | 0.0128        | -               |
| 3.5271   | 76700      | 0.0119        | -               |
| 3.5317   | 76800      | 0.0145        | -               |
| 3.5363   | 76900      | 0.0149        | -               |
| 3.5409   | 77000      | 0.0117        | -               |
| 3.5455   | 77100      | 0.0125        | -               |
| 3.5501   | 77200      | 0.0145        | -               |
| 3.5547   | 77300      | 0.0137        | -               |
| 3.5593   | 77400      | 0.0131        | -               |
| 3.5639   | 77500      | 0.0142        | -               |
| 3.5685   | 77600      | 0.0116        | -               |
| 3.5731   | 77700      | 0.0124        | -               |
| 3.5777   | 77800      | 0.0125        | -               |
| 3.5823   | 77900      | 0.0136        | -               |
| 3.5869   | 78000      | 0.0121        | -               |
| 3.5915   | 78100      | 0.0122        | -               |
| 3.5961   | 78200      | 0.0127        | -               |
| 3.6007   | 78300      | 0.0127        | -               |
| 3.6053   | 78400      | 0.0132        | -               |
| 3.6099   | 78500      | 0.0125        | -               |
| 3.6145   | 78600      | 0.0134        | -               |
| 3.6191   | 78700      | 0.0134        | -               |
| 3.6237   | 78800      | 0.013         | -               |
| 3.6283   | 78900      | 0.0127        | -               |
| 3.6329   | 79000      | 0.013         | -               |
| 3.6375   | 79100      | 0.0145        | -               |
| 3.6420   | 79200      | 0.0131        | -               |
| 3.6466   | 79300      | 0.0136        | -               |
| 3.6512   | 79400      | 0.0117        | -               |
| 3.6558   | 79500      | 0.013         | -               |
| 3.6604   | 79600      | 0.0143        | -               |
| 3.6650   | 79700      | 0.0129        | -               |
| 3.6696   | 79800      | 0.0118        | -               |
| 3.6742   | 79900      | 0.012         | -               |
| 3.6788   | 80000      | 0.0132        | -               |
| 3.6834   | 80100      | 0.0142        | -               |
| 3.6880   | 80200      | 0.0114        | -               |
| 3.6926   | 80300      | 0.0129        | -               |
| 3.6972   | 80400      | 0.012         | -               |
| 3.7018   | 80500      | 0.0113        | -               |
| 3.7064   | 80600      | 0.0136        | -               |
| 3.7110   | 80700      | 0.0152        | -               |
| 3.7156   | 80800      | 0.0117        | -               |
| 3.7202   | 80900      | 0.012         | -               |
| 3.7248   | 81000      | 0.0115        | -               |
| 3.7294   | 81100      | 0.0127        | -               |
| 3.7340   | 81200      | 0.0108        | -               |
| 3.7386   | 81300      | 0.0133        | -               |
| 3.7432   | 81400      | 0.0112        | -               |
| 3.7478   | 81500      | 0.0113        | -               |
| 3.7524   | 81600      | 0.0113        | -               |
| 3.7570   | 81700      | 0.0124        | -               |
| 3.7616   | 81800      | 0.0132        | -               |
| 3.7662   | 81900      | 0.0135        | -               |
| 3.7708   | 82000      | 0.0144        | -               |
| 3.7754   | 82100      | 0.0131        | -               |
| 3.7800   | 82200      | 0.0117        | -               |
| 3.7846   | 82300      | 0.0132        | -               |
| 3.7892   | 82400      | 0.0143        | -               |
| 3.7938   | 82500      | 0.0135        | -               |
| 3.7984   | 82600      | 0.0134        | -               |
| 3.8030   | 82700      | 0.0156        | -               |
| 3.8076   | 82800      | 0.011         | -               |
| 3.8122   | 82900      | 0.013         | -               |
| 3.8168   | 83000      | 0.013         | -               |
| 3.8214   | 83100      | 0.0126        | -               |
| 3.8260   | 83200      | 0.0119        | -               |
| 3.8306   | 83300      | 0.0109        | -               |
| 3.8352   | 83400      | 0.0133        | -               |
| 3.8398   | 83500      | 0.0122        | -               |
| 3.8444   | 83600      | 0.013         | -               |
| 3.8490   | 83700      | 0.0132        | -               |
| 3.8536   | 83800      | 0.0136        | -               |
| 3.8582   | 83900      | 0.0124        | -               |
| 3.8628   | 84000      | 0.014         | -               |
| 3.8674   | 84100      | 0.0119        | -               |
| 3.8720   | 84200      | 0.0122        | -               |
| 3.8766   | 84300      | 0.0121        | -               |
| 3.8812   | 84400      | 0.0115        | -               |
| 3.8858   | 84500      | 0.0122        | -               |
| 3.8904   | 84600      | 0.0132        | -               |
| 3.8950   | 84700      | 0.0143        | -               |
| 3.8996   | 84800      | 0.0123        | -               |
| 3.9042   | 84900      | 0.0101        | -               |
| 3.9088   | 85000      | 0.0113        | -               |
| 3.9134   | 85100      | 0.0123        | -               |
| 3.9180   | 85200      | 0.0115        | -               |
| 3.9226   | 85300      | 0.0126        | -               |
| 3.9272   | 85400      | 0.0114        | -               |
| 3.9318   | 85500      | 0.0116        | -               |
| 3.9364   | 85600      | 0.0107        | -               |
| 3.9410   | 85700      | 0.0116        | -               |
| 3.9456   | 85800      | 0.0113        | -               |
| 3.9502   | 85900      | 0.0115        | -               |
| 3.9548   | 86000      | 0.0103        | -               |
| 3.9593   | 86100      | 0.0128        | -               |
| 3.9639   | 86200      | 0.0141        | -               |
| 3.9685   | 86300      | 0.0125        | -               |
| 3.9731   | 86400      | 0.0125        | -               |
| 3.9777   | 86500      | 0.0131        | -               |
| 3.9823   | 86600      | 0.0121        | -               |
| 3.9869   | 86700      | 0.0128        | -               |
| 3.9915   | 86800      | 0.0133        | -               |
| 3.9961   | 86900      | 0.013         | -               |
| 4.0      | 86984      | -             | 0.0608          |
| 4.0007   | 87000      | 0.0099        | -               |
| 4.0053   | 87100      | 0.0095        | -               |
| 4.0099   | 87200      | 0.01          | -               |
| 4.0145   | 87300      | 0.0101        | -               |
| 4.0191   | 87400      | 0.0091        | -               |
| 4.0237   | 87500      | 0.0086        | -               |
| 4.0283   | 87600      | 0.0094        | -               |
| 4.0329   | 87700      | 0.0094        | -               |
| 4.0375   | 87800      | 0.0102        | -               |
| 4.0421   | 87900      | 0.0099        | -               |
| 4.0467   | 88000      | 0.0089        | -               |
| 4.0513   | 88100      | 0.0094        | -               |
| 4.0559   | 88200      | 0.0106        | -               |
| 4.0605   | 88300      | 0.0095        | -               |
| 4.0651   | 88400      | 0.011         | -               |
| 4.0697   | 88500      | 0.0104        | -               |
| 4.0743   | 88600      | 0.0129        | -               |
| 4.0789   | 88700      | 0.0098        | -               |
| 4.0835   | 88800      | 0.0082        | -               |
| 4.0881   | 88900      | 0.0107        | -               |
| 4.0927   | 89000      | 0.0091        | -               |
| 4.0973   | 89100      | 0.0089        | -               |
| 4.1019   | 89200      | 0.0119        | -               |
| 4.1065   | 89300      | 0.0103        | -               |
| 4.1111   | 89400      | 0.0092        | -               |
| 4.1157   | 89500      | 0.0087        | -               |
| 4.1203   | 89600      | 0.0101        | -               |
| 4.1249   | 89700      | 0.0116        | -               |
| 4.1295   | 89800      | 0.0102        | -               |
| 4.1341   | 89900      | 0.01          | -               |
| 4.1387   | 90000      | 0.0097        | -               |
| 4.1433   | 90100      | 0.0109        | -               |
| 4.1479   | 90200      | 0.0094        | -               |
| 4.1525   | 90300      | 0.0097        | -               |
| 4.1571   | 90400      | 0.0089        | -               |
| 4.1617   | 90500      | 0.0093        | -               |
| 4.1663   | 90600      | 0.0106        | -               |
| 4.1709   | 90700      | 0.0096        | -               |
| 4.1755   | 90800      | 0.0096        | -               |
| 4.1801   | 90900      | 0.0093        | -               |
| 4.1847   | 91000      | 0.0082        | -               |
| 4.1893   | 91100      | 0.0112        | -               |
| 4.1939   | 91200      | 0.0093        | -               |
| 4.1985   | 91300      | 0.0089        | -               |
| 4.2031   | 91400      | 0.0097        | -               |
| 4.2077   | 91500      | 0.011         | -               |
| 4.2123   | 91600      | 0.0113        | -               |
| 4.2169   | 91700      | 0.0095        | -               |
| 4.2215   | 91800      | 0.0086        | -               |
| 4.2261   | 91900      | 0.0098        | -               |
| 4.2307   | 92000      | 0.0098        | -               |
| 4.2353   | 92100      | 0.0103        | -               |
| 4.2399   | 92200      | 0.0086        | -               |
| 4.2445   | 92300      | 0.0098        | -               |
| 4.2491   | 92400      | 0.0106        | -               |
| 4.2537   | 92500      | 0.0097        | -               |
| 4.2583   | 92600      | 0.0107        | -               |
| 4.2629   | 92700      | 0.0119        | -               |
| 4.2675   | 92800      | 0.0093        | -               |
| 4.2721   | 92900      | 0.0108        | -               |
| 4.2766   | 93000      | 0.0099        | -               |
| 4.2812   | 93100      | 0.0111        | -               |
| 4.2858   | 93200      | 0.0108        | -               |
| 4.2904   | 93300      | 0.0095        | -               |
| 4.2950   | 93400      | 0.0103        | -               |
| 4.2996   | 93500      | 0.0104        | -               |
| 4.3042   | 93600      | 0.0088        | -               |
| 4.3088   | 93700      | 0.0096        | -               |
| 4.3134   | 93800      | 0.009         | -               |
| 4.3180   | 93900      | 0.0098        | -               |
| 4.3226   | 94000      | 0.0098        | -               |
| 4.3272   | 94100      | 0.0098        | -               |
| 4.3318   | 94200      | 0.011         | -               |
| 4.3364   | 94300      | 0.0093        | -               |
| 4.3410   | 94400      | 0.0101        | -               |
| 4.3456   | 94500      | 0.0095        | -               |
| 4.3502   | 94600      | 0.0088        | -               |
| 4.3548   | 94700      | 0.0114        | -               |
| 4.3594   | 94800      | 0.0094        | -               |
| 4.3640   | 94900      | 0.011         | -               |
| 4.3686   | 95000      | 0.0106        | -               |
| 4.3732   | 95100      | 0.0099        | -               |
| 4.3778   | 95200      | 0.0109        | -               |
| 4.3824   | 95300      | 0.0085        | -               |
| 4.3870   | 95400      | 0.0101        | -               |
| 4.3916   | 95500      | 0.0098        | -               |
| 4.3962   | 95600      | 0.0089        | -               |
| 4.4008   | 95700      | 0.0086        | -               |
| 4.4054   | 95800      | 0.0102        | -               |
| 4.4100   | 95900      | 0.0119        | -               |
| 4.4146   | 96000      | 0.0093        | -               |
| 4.4192   | 96100      | 0.0086        | -               |
| 4.4238   | 96200      | 0.011         | -               |
| 4.4284   | 96300      | 0.0102        | -               |
| 4.4330   | 96400      | 0.0084        | -               |
| 4.4376   | 96500      | 0.0085        | -               |
| 4.4422   | 96600      | 0.009         | -               |
| 4.4468   | 96700      | 0.0086        | -               |
| 4.4514   | 96800      | 0.0101        | -               |
| 4.4560   | 96900      | 0.0073        | -               |
| 4.4606   | 97000      | 0.0096        | -               |
| 4.4652   | 97100      | 0.0105        | -               |
| 4.4698   | 97200      | 0.0102        | -               |
| 4.4744   | 97300      | 0.0094        | -               |
| 4.4790   | 97400      | 0.01          | -               |
| 4.4836   | 97500      | 0.0104        | -               |
| 4.4882   | 97600      | 0.0091        | -               |
| 4.4928   | 97700      | 0.0097        | -               |
| 4.4974   | 97800      | 0.0113        | -               |
| 4.5020   | 97900      | 0.01          | -               |
| 4.5066   | 98000      | 0.0099        | -               |
| 4.5112   | 98100      | 0.0096        | -               |
| 4.5158   | 98200      | 0.0096        | -               |
| 4.5204   | 98300      | 0.0117        | -               |
| 4.5250   | 98400      | 0.0092        | -               |
| 4.5296   | 98500      | 0.0087        | -               |
| 4.5342   | 98600      | 0.0089        | -               |
| 4.5388   | 98700      | 0.0105        | -               |
| 4.5434   | 98800      | 0.0084        | -               |
| 4.5480   | 98900      | 0.0094        | -               |
| 4.5526   | 99000      | 0.0097        | -               |
| 4.5572   | 99100      | 0.0088        | -               |
| 4.5618   | 99200      | 0.0087        | -               |
| 4.5664   | 99300      | 0.0111        | -               |
| 4.5710   | 99400      | 0.009         | -               |
| 4.5756   | 99500      | 0.0088        | -               |
| 4.5802   | 99600      | 0.0099        | -               |
| 4.5848   | 99700      | 0.0101        | -               |
| 4.5893   | 99800      | 0.0093        | -               |
| 4.5939   | 99900      | 0.0096        | -               |
| 4.5985   | 100000     | 0.0093        | -               |
| 4.6031   | 100100     | 0.0083        | -               |
| 4.6077   | 100200     | 0.0103        | -               |
| 4.6123   | 100300     | 0.0091        | -               |
| 4.6169   | 100400     | 0.009         | -               |
| 4.6215   | 100500     | 0.0081        | -               |
| 4.6261   | 100600     | 0.0107        | -               |
| 4.6307   | 100700     | 0.0091        | -               |
| 4.6353   | 100800     | 0.0088        | -               |
| 4.6399   | 100900     | 0.0083        | -               |
| 4.6445   | 101000     | 0.0095        | -               |
| 4.6491   | 101100     | 0.0129        | -               |
| 4.6537   | 101200     | 0.0093        | -               |
| 4.6583   | 101300     | 0.0084        | -               |
| 4.6629   | 101400     | 0.0097        | -               |
| 4.6675   | 101500     | 0.0098        | -               |
| 4.6721   | 101600     | 0.01          | -               |
| 4.6767   | 101700     | 0.0096        | -               |
| 4.6813   | 101800     | 0.0088        | -               |
| 4.6859   | 101900     | 0.0106        | -               |
| 4.6905   | 102000     | 0.0088        | -               |
| 4.6951   | 102100     | 0.0111        | -               |
| 4.6997   | 102200     | 0.0091        | -               |
| 4.7043   | 102300     | 0.0103        | -               |
| 4.7089   | 102400     | 0.0098        | -               |
| 4.7135   | 102500     | 0.0084        | -               |
| 4.7181   | 102600     | 0.0083        | -               |
| 4.7227   | 102700     | 0.0099        | -               |
| 4.7273   | 102800     | 0.0093        | -               |
| 4.7319   | 102900     | 0.0086        | -               |
| 4.7365   | 103000     | 0.0099        | -               |
| 4.7411   | 103100     | 0.0074        | -               |
| 4.7457   | 103200     | 0.0095        | -               |
| 4.7503   | 103300     | 0.0098        | -               |
| 4.7549   | 103400     | 0.0097        | -               |
| 4.7595   | 103500     | 0.009         | -               |
| 4.7641   | 103600     | 0.0106        | -               |
| 4.7687   | 103700     | 0.0092        | -               |
| 4.7733   | 103800     | 0.0083        | -               |
| 4.7779   | 103900     | 0.0093        | -               |
| 4.7825   | 104000     | 0.0088        | -               |
| 4.7871   | 104100     | 0.0102        | -               |
| 4.7917   | 104200     | 0.0081        | -               |
| 4.7963   | 104300     | 0.008         | -               |
| 4.8009   | 104400     | 0.0083        | -               |
| 4.8055   | 104500     | 0.0091        | -               |
| 4.8101   | 104600     | 0.009         | -               |
| 4.8147   | 104700     | 0.0094        | -               |
| 4.8193   | 104800     | 0.0093        | -               |
| 4.8239   | 104900     | 0.0091        | -               |
| 4.8285   | 105000     | 0.0089        | -               |
| 4.8331   | 105100     | 0.0114        | -               |
| 4.8377   | 105200     | 0.0091        | -               |
| 4.8423   | 105300     | 0.008         | -               |
| 4.8469   | 105400     | 0.0095        | -               |
| 4.8515   | 105500     | 0.008         | -               |
| 4.8561   | 105600     | 0.0094        | -               |
| 4.8607   | 105700     | 0.0092        | -               |
| 4.8653   | 105800     | 0.0082        | -               |
| 4.8699   | 105900     | 0.0089        | -               |
| 4.8745   | 106000     | 0.0115        | -               |
| 4.8791   | 106100     | 0.0103        | -               |
| 4.8837   | 106200     | 0.0098        | -               |
| 4.8883   | 106300     | 0.0101        | -               |
| 4.8929   | 106400     | 0.0091        | -               |
| 4.8975   | 106500     | 0.0088        | -               |
| 4.9021   | 106600     | 0.01          | -               |
| 4.9066   | 106700     | 0.0114        | -               |
| 4.9112   | 106800     | 0.01          | -               |
| 4.9158   | 106900     | 0.0101        | -               |
| 4.9204   | 107000     | 0.0099        | -               |
| 4.9250   | 107100     | 0.0087        | -               |
| 4.9296   | 107200     | 0.0093        | -               |
| 4.9342   | 107300     | 0.0092        | -               |
| 4.9388   | 107400     | 0.0094        | -               |
| 4.9434   | 107500     | 0.0094        | -               |
| 4.9480   | 107600     | 0.0092        | -               |
| 4.9526   | 107700     | 0.0079        | -               |
| 4.9572   | 107800     | 0.0087        | -               |
| 4.9618   | 107900     | 0.011         | -               |
| 4.9664   | 108000     | 0.0084        | -               |
| 4.9710   | 108100     | 0.0107        | -               |
| 4.9756   | 108200     | 0.0095        | -               |
| 4.9802   | 108300     | 0.0101        | -               |
| 4.9848   | 108400     | 0.0097        | -               |
| 4.9894   | 108500     | 0.0087        | -               |
| 4.9940   | 108600     | 0.0104        | -               |
| 4.9986   | 108700     | 0.0089        | -               |
| 5.0      | 108730     | -             | 0.0515          |
| 5.0032   | 108800     | 0.01          | -               |
| 5.0078   | 108900     | 0.0069        | -               |
| 5.0124   | 109000     | 0.0073        | -               |
| 5.0170   | 109100     | 0.0084        | -               |
| 5.0216   | 109200     | 0.0076        | -               |
| 5.0262   | 109300     | 0.0077        | -               |
| 5.0308   | 109400     | 0.0077        | -               |
| 5.0354   | 109500     | 0.0079        | -               |
| 5.0400   | 109600     | 0.0075        | -               |
| 5.0446   | 109700     | 0.007         | -               |
| 5.0492   | 109800     | 0.0069        | -               |
| 5.0538   | 109900     | 0.0085        | -               |
| 5.0584   | 110000     | 0.0068        | -               |
| 5.0630   | 110100     | 0.0081        | -               |
| 5.0676   | 110200     | 0.0073        | -               |
| 5.0722   | 110300     | 0.008         | -               |
| 5.0768   | 110400     | 0.0079        | -               |
| 5.0814   | 110500     | 0.0077        | -               |
| 5.0860   | 110600     | 0.0084        | -               |
| 5.0906   | 110700     | 0.0081        | -               |
| 5.0952   | 110800     | 0.0085        | -               |
| 5.0998   | 110900     | 0.0067        | -               |
| 5.1044   | 111000     | 0.0085        | -               |
| 5.1090   | 111100     | 0.0084        | -               |
| 5.1136   | 111200     | 0.0086        | -               |
| 5.1182   | 111300     | 0.0075        | -               |
| 5.1228   | 111400     | 0.0073        | -               |
| 5.1274   | 111500     | 0.0086        | -               |
| 5.1320   | 111600     | 0.0071        | -               |
| 5.1366   | 111700     | 0.0087        | -               |
| 5.1412   | 111800     | 0.0075        | -               |
| 5.1458   | 111900     | 0.0072        | -               |
| 5.1504   | 112000     | 0.0081        | -               |
| 5.1550   | 112100     | 0.0077        | -               |
| 5.1596   | 112200     | 0.0072        | -               |
| 5.1642   | 112300     | 0.0068        | -               |
| 5.1688   | 112400     | 0.0073        | -               |
| 5.1734   | 112500     | 0.009         | -               |
| 5.1780   | 112600     | 0.0068        | -               |
| 5.1826   | 112700     | 0.0084        | -               |
| 5.1872   | 112800     | 0.0077        | -               |
| 5.1918   | 112900     | 0.0076        | -               |
| 5.1964   | 113000     | 0.007         | -               |
| 5.2010   | 113100     | 0.0071        | -               |
| 5.2056   | 113200     | 0.0075        | -               |
| 5.2102   | 113300     | 0.009         | -               |
| 5.2148   | 113400     | 0.0057        | -               |
| 5.2194   | 113500     | 0.0066        | -               |
| 5.2239   | 113600     | 0.0073        | -               |
| 5.2285   | 113700     | 0.0078        | -               |
| 5.2331   | 113800     | 0.0071        | -               |
| 5.2377   | 113900     | 0.0068        | -               |
| 5.2423   | 114000     | 0.0075        | -               |
| 5.2469   | 114100     | 0.008         | -               |
| 5.2515   | 114200     | 0.0058        | -               |
| 5.2561   | 114300     | 0.0069        | -               |
| 5.2607   | 114400     | 0.007         | -               |
| 5.2653   | 114500     | 0.0078        | -               |
| 5.2699   | 114600     | 0.0075        | -               |
| 5.2745   | 114700     | 0.0078        | -               |
| 5.2791   | 114800     | 0.0063        | -               |
| 5.2837   | 114900     | 0.0077        | -               |
| 5.2883   | 115000     | 0.0084        | -               |
| 5.2929   | 115100     | 0.0085        | -               |
| 5.2975   | 115200     | 0.0075        | -               |
| 5.3021   | 115300     | 0.0074        | -               |
| 5.3067   | 115400     | 0.0081        | -               |
| 5.3113   | 115500     | 0.0079        | -               |
| 5.3159   | 115600     | 0.0078        | -               |
| 5.3205   | 115700     | 0.008         | -               |
| 5.3251   | 115800     | 0.0073        | -               |
| 5.3297   | 115900     | 0.0081        | -               |
| 5.3343   | 116000     | 0.0079        | -               |
| 5.3389   | 116100     | 0.0077        | -               |
| 5.3435   | 116200     | 0.0072        | -               |
| 5.3481   | 116300     | 0.0082        | -               |
| 5.3527   | 116400     | 0.0069        | -               |
| 5.3573   | 116500     | 0.0087        | -               |
| 5.3619   | 116600     | 0.0078        | -               |
| 5.3665   | 116700     | 0.0073        | -               |
| 5.3711   | 116800     | 0.0073        | -               |
| 5.3757   | 116900     | 0.0072        | -               |
| 5.3803   | 117000     | 0.0091        | -               |
| 5.3849   | 117100     | 0.0063        | -               |
| 5.3895   | 117200     | 0.0069        | -               |
| 5.3941   | 117300     | 0.0067        | -               |
| 5.3987   | 117400     | 0.0073        | -               |
| 5.4033   | 117500     | 0.0083        | -               |
| 5.4079   | 117600     | 0.0074        | -               |
| 5.4125   | 117700     | 0.0075        | -               |
| 5.4171   | 117800     | 0.0073        | -               |
| 5.4217   | 117900     | 0.0065        | -               |
| 5.4263   | 118000     | 0.0069        | -               |
| 5.4309   | 118100     | 0.0067        | -               |
| 5.4355   | 118200     | 0.0072        | -               |
| 5.4401   | 118300     | 0.0074        | -               |
| 5.4447   | 118400     | 0.0076        | -               |
| 5.4493   | 118500     | 0.0066        | -               |
| 5.4539   | 118600     | 0.0074        | -               |
| 5.4585   | 118700     | 0.0076        | -               |
| 5.4631   | 118800     | 0.0085        | -               |
| 5.4677   | 118900     | 0.0069        | -               |
| 5.4723   | 119000     | 0.0089        | -               |
| 5.4769   | 119100     | 0.0062        | -               |
| 5.4815   | 119200     | 0.0074        | -               |
| 5.4861   | 119300     | 0.0078        | -               |
| 5.4907   | 119400     | 0.0093        | -               |
| 5.4953   | 119500     | 0.008         | -               |
| 5.4999   | 119600     | 0.0094        | -               |
| 5.5045   | 119700     | 0.0069        | -               |
| 5.5091   | 119800     | 0.0074        | -               |
| 5.5137   | 119900     | 0.0071        | -               |
| 5.5183   | 120000     | 0.0074        | -               |
| 5.5229   | 120100     | 0.0074        | -               |
| 5.5275   | 120200     | 0.0066        | -               |
| 5.5321   | 120300     | 0.007         | -               |
| 5.5367   | 120400     | 0.0077        | -               |
| 5.5412   | 120500     | 0.0078        | -               |
| 5.5458   | 120600     | 0.0095        | -               |
| 5.5504   | 120700     | 0.0087        | -               |
| 5.5550   | 120800     | 0.0081        | -               |
| 5.5596   | 120900     | 0.0075        | -               |
| 5.5642   | 121000     | 0.0072        | -               |
| 5.5688   | 121100     | 0.0058        | -               |
| 5.5734   | 121200     | 0.0076        | -               |
| 5.5780   | 121300     | 0.0071        | -               |
| 5.5826   | 121400     | 0.0072        | -               |
| 5.5872   | 121500     | 0.0073        | -               |
| 5.5918   | 121600     | 0.0083        | -               |
| 5.5964   | 121700     | 0.0074        | -               |
| 5.6010   | 121800     | 0.0072        | -               |
| 5.6056   | 121900     | 0.0066        | -               |
| 5.6102   | 122000     | 0.0059        | -               |
| 5.6148   | 122100     | 0.0087        | -               |
| 5.6194   | 122200     | 0.0077        | -               |
| 5.6240   | 122300     | 0.0075        | -               |
| 5.6286   | 122400     | 0.0083        | -               |
| 5.6332   | 122500     | 0.0079        | -               |
| 5.6378   | 122600     | 0.0074        | -               |
| 5.6424   | 122700     | 0.0093        | -               |
| 5.6470   | 122800     | 0.0092        | -               |
| 5.6516   | 122900     | 0.0072        | -               |
| 5.6562   | 123000     | 0.0083        | -               |
| 5.6608   | 123100     | 0.0085        | -               |
| 5.6654   | 123200     | 0.008         | -               |
| 5.6700   | 123300     | 0.0074        | -               |
| 5.6746   | 123400     | 0.008         | -               |
| 5.6792   | 123500     | 0.0079        | -               |
| 5.6838   | 123600     | 0.0063        | -               |
| 5.6884   | 123700     | 0.0079        | -               |
| 5.6930   | 123800     | 0.0084        | -               |
| 5.6976   | 123900     | 0.0076        | -               |
| 5.7022   | 124000     | 0.0087        | -               |
| 5.7068   | 124100     | 0.0063        | -               |
| 5.7114   | 124200     | 0.0076        | -               |
| 5.7160   | 124300     | 0.006         | -               |
| 5.7206   | 124400     | 0.0084        | -               |
| 5.7252   | 124500     | 0.0075        | -               |
| 5.7298   | 124600     | 0.0074        | -               |
| 5.7344   | 124700     | 0.008         | -               |
| 5.7390   | 124800     | 0.0093        | -               |
| 5.7436   | 124900     | 0.0072        | -               |
| 5.7482   | 125000     | 0.0074        | -               |
| 5.7528   | 125100     | 0.0061        | -               |
| 5.7574   | 125200     | 0.0065        | -               |
| 5.7620   | 125300     | 0.0074        | -               |
| 5.7666   | 125400     | 0.0069        | -               |
| 5.7712   | 125500     | 0.0059        | -               |
| 5.7758   | 125600     | 0.008         | -               |
| 5.7804   | 125700     | 0.0081        | -               |
| 5.7850   | 125800     | 0.0085        | -               |
| 5.7896   | 125900     | 0.0071        | -               |
| 5.7942   | 126000     | 0.0072        | -               |
| 5.7988   | 126100     | 0.0078        | -               |
| 5.8034   | 126200     | 0.0094        | -               |
| 5.8080   | 126300     | 0.0075        | -               |
| 5.8126   | 126400     | 0.0078        | -               |
| 5.8172   | 126500     | 0.0065        | -               |
| 5.8218   | 126600     | 0.0063        | -               |
| 5.8264   | 126700     | 0.0068        | -               |
| 5.8310   | 126800     | 0.0064        | -               |
| 5.8356   | 126900     | 0.0078        | -               |
| 5.8402   | 127000     | 0.0085        | -               |
| 5.8448   | 127100     | 0.007         | -               |
| 5.8494   | 127200     | 0.0071        | -               |
| 5.8540   | 127300     | 0.0069        | -               |
| 5.8585   | 127400     | 0.007         | -               |
| 5.8631   | 127500     | 0.0083        | -               |
| 5.8677   | 127600     | 0.0069        | -               |
| 5.8723   | 127700     | 0.0078        | -               |
| 5.8769   | 127800     | 0.0081        | -               |
| 5.8815   | 127900     | 0.0071        | -               |
| 5.8861   | 128000     | 0.0057        | -               |
| 5.8907   | 128100     | 0.009         | -               |
| 5.8953   | 128200     | 0.0066        | -               |
| 5.8999   | 128300     | 0.0077        | -               |
| 5.9045   | 128400     | 0.0085        | -               |
| 5.9091   | 128500     | 0.0072        | -               |
| 5.9137   | 128600     | 0.007         | -               |
| 5.9183   | 128700     | 0.0076        | -               |
| 5.9229   | 128800     | 0.0071        | -               |
| 5.9275   | 128900     | 0.0079        | -               |
| 5.9321   | 129000     | 0.007         | -               |
| 5.9367   | 129100     | 0.0103        | -               |
| 5.9413   | 129200     | 0.0062        | -               |
| 5.9459   | 129300     | 0.007         | -               |
| 5.9505   | 129400     | 0.008         | -               |
| 5.9551   | 129500     | 0.0099        | -               |
| 5.9597   | 129600     | 0.0077        | -               |
| 5.9643   | 129700     | 0.0069        | -               |
| 5.9689   | 129800     | 0.0071        | -               |
| 5.9735   | 129900     | 0.0069        | -               |
| 5.9781   | 130000     | 0.0068        | -               |
| 5.9827   | 130100     | 0.0065        | -               |
| 5.9873   | 130200     | 0.0063        | -               |
| 5.9919   | 130300     | 0.0083        | -               |
| 5.9965   | 130400     | 0.0093        | -               |
| 6.0      | 130476     | -             | 0.0451          |
| 6.0011   | 130500     | 0.0068        | -               |
| 6.0057   | 130600     | 0.0057        | -               |
| 6.0103   | 130700     | 0.0059        | -               |
| 6.0149   | 130800     | 0.0049        | -               |
| 6.0195   | 130900     | 0.0062        | -               |
| 6.0241   | 131000     | 0.0061        | -               |
| 6.0287   | 131100     | 0.0054        | -               |
| 6.0333   | 131200     | 0.008         | -               |
| 6.0379   | 131300     | 0.0047        | -               |
| 6.0425   | 131400     | 0.0056        | -               |
| 6.0471   | 131500     | 0.005         | -               |
| 6.0517   | 131600     | 0.0059        | -               |
| 6.0563   | 131700     | 0.0062        | -               |
| 6.0609   | 131800     | 0.0059        | -               |
| 6.0655   | 131900     | 0.0056        | -               |
| 6.0701   | 132000     | 0.0051        | -               |
| 6.0747   | 132100     | 0.0053        | -               |
| 6.0793   | 132200     | 0.006         | -               |
| 6.0839   | 132300     | 0.0057        | -               |
| 6.0885   | 132400     | 0.0057        | -               |
| 6.0931   | 132500     | 0.0057        | -               |
| 6.0977   | 132600     | 0.0057        | -               |
| 6.1023   | 132700     | 0.005         | -               |
| 6.1069   | 132800     | 0.0067        | -               |
| 6.1115   | 132900     | 0.0068        | -               |
| 6.1161   | 133000     | 0.0044        | -               |
| 6.1207   | 133100     | 0.0055        | -               |
| 6.1253   | 133200     | 0.0068        | -               |
| 6.1299   | 133300     | 0.006         | -               |
| 6.1345   | 133400     | 0.0067        | -               |
| 6.1391   | 133500     | 0.0058        | -               |
| 6.1437   | 133600     | 0.0058        | -               |
| 6.1483   | 133700     | 0.0065        | -               |
| 6.1529   | 133800     | 0.0062        | -               |
| 6.1575   | 133900     | 0.0055        | -               |
| 6.1621   | 134000     | 0.007         | -               |
| 6.1667   | 134100     | 0.0054        | -               |
| 6.1712   | 134200     | 0.0066        | -               |
| 6.1758   | 134300     | 0.0057        | -               |
| 6.1804   | 134400     | 0.0062        | -               |
| 6.1850   | 134500     | 0.0055        | -               |
| 6.1896   | 134600     | 0.0059        | -               |
| 6.1942   | 134700     | 0.0061        | -               |
| 6.1988   | 134800     | 0.0059        | -               |
| 6.2034   | 134900     | 0.0057        | -               |
| 6.2080   | 135000     | 0.0059        | -               |
| 6.2126   | 135100     | 0.0062        | -               |
| 6.2172   | 135200     | 0.0072        | -               |
| 6.2218   | 135300     | 0.0068        | -               |
| 6.2264   | 135400     | 0.0052        | -               |
| 6.2310   | 135500     | 0.0065        | -               |
| 6.2356   | 135600     | 0.0061        | -               |
| 6.2402   | 135700     | 0.0053        | -               |
| 6.2448   | 135800     | 0.0057        | -               |
| 6.2494   | 135900     | 0.0054        | -               |
| 6.2540   | 136000     | 0.0057        | -               |
| 6.2586   | 136100     | 0.0062        | -               |
| 6.2632   | 136200     | 0.006         | -               |
| 6.2678   | 136300     | 0.0063        | -               |
| 6.2724   | 136400     | 0.0069        | -               |
| 6.2770   | 136500     | 0.0064        | -               |
| 6.2816   | 136600     | 0.0065        | -               |
| 6.2862   | 136700     | 0.0055        | -               |
| 6.2908   | 136800     | 0.0071        | -               |
| 6.2954   | 136900     | 0.0071        | -               |
| 6.3000   | 137000     | 0.0056        | -               |
| 6.3046   | 137100     | 0.0058        | -               |
| 6.3092   | 137200     | 0.0058        | -               |
| 6.3138   | 137300     | 0.0048        | -               |
| 6.3184   | 137400     | 0.0065        | -               |
| 6.3230   | 137500     | 0.0057        | -               |
| 6.3276   | 137600     | 0.0054        | -               |
| 6.3322   | 137700     | 0.0065        | -               |
| 6.3368   | 137800     | 0.0055        | -               |
| 6.3414   | 137900     | 0.0061        | -               |
| 6.3460   | 138000     | 0.0064        | -               |
| 6.3506   | 138100     | 0.0054        | -               |
| 6.3552   | 138200     | 0.0049        | -               |
| 6.3598   | 138300     | 0.005         | -               |
| 6.3644   | 138400     | 0.0063        | -               |
| 6.3690   | 138500     | 0.0062        | -               |
| 6.3736   | 138600     | 0.0062        | -               |
| 6.3782   | 138700     | 0.0069        | -               |
| 6.3828   | 138800     | 0.0051        | -               |
| 6.3874   | 138900     | 0.007         | -               |
| 6.3920   | 139000     | 0.0053        | -               |
| 6.3966   | 139100     | 0.0062        | -               |
| 6.4012   | 139200     | 0.0071        | -               |
| 6.4058   | 139300     | 0.0066        | -               |
| 6.4104   | 139400     | 0.0059        | -               |
| 6.4150   | 139500     | 0.0053        | -               |
| 6.4196   | 139600     | 0.0069        | -               |
| 6.4242   | 139700     | 0.0067        | -               |
| 6.4288   | 139800     | 0.0053        | -               |
| 6.4334   | 139900     | 0.0068        | -               |
| 6.4380   | 140000     | 0.006         | -               |
| 6.4426   | 140100     | 0.007         | -               |
| 6.4472   | 140200     | 0.0053        | -               |
| 6.4518   | 140300     | 0.0062        | -               |
| 6.4564   | 140400     | 0.0066        | -               |
| 6.4610   | 140500     | 0.0046        | -               |
| 6.4656   | 140600     | 0.0051        | -               |
| 6.4702   | 140700     | 0.0061        | -               |
| 6.4748   | 140800     | 0.0063        | -               |
| 6.4794   | 140900     | 0.0057        | -               |
| 6.4840   | 141000     | 0.006         | -               |
| 6.4885   | 141100     | 0.0049        | -               |
| 6.4931   | 141200     | 0.0062        | -               |
| 6.4977   | 141300     | 0.007         | -               |
| 6.5023   | 141400     | 0.0062        | -               |
| 6.5069   | 141500     | 0.0046        | -               |
| 6.5115   | 141600     | 0.0059        | -               |
| 6.5161   | 141700     | 0.0058        | -               |
| 6.5207   | 141800     | 0.0061        | -               |
| 6.5253   | 141900     | 0.0057        | -               |
| 6.5299   | 142000     | 0.0059        | -               |
| 6.5345   | 142100     | 0.0054        | -               |
| 6.5391   | 142200     | 0.0049        | -               |
| 6.5437   | 142300     | 0.0053        | -               |
| 6.5483   | 142400     | 0.0055        | -               |
| 6.5529   | 142500     | 0.0051        | -               |
| 6.5575   | 142600     | 0.0057        | -               |
| 6.5621   | 142700     | 0.0064        | -               |
| 6.5667   | 142800     | 0.005         | -               |
| 6.5713   | 142900     | 0.0073        | -               |
| 6.5759   | 143000     | 0.0065        | -               |
| 6.5805   | 143100     | 0.0063        | -               |
| 6.5851   | 143200     | 0.0066        | -               |
| 6.5897   | 143300     | 0.0061        | -               |
| 6.5943   | 143400     | 0.0064        | -               |
| 6.5989   | 143500     | 0.0048        | -               |
| 6.6035   | 143600     | 0.0059        | -               |
| 6.6081   | 143700     | 0.006         | -               |
| 6.6127   | 143800     | 0.006         | -               |
| 6.6173   | 143900     | 0.005         | -               |
| 6.6219   | 144000     | 0.0061        | -               |
| 6.6265   | 144100     | 0.0061        | -               |
| 6.6311   | 144200     | 0.0052        | -               |
| 6.6357   | 144300     | 0.0055        | -               |
| 6.6403   | 144400     | 0.0056        | -               |
| 6.6449   | 144500     | 0.0064        | -               |
| 6.6495   | 144600     | 0.0067        | -               |
| 6.6541   | 144700     | 0.0059        | -               |
| 6.6587   | 144800     | 0.0047        | -               |
| 6.6633   | 144900     | 0.0056        | -               |
| 6.6679   | 145000     | 0.006         | -               |
| 6.6725   | 145100     | 0.0052        | -               |
| 6.6771   | 145200     | 0.0069        | -               |
| 6.6817   | 145300     | 0.0056        | -               |
| 6.6863   | 145400     | 0.0067        | -               |
| 6.6909   | 145500     | 0.0058        | -               |
| 6.6955   | 145600     | 0.0068        | -               |
| 6.7001   | 145700     | 0.0051        | -               |
| 6.7047   | 145800     | 0.0067        | -               |
| 6.7093   | 145900     | 0.0069        | -               |
| 6.7139   | 146000     | 0.0051        | -               |
| 6.7185   | 146100     | 0.0047        | -               |
| 6.7231   | 146200     | 0.005         | -               |
| 6.7277   | 146300     | 0.0062        | -               |
| 6.7323   | 146400     | 0.0062        | -               |
| 6.7369   | 146500     | 0.0063        | -               |
| 6.7415   | 146600     | 0.0057        | -               |
| 6.7461   | 146700     | 0.006         | -               |
| 6.7507   | 146800     | 0.0053        | -               |
| 6.7553   | 146900     | 0.0063        | -               |
| 6.7599   | 147000     | 0.0057        | -               |
| 6.7645   | 147100     | 0.0055        | -               |
| 6.7691   | 147200     | 0.0064        | -               |
| 6.7737   | 147300     | 0.0051        | -               |
| 6.7783   | 147400     | 0.0058        | -               |
| 6.7829   | 147500     | 0.0061        | -               |
| 6.7875   | 147600     | 0.0057        | -               |
| 6.7921   | 147700     | 0.0064        | -               |
| 6.7967   | 147800     | 0.0052        | -               |
| 6.8013   | 147900     | 0.0058        | -               |
| 6.8058   | 148000     | 0.0071        | -               |
| 6.8104   | 148100     | 0.006         | -               |
| 6.8150   | 148200     | 0.0063        | -               |
| 6.8196   | 148300     | 0.0075        | -               |
| 6.8242   | 148400     | 0.0069        | -               |
| 6.8288   | 148500     | 0.0067        | -               |
| 6.8334   | 148600     | 0.007         | -               |
| 6.8380   | 148700     | 0.0078        | -               |
| 6.8426   | 148800     | 0.0055        | -               |
| 6.8472   | 148900     | 0.006         | -               |
| 6.8518   | 149000     | 0.0048        | -               |
| 6.8564   | 149100     | 0.0059        | -               |
| 6.8610   | 149200     | 0.0066        | -               |
| 6.8656   | 149300     | 0.005         | -               |
| 6.8702   | 149400     | 0.0056        | -               |
| 6.8748   | 149500     | 0.0065        | -               |
| 6.8794   | 149600     | 0.0073        | -               |
| 6.8840   | 149700     | 0.0052        | -               |
| 6.8886   | 149800     | 0.0047        | -               |
| 6.8932   | 149900     | 0.0051        | -               |
| 6.8978   | 150000     | 0.0069        | -               |
| 6.9024   | 150100     | 0.0058        | -               |
| 6.9070   | 150200     | 0.0058        | -               |
| 6.9116   | 150300     | 0.0065        | -               |
| 6.9162   | 150400     | 0.0052        | -               |
| 6.9208   | 150500     | 0.0054        | -               |
| 6.9254   | 150600     | 0.0066        | -               |
| 6.9300   | 150700     | 0.0065        | -               |
| 6.9346   | 150800     | 0.0059        | -               |
| 6.9392   | 150900     | 0.0047        | -               |
| 6.9438   | 151000     | 0.0068        | -               |
| 6.9484   | 151100     | 0.0052        | -               |
| 6.9530   | 151200     | 0.0061        | -               |
| 6.9576   | 151300     | 0.0062        | -               |
| 6.9622   | 151400     | 0.0052        | -               |
| 6.9668   | 151500     | 0.0059        | -               |
| 6.9714   | 151600     | 0.0057        | -               |
| 6.9760   | 151700     | 0.0049        | -               |
| 6.9806   | 151800     | 0.0067        | -               |
| 6.9852   | 151900     | 0.0061        | -               |
| 6.9898   | 152000     | 0.0045        | -               |
| 6.9944   | 152100     | 0.0051        | -               |
| 6.9990   | 152200     | 0.007         | -               |
| 7.0      | 152222     | -             | 0.0395          |
| 7.0036   | 152300     | 0.005         | -               |
| 7.0082   | 152400     | 0.0056        | -               |
| 7.0128   | 152500     | 0.0043        | -               |
| 7.0174   | 152600     | 0.0051        | -               |
| 7.0220   | 152700     | 0.005         | -               |
| 7.0266   | 152800     | 0.0051        | -               |
| 7.0312   | 152900     | 0.0047        | -               |
| 7.0358   | 153000     | 0.0045        | -               |
| 7.0404   | 153100     | 0.0049        | -               |
| 7.0450   | 153200     | 0.0056        | -               |
| 7.0496   | 153300     | 0.0049        | -               |
| 7.0542   | 153400     | 0.0047        | -               |
| 7.0588   | 153500     | 0.0052        | -               |
| 7.0634   | 153600     | 0.0043        | -               |
| 7.0680   | 153700     | 0.0044        | -               |
| 7.0726   | 153800     | 0.005         | -               |
| 7.0772   | 153900     | 0.0048        | -               |
| 7.0818   | 154000     | 0.0046        | -               |
| 7.0864   | 154100     | 0.0045        | -               |
| 7.0910   | 154200     | 0.0063        | -               |
| 7.0956   | 154300     | 0.0044        | -               |
| 7.1002   | 154400     | 0.0038        | -               |
| 7.1048   | 154500     | 0.0044        | -               |
| 7.1094   | 154600     | 0.0046        | -               |
| 7.1140   | 154700     | 0.0043        | -               |
| 7.1186   | 154800     | 0.0062        | -               |
| 7.1231   | 154900     | 0.004         | -               |
| 7.1277   | 155000     | 0.0051        | -               |
| 7.1323   | 155100     | 0.005         | -               |
| 7.1369   | 155200     | 0.0057        | -               |
| 7.1415   | 155300     | 0.0052        | -               |
| 7.1461   | 155400     | 0.0032        | -               |
| 7.1507   | 155500     | 0.0054        | -               |
| 7.1553   | 155600     | 0.0044        | -               |
| 7.1599   | 155700     | 0.0049        | -               |
| 7.1645   | 155800     | 0.0038        | -               |
| 7.1691   | 155900     | 0.0057        | -               |
| 7.1737   | 156000     | 0.0051        | -               |
| 7.1783   | 156100     | 0.0045        | -               |
| 7.1829   | 156200     | 0.0048        | -               |
| 7.1875   | 156300     | 0.007         | -               |
| 7.1921   | 156400     | 0.0059        | -               |
| 7.1967   | 156500     | 0.0049        | -               |
| 7.2013   | 156600     | 0.0048        | -               |
| 7.2059   | 156700     | 0.0043        | -               |
| 7.2105   | 156800     | 0.0047        | -               |
| 7.2151   | 156900     | 0.0047        | -               |
| 7.2197   | 157000     | 0.0047        | -               |
| 7.2243   | 157100     | 0.005         | -               |
| 7.2289   | 157200     | 0.0054        | -               |
| 7.2335   | 157300     | 0.0048        | -               |
| 7.2381   | 157400     | 0.0038        | -               |
| 7.2427   | 157500     | 0.0042        | -               |
| 7.2473   | 157600     | 0.0048        | -               |
| 7.2519   | 157700     | 0.0052        | -               |
| 7.2565   | 157800     | 0.0038        | -               |
| 7.2611   | 157900     | 0.0042        | -               |
| 7.2657   | 158000     | 0.0047        | -               |
| 7.2703   | 158100     | 0.0049        | -               |
| 7.2749   | 158200     | 0.0045        | -               |
| 7.2795   | 158300     | 0.0058        | -               |
| 7.2841   | 158400     | 0.0042        | -               |
| 7.2887   | 158500     | 0.005         | -               |
| 7.2933   | 158600     | 0.004         | -               |
| 7.2979   | 158700     | 0.0044        | -               |
| 7.3025   | 158800     | 0.0052        | -               |
| 7.3071   | 158900     | 0.0048        | -               |
| 7.3117   | 159000     | 0.0041        | -               |
| 7.3163   | 159100     | 0.0047        | -               |
| 7.3209   | 159200     | 0.005         | -               |
| 7.3255   | 159300     | 0.0041        | -               |
| 7.3301   | 159400     | 0.0056        | -               |
| 7.3347   | 159500     | 0.0046        | -               |
| 7.3393   | 159600     | 0.0055        | -               |
| 7.3439   | 159700     | 0.0059        | -               |
| 7.3485   | 159800     | 0.0037        | -               |
| 7.3531   | 159900     | 0.0053        | -               |
| 7.3577   | 160000     | 0.0038        | -               |
| 7.3623   | 160100     | 0.0046        | -               |
| 7.3669   | 160200     | 0.0055        | -               |
| 7.3715   | 160300     | 0.0048        | -               |
| 7.3761   | 160400     | 0.0061        | -               |
| 7.3807   | 160500     | 0.0043        | -               |
| 7.3853   | 160600     | 0.004         | -               |
| 7.3899   | 160700     | 0.0046        | -               |
| 7.3945   | 160800     | 0.0063        | -               |
| 7.3991   | 160900     | 0.0062        | -               |
| 7.4037   | 161000     | 0.0053        | -               |
| 7.4083   | 161100     | 0.0041        | -               |
| 7.4129   | 161200     | 0.0044        | -               |
| 7.4175   | 161300     | 0.0054        | -               |
| 7.4221   | 161400     | 0.0037        | -               |
| 7.4267   | 161500     | 0.0041        | -               |
| 7.4313   | 161600     | 0.0054        | -               |
| 7.4359   | 161700     | 0.0055        | -               |
| 7.4404   | 161800     | 0.0041        | -               |
| 7.4450   | 161900     | 0.0045        | -               |
| 7.4496   | 162000     | 0.0042        | -               |
| 7.4542   | 162100     | 0.0057        | -               |
| 7.4588   | 162200     | 0.0054        | -               |
| 7.4634   | 162300     | 0.0044        | -               |
| 7.4680   | 162400     | 0.0046        | -               |
| 7.4726   | 162500     | 0.0046        | -               |
| 7.4772   | 162600     | 0.0045        | -               |
| 7.4818   | 162700     | 0.0058        | -               |
| 7.4864   | 162800     | 0.0055        | -               |
| 7.4910   | 162900     | 0.005         | -               |
| 7.4956   | 163000     | 0.0042        | -               |
| 7.5002   | 163100     | 0.0047        | -               |
| 7.5048   | 163200     | 0.0051        | -               |
| 7.5094   | 163300     | 0.0051        | -               |
| 7.5140   | 163400     | 0.0042        | -               |
| 7.5186   | 163500     | 0.0055        | -               |
| 7.5232   | 163600     | 0.004         | -               |
| 7.5278   | 163700     | 0.0048        | -               |
| 7.5324   | 163800     | 0.0044        | -               |
| 7.5370   | 163900     | 0.0045        | -               |
| 7.5416   | 164000     | 0.0042        | -               |
| 7.5462   | 164100     | 0.005         | -               |
| 7.5508   | 164200     | 0.005         | -               |
| 7.5554   | 164300     | 0.0045        | -               |
| 7.5600   | 164400     | 0.0047        | -               |
| 7.5646   | 164500     | 0.0052        | -               |
| 7.5692   | 164600     | 0.0054        | -               |
| 7.5738   | 164700     | 0.0056        | -               |
| 7.5784   | 164800     | 0.0056        | -               |
| 7.5830   | 164900     | 0.0043        | -               |
| 7.5876   | 165000     | 0.0041        | -               |
| 7.5922   | 165100     | 0.0043        | -               |
| 7.5968   | 165200     | 0.0047        | -               |
| 7.6014   | 165300     | 0.0052        | -               |
| 7.6060   | 165400     | 0.004         | -               |
| 7.6106   | 165500     | 0.0049        | -               |
| 7.6152   | 165600     | 0.0042        | -               |
| 7.6198   | 165700     | 0.0057        | -               |
| 7.6244   | 165800     | 0.0041        | -               |
| 7.6290   | 165900     | 0.0059        | -               |
| 7.6336   | 166000     | 0.0056        | -               |
| 7.6382   | 166100     | 0.0043        | -               |
| 7.6428   | 166200     | 0.0045        | -               |
| 7.6474   | 166300     | 0.0048        | -               |
| 7.6520   | 166400     | 0.0046        | -               |
| 7.6566   | 166500     | 0.0041        | -               |
| 7.6612   | 166600     | 0.0042        | -               |
| 7.6658   | 166700     | 0.0043        | -               |
| 7.6704   | 166800     | 0.0044        | -               |
| 7.6750   | 166900     | 0.0039        | -               |
| 7.6796   | 167000     | 0.0054        | -               |
| 7.6842   | 167100     | 0.0056        | -               |
| 7.6888   | 167200     | 0.0042        | -               |
| 7.6934   | 167300     | 0.0041        | -               |
| 7.6980   | 167400     | 0.0047        | -               |
| 7.7026   | 167500     | 0.0052        | -               |
| 7.7072   | 167600     | 0.0061        | -               |
| 7.7118   | 167700     | 0.0049        | -               |
| 7.7164   | 167800     | 0.0062        | -               |
| 7.7210   | 167900     | 0.0053        | -               |
| 7.7256   | 168000     | 0.0051        | -               |
| 7.7302   | 168100     | 0.0052        | -               |
| 7.7348   | 168200     | 0.0047        | -               |
| 7.7394   | 168300     | 0.0056        | -               |
| 7.7440   | 168400     | 0.0054        | -               |
| 7.7486   | 168500     | 0.0041        | -               |
| 7.7532   | 168600     | 0.0049        | -               |
| 7.7577   | 168700     | 0.0041        | -               |
| 7.7623   | 168800     | 0.0035        | -               |
| 7.7669   | 168900     | 0.0055        | -               |
| 7.7715   | 169000     | 0.0044        | -               |
| 7.7761   | 169100     | 0.0051        | -               |
| 7.7807   | 169200     | 0.0052        | -               |
| 7.7853   | 169300     | 0.0055        | -               |
| 7.7899   | 169400     | 0.0047        | -               |
| 7.7945   | 169500     | 0.0051        | -               |
| 7.7991   | 169600     | 0.0054        | -               |
| 7.8037   | 169700     | 0.0059        | -               |
| 7.8083   | 169800     | 0.0047        | -               |
| 7.8129   | 169900     | 0.0041        | -               |
| 7.8175   | 170000     | 0.0054        | -               |
| 7.8221   | 170100     | 0.0047        | -               |
| 7.8267   | 170200     | 0.0042        | -               |
| 7.8313   | 170300     | 0.0053        | -               |
| 7.8359   | 170400     | 0.0044        | -               |
| 7.8405   | 170500     | 0.0046        | -               |
| 7.8451   | 170600     | 0.005         | -               |
| 7.8497   | 170700     | 0.0051        | -               |
| 7.8543   | 170800     | 0.0039        | -               |
| 7.8589   | 170900     | 0.0054        | -               |
| 7.8635   | 171000     | 0.0037        | -               |
| 7.8681   | 171100     | 0.0041        | -               |
| 7.8727   | 171200     | 0.0041        | -               |
| 7.8773   | 171300     | 0.0054        | -               |
| 7.8819   | 171400     | 0.0045        | -               |
| 7.8865   | 171500     | 0.005         | -               |
| 7.8911   | 171600     | 0.0053        | -               |
| 7.8957   | 171700     | 0.0048        | -               |
| 7.9003   | 171800     | 0.0043        | -               |
| 7.9049   | 171900     | 0.0054        | -               |
| 7.9095   | 172000     | 0.0056        | -               |
| 7.9141   | 172100     | 0.0037        | -               |
| 7.9187   | 172200     | 0.0046        | -               |
| 7.9233   | 172300     | 0.0036        | -               |
| 7.9279   | 172400     | 0.0054        | -               |
| 7.9325   | 172500     | 0.0045        | -               |
| 7.9371   | 172600     | 0.0041        | -               |
| 7.9417   | 172700     | 0.004         | -               |
| 7.9463   | 172800     | 0.0045        | -               |
| 7.9509   | 172900     | 0.0048        | -               |
| 7.9555   | 173000     | 0.0053        | -               |
| 7.9601   | 173100     | 0.0037        | -               |
| 7.9647   | 173200     | 0.0045        | -               |
| 7.9693   | 173300     | 0.004         | -               |
| 7.9739   | 173400     | 0.0055        | -               |
| 7.9785   | 173500     | 0.0052        | -               |
| 7.9831   | 173600     | 0.0042        | -               |
| 7.9877   | 173700     | 0.0048        | -               |
| 7.9923   | 173800     | 0.0046        | -               |
| 7.9969   | 173900     | 0.0046        | -               |
| 8.0      | 173968     | -             | 0.0411          |
| 8.0015   | 174000     | 0.0047        | -               |
| 8.0061   | 174100     | 0.0031        | -               |
| 8.0107   | 174200     | 0.0038        | -               |
| 8.0153   | 174300     | 0.0042        | -               |
| 8.0199   | 174400     | 0.0046        | -               |
| 8.0245   | 174500     | 0.0033        | -               |
| 8.0291   | 174600     | 0.004         | -               |
| 8.0337   | 174700     | 0.0035        | -               |
| 8.0383   | 174800     | 0.0043        | -               |
| 8.0429   | 174900     | 0.0048        | -               |
| 8.0475   | 175000     | 0.0043        | -               |
| 8.0521   | 175100     | 0.0039        | -               |
| 8.0567   | 175200     | 0.0037        | -               |
| 8.0613   | 175300     | 0.0033        | -               |
| 8.0659   | 175400     | 0.0043        | -               |
| 8.0704   | 175500     | 0.0045        | -               |
| 8.0750   | 175600     | 0.0035        | -               |
| 8.0796   | 175700     | 0.0038        | -               |
| 8.0842   | 175800     | 0.0034        | -               |
| 8.0888   | 175900     | 0.0043        | -               |
| 8.0934   | 176000     | 0.0031        | -               |
| 8.0980   | 176100     | 0.0036        | -               |
| 8.1026   | 176200     | 0.0033        | -               |
| 8.1072   | 176300     | 0.0037        | -               |
| 8.1118   | 176400     | 0.0036        | -               |
| 8.1164   | 176500     | 0.0045        | -               |
| 8.1210   | 176600     | 0.004         | -               |
| 8.1256   | 176700     | 0.0037        | -               |
| 8.1302   | 176800     | 0.0044        | -               |
| 8.1348   | 176900     | 0.0032        | -               |
| 8.1394   | 177000     | 0.0043        | -               |
| 8.1440   | 177100     | 0.0052        | -               |
| 8.1486   | 177200     | 0.0031        | -               |
| 8.1532   | 177300     | 0.0044        | -               |
| 8.1578   | 177400     | 0.0032        | -               |
| 8.1624   | 177500     | 0.0047        | -               |
| 8.1670   | 177600     | 0.0048        | -               |
| 8.1716   | 177700     | 0.0031        | -               |
| 8.1762   | 177800     | 0.0035        | -               |
| 8.1808   | 177900     | 0.0044        | -               |
| 8.1854   | 178000     | 0.0037        | -               |
| 8.1900   | 178100     | 0.0035        | -               |
| 8.1946   | 178200     | 0.0041        | -               |
| 8.1992   | 178300     | 0.004         | -               |
| 8.2038   | 178400     | 0.0037        | -               |
| 8.2084   | 178500     | 0.0038        | -               |
| 8.2130   | 178600     | 0.0046        | -               |
| 8.2176   | 178700     | 0.0039        | -               |
| 8.2222   | 178800     | 0.0043        | -               |
| 8.2268   | 178900     | 0.004         | -               |
| 8.2314   | 179000     | 0.0034        | -               |
| 8.2360   | 179100     | 0.004         | -               |
| 8.2406   | 179200     | 0.0028        | -               |
| 8.2452   | 179300     | 0.0037        | -               |
| 8.2498   | 179400     | 0.0049        | -               |
| 8.2544   | 179500     | 0.0037        | -               |
| 8.2590   | 179600     | 0.0045        | -               |
| 8.2636   | 179700     | 0.0041        | -               |
| 8.2682   | 179800     | 0.0043        | -               |
| 8.2728   | 179900     | 0.0045        | -               |
| 8.2774   | 180000     | 0.0047        | -               |
| 8.2820   | 180100     | 0.0046        | -               |
| 8.2866   | 180200     | 0.0039        | -               |
| 8.2912   | 180300     | 0.0039        | -               |
| 8.2958   | 180400     | 0.0041        | -               |
| 8.3004   | 180500     | 0.0045        | -               |
| 8.3050   | 180600     | 0.0035        | -               |
| 8.3096   | 180700     | 0.0031        | -               |
| 8.3142   | 180800     | 0.004         | -               |
| 8.3188   | 180900     | 0.0036        | -               |
| 8.3234   | 181000     | 0.0044        | -               |
| 8.3280   | 181100     | 0.004         | -               |
| 8.3326   | 181200     | 0.0043        | -               |
| 8.3372   | 181300     | 0.0043        | -               |
| 8.3418   | 181400     | 0.0038        | -               |
| 8.3464   | 181500     | 0.0044        | -               |
| 8.3510   | 181600     | 0.0035        | -               |
| 8.3556   | 181700     | 0.0045        | -               |
| 8.3602   | 181800     | 0.0033        | -               |
| 8.3648   | 181900     | 0.0036        | -               |
| 8.3694   | 182000     | 0.0034        | -               |
| 8.3740   | 182100     | 0.0043        | -               |
| 8.3786   | 182200     | 0.0041        | -               |
| 8.3832   | 182300     | 0.0032        | -               |
| 8.3877   | 182400     | 0.0035        | -               |
| 8.3923   | 182500     | 0.0043        | -               |
| 8.3969   | 182600     | 0.0038        | -               |
| 8.4015   | 182700     | 0.004         | -               |
| 8.4061   | 182800     | 0.004         | -               |
| 8.4107   | 182900     | 0.0041        | -               |
| 8.4153   | 183000     | 0.004         | -               |
| 8.4199   | 183100     | 0.0043        | -               |
| 8.4245   | 183200     | 0.0046        | -               |
| 8.4291   | 183300     | 0.0033        | -               |
| 8.4337   | 183400     | 0.0036        | -               |
| 8.4383   | 183500     | 0.0036        | -               |
| 8.4429   | 183600     | 0.004         | -               |
| 8.4475   | 183700     | 0.0042        | -               |
| 8.4521   | 183800     | 0.0041        | -               |
| 8.4567   | 183900     | 0.0038        | -               |
| 8.4613   | 184000     | 0.0052        | -               |
| 8.4659   | 184100     | 0.0047        | -               |
| 8.4705   | 184200     | 0.0042        | -               |
| 8.4751   | 184300     | 0.0036        | -               |
| 8.4797   | 184400     | 0.0038        | -               |
| 8.4843   | 184500     | 0.0036        | -               |
| 8.4889   | 184600     | 0.0041        | -               |
| 8.4935   | 184700     | 0.004         | -               |
| 8.4981   | 184800     | 0.0034        | -               |
| 8.5027   | 184900     | 0.0039        | -               |
| 8.5073   | 185000     | 0.0038        | -               |
| 8.5119   | 185100     | 0.004         | -               |
| 8.5165   | 185200     | 0.0033        | -               |
| 8.5211   | 185300     | 0.0038        | -               |
| 8.5257   | 185400     | 0.0035        | -               |
| 8.5303   | 185500     | 0.0033        | -               |
| 8.5349   | 185600     | 0.004         | -               |
| 8.5395   | 185700     | 0.0041        | -               |
| 8.5441   | 185800     | 0.0045        | -               |
| 8.5487   | 185900     | 0.0042        | -               |
| 8.5533   | 186000     | 0.0035        | -               |
| 8.5579   | 186100     | 0.0039        | -               |
| 8.5625   | 186200     | 0.0036        | -               |
| 8.5671   | 186300     | 0.0036        | -               |
| 8.5717   | 186400     | 0.0042        | -               |
| 8.5763   | 186500     | 0.0041        | -               |
| 8.5809   | 186600     | 0.0037        | -               |
| 8.5855   | 186700     | 0.0035        | -               |
| 8.5901   | 186800     | 0.0042        | -               |
| 8.5947   | 186900     | 0.0042        | -               |
| 8.5993   | 187000     | 0.0044        | -               |
| 8.6039   | 187100     | 0.0041        | -               |
| 8.6085   | 187200     | 0.0038        | -               |
| 8.6131   | 187300     | 0.0044        | -               |
| 8.6177   | 187400     | 0.0049        | -               |
| 8.6223   | 187500     | 0.0042        | -               |
| 8.6269   | 187600     | 0.0034        | -               |
| 8.6315   | 187700     | 0.0041        | -               |
| 8.6361   | 187800     | 0.0041        | -               |
| 8.6407   | 187900     | 0.0048        | -               |
| 8.6453   | 188000     | 0.0037        | -               |
| 8.6499   | 188100     | 0.0055        | -               |
| 8.6545   | 188200     | 0.0048        | -               |
| 8.6591   | 188300     | 0.0049        | -               |
| 8.6637   | 188400     | 0.0041        | -               |
| 8.6683   | 188500     | 0.0042        | -               |
| 8.6729   | 188600     | 0.0036        | -               |
| 8.6775   | 188700     | 0.0046        | -               |
| 8.6821   | 188800     | 0.004         | -               |
| 8.6867   | 188900     | 0.0031        | -               |
| 8.6913   | 189000     | 0.005         | -               |
| 8.6959   | 189100     | 0.0037        | -               |
| 8.7005   | 189200     | 0.0041        | -               |
| 8.7050   | 189300     | 0.0051        | -               |
| 8.7096   | 189400     | 0.0045        | -               |
| 8.7142   | 189500     | 0.0046        | -               |
| 8.7188   | 189600     | 0.0041        | -               |
| 8.7234   | 189700     | 0.0038        | -               |
| 8.7280   | 189800     | 0.0043        | -               |
| 8.7326   | 189900     | 0.0049        | -               |
| 8.7372   | 190000     | 0.0038        | -               |
| 8.7418   | 190100     | 0.0043        | -               |
| 8.7464   | 190200     | 0.0037        | -               |
| 8.7510   | 190300     | 0.0044        | -               |
| 8.7556   | 190400     | 0.0035        | -               |
| 8.7602   | 190500     | 0.003         | -               |
| 8.7648   | 190600     | 0.0043        | -               |
| 8.7694   | 190700     | 0.0036        | -               |
| 8.7740   | 190800     | 0.0036        | -               |
| 8.7786   | 190900     | 0.0034        | -               |
| 8.7832   | 191000     | 0.0034        | -               |
| 8.7878   | 191100     | 0.0044        | -               |
| 8.7924   | 191200     | 0.0037        | -               |
| 8.7970   | 191300     | 0.0038        | -               |
| 8.8016   | 191400     | 0.0054        | -               |
| 8.8062   | 191500     | 0.0041        | -               |
| 8.8108   | 191600     | 0.0042        | -               |
| 8.8154   | 191700     | 0.0036        | -               |
| 8.8200   | 191800     | 0.0041        | -               |
| 8.8246   | 191900     | 0.0035        | -               |
| 8.8292   | 192000     | 0.0042        | -               |
| 8.8338   | 192100     | 0.0032        | -               |
| 8.8384   | 192200     | 0.0041        | -               |
| 8.8430   | 192300     | 0.0029        | -               |
| 8.8476   | 192400     | 0.0046        | -               |
| 8.8522   | 192500     | 0.0051        | -               |
| 8.8568   | 192600     | 0.0034        | -               |
| 8.8614   | 192700     | 0.003         | -               |
| 8.8660   | 192800     | 0.0036        | -               |
| 8.8706   | 192900     | 0.0039        | -               |
| 8.8752   | 193000     | 0.0041        | -               |
| 8.8798   | 193100     | 0.0038        | -               |
| 8.8844   | 193200     | 0.0044        | -               |
| 8.8890   | 193300     | 0.0041        | -               |
| 8.8936   | 193400     | 0.0043        | -               |
| 8.8982   | 193500     | 0.0042        | -               |
| 8.9028   | 193600     | 0.0047        | -               |
| 8.9074   | 193700     | 0.0036        | -               |
| 8.9120   | 193800     | 0.0047        | -               |
| 8.9166   | 193900     | 0.004         | -               |
| 8.9212   | 194000     | 0.004         | -               |
| 8.9258   | 194100     | 0.0037        | -               |
| 8.9304   | 194200     | 0.0044        | -               |
| 8.9350   | 194300     | 0.0036        | -               |
| 8.9396   | 194400     | 0.0036        | -               |
| 8.9442   | 194500     | 0.0042        | -               |
| 8.9488   | 194600     | 0.0049        | -               |
| 8.9534   | 194700     | 0.0044        | -               |
| 8.9580   | 194800     | 0.0029        | -               |
| 8.9626   | 194900     | 0.004         | -               |
| 8.9672   | 195000     | 0.0043        | -               |
| 8.9718   | 195100     | 0.0038        | -               |
| 8.9764   | 195200     | 0.0038        | -               |
| 8.9810   | 195300     | 0.0038        | -               |
| 8.9856   | 195400     | 0.0038        | -               |
| 8.9902   | 195500     | 0.005         | -               |
| 8.9948   | 195600     | 0.0035        | -               |
| 8.9994   | 195700     | 0.0038        | -               |
| 9.0      | 195714     | -             | 0.0415          |
| 9.0040   | 195800     | 0.0039        | -               |
| 9.0086   | 195900     | 0.0032        | -               |
| 9.0132   | 196000     | 0.0032        | -               |
| 9.0178   | 196100     | 0.0037        | -               |
| 9.0223   | 196200     | 0.0037        | -               |
| 9.0269   | 196300     | 0.0033        | -               |
| 9.0315   | 196400     | 0.0035        | -               |
| 9.0361   | 196500     | 0.0031        | -               |
| 9.0407   | 196600     | 0.0042        | -               |
| 9.0453   | 196700     | 0.0036        | -               |
| 9.0499   | 196800     | 0.0029        | -               |
| 9.0545   | 196900     | 0.0024        | -               |
| 9.0591   | 197000     | 0.0029        | -               |
| 9.0637   | 197100     | 0.0041        | -               |
| 9.0683   | 197200     | 0.0029        | -               |
| 9.0729   | 197300     | 0.0028        | -               |
| 9.0775   | 197400     | 0.003         | -               |
| 9.0821   | 197500     | 0.0026        | -               |
| 9.0867   | 197600     | 0.0032        | -               |
| 9.0913   | 197700     | 0.0027        | -               |
| 9.0959   | 197800     | 0.0028        | -               |
| 9.1005   | 197900     | 0.0042        | -               |
| 9.1051   | 198000     | 0.0031        | -               |
| 9.1097   | 198100     | 0.0041        | -               |
| 9.1143   | 198200     | 0.0031        | -               |
| 9.1189   | 198300     | 0.0031        | -               |
| 9.1235   | 198400     | 0.0033        | -               |
| 9.1281   | 198500     | 0.0029        | -               |
| 9.1327   | 198600     | 0.0037        | -               |
| 9.1373   | 198700     | 0.0031        | -               |
| 9.1419   | 198800     | 0.0028        | -               |
| 9.1465   | 198900     | 0.0029        | -               |
| 9.1511   | 199000     | 0.0034        | -               |
| 9.1557   | 199100     | 0.0032        | -               |
| 9.1603   | 199200     | 0.0029        | -               |
| 9.1649   | 199300     | 0.0033        | -               |
| 9.1695   | 199400     | 0.0039        | -               |
| 9.1741   | 199500     | 0.003         | -               |
| 9.1787   | 199600     | 0.0025        | -               |
| 9.1833   | 199700     | 0.0031        | -               |
| 9.1879   | 199800     | 0.0029        | -               |
| 9.1925   | 199900     | 0.0032        | -               |
| 9.1971   | 200000     | 0.0031        | -               |
| 9.2017   | 200100     | 0.0032        | -               |
| 9.2063   | 200200     | 0.0035        | -               |
| 9.2109   | 200300     | 0.0036        | -               |
| 9.2155   | 200400     | 0.0032        | -               |
| 9.2201   | 200500     | 0.0033        | -               |
| 9.2247   | 200600     | 0.0036        | -               |
| 9.2293   | 200700     | 0.0028        | -               |
| 9.2339   | 200800     | 0.0031        | -               |
| 9.2385   | 200900     | 0.0034        | -               |
| 9.2431   | 201000     | 0.0036        | -               |
| 9.2477   | 201100     | 0.0034        | -               |
| 9.2523   | 201200     | 0.004         | -               |
| 9.2569   | 201300     | 0.0031        | -               |
| 9.2615   | 201400     | 0.0028        | -               |
| 9.2661   | 201500     | 0.0035        | -               |
| 9.2707   | 201600     | 0.0036        | -               |
| 9.2753   | 201700     | 0.0033        | -               |
| 9.2799   | 201800     | 0.0034        | -               |
| 9.2845   | 201900     | 0.0035        | -               |
| 9.2891   | 202000     | 0.003         | -               |
| 9.2937   | 202100     | 0.0029        | -               |
| 9.2983   | 202200     | 0.0033        | -               |
| 9.3029   | 202300     | 0.003         | -               |
| 9.3075   | 202400     | 0.004         | -               |
| 9.3121   | 202500     | 0.0034        | -               |
| 9.3167   | 202600     | 0.0036        | -               |
| 9.3213   | 202700     | 0.0037        | -               |
| 9.3259   | 202800     | 0.0032        | -               |
| 9.3305   | 202900     | 0.0039        | -               |
| 9.3351   | 203000     | 0.0033        | -               |
| 9.3396   | 203100     | 0.003         | -               |
| 9.3442   | 203200     | 0.0034        | -               |
| 9.3488   | 203300     | 0.0033        | -               |
| 9.3534   | 203400     | 0.0028        | -               |
| 9.3580   | 203500     | 0.0035        | -               |
| 9.3626   | 203600     | 0.0042        | -               |
| 9.3672   | 203700     | 0.0032        | -               |
| 9.3718   | 203800     | 0.0033        | -               |
| 9.3764   | 203900     | 0.0035        | -               |
| 9.3810   | 204000     | 0.0023        | -               |
| 9.3856   | 204100     | 0.0034        | -               |
| 9.3902   | 204200     | 0.0035        | -               |
| 9.3948   | 204300     | 0.003         | -               |
| 9.3994   | 204400     | 0.0025        | -               |
| 9.4040   | 204500     | 0.0027        | -               |
| 9.4086   | 204600     | 0.0038        | -               |
| 9.4132   | 204700     | 0.0029        | -               |
| 9.4178   | 204800     | 0.0029        | -               |
| 9.4224   | 204900     | 0.0032        | -               |
| 9.4270   | 205000     | 0.0032        | -               |
| 9.4316   | 205100     | 0.0032        | -               |
| 9.4362   | 205200     | 0.0039        | -               |
| 9.4408   | 205300     | 0.0029        | -               |
| 9.4454   | 205400     | 0.0032        | -               |
| 9.4500   | 205500     | 0.0031        | -               |
| 9.4546   | 205600     | 0.0039        | -               |
| 9.4592   | 205700     | 0.0043        | -               |
| 9.4638   | 205800     | 0.003         | -               |
| 9.4684   | 205900     | 0.0036        | -               |
| 9.4730   | 206000     | 0.003         | -               |
| 9.4776   | 206100     | 0.0042        | -               |
| 9.4822   | 206200     | 0.003         | -               |
| 9.4868   | 206300     | 0.0035        | -               |
| 9.4914   | 206400     | 0.0028        | -               |
| 9.4960   | 206500     | 0.0045        | -               |
| 9.5006   | 206600     | 0.003         | -               |
| 9.5052   | 206700     | 0.004         | -               |
| 9.5098   | 206800     | 0.0037        | -               |
| 9.5144   | 206900     | 0.0043        | -               |
| 9.5190   | 207000     | 0.0033        | -               |
| 9.5236   | 207100     | 0.0032        | -               |
| 9.5282   | 207200     | 0.0032        | -               |
| 9.5328   | 207300     | 0.0026        | -               |
| 9.5374   | 207400     | 0.004         | -               |
| 9.5420   | 207500     | 0.0041        | -               |
| 9.5466   | 207600     | 0.0044        | -               |
| 9.5512   | 207700     | 0.0029        | -               |
| 9.5558   | 207800     | 0.003         | -               |
| 9.5604   | 207900     | 0.0032        | -               |
| 9.5650   | 208000     | 0.0028        | -               |
| 9.5696   | 208100     | 0.0028        | -               |
| 9.5742   | 208200     | 0.003         | -               |
| 9.5788   | 208300     | 0.0036        | -               |
| 9.5834   | 208400     | 0.0038        | -               |
| 9.5880   | 208500     | 0.0029        | -               |
| 9.5926   | 208600     | 0.0039        | -               |
| 9.5972   | 208700     | 0.0036        | -               |
| 9.6018   | 208800     | 0.0029        | -               |
| 9.6064   | 208900     | 0.0031        | -               |
| 9.6110   | 209000     | 0.0035        | -               |
| 9.6156   | 209100     | 0.0032        | -               |
| 9.6202   | 209200     | 0.0032        | -               |
| 9.6248   | 209300     | 0.0035        | -               |
| 9.6294   | 209400     | 0.003         | -               |
| 9.6340   | 209500     | 0.0036        | -               |
| 9.6386   | 209600     | 0.0042        | -               |
| 9.6432   | 209700     | 0.0039        | -               |
| 9.6478   | 209800     | 0.0026        | -               |
| 9.6523   | 209900     | 0.0035        | -               |
| 9.6569   | 210000     | 0.0033        | -               |
| 9.6615   | 210100     | 0.0029        | -               |
| 9.6661   | 210200     | 0.0028        | -               |
| 9.6707   | 210300     | 0.0032        | -               |
| 9.6753   | 210400     | 0.0033        | -               |
| 9.6799   | 210500     | 0.0043        | -               |
| 9.6845   | 210600     | 0.0032        | -               |
| 9.6891   | 210700     | 0.0026        | -               |
| 9.6937   | 210800     | 0.0034        | -               |
| 9.6983   | 210900     | 0.0028        | -               |
| 9.7029   | 211000     | 0.0038        | -               |
| 9.7075   | 211100     | 0.0031        | -               |
| 9.7121   | 211200     | 0.0027        | -               |
| 9.7167   | 211300     | 0.0031        | -               |
| 9.7213   | 211400     | 0.003         | -               |
| 9.7259   | 211500     | 0.0025        | -               |
| 9.7305   | 211600     | 0.0031        | -               |
| 9.7351   | 211700     | 0.0036        | -               |
| 9.7397   | 211800     | 0.0025        | -               |
| 9.7443   | 211900     | 0.0035        | -               |
| 9.7489   | 212000     | 0.003         | -               |
| 9.7535   | 212100     | 0.0025        | -               |
| 9.7581   | 212200     | 0.0037        | -               |
| 9.7627   | 212300     | 0.003         | -               |
| 9.7673   | 212400     | 0.0036        | -               |
| 9.7719   | 212500     | 0.0033        | -               |
| 9.7765   | 212600     | 0.0035        | -               |
| 9.7811   | 212700     | 0.0036        | -               |
| 9.7857   | 212800     | 0.0042        | -               |
| 9.7903   | 212900     | 0.0028        | -               |
| 9.7949   | 213000     | 0.0036        | -               |
| 9.7995   | 213100     | 0.0033        | -               |
| 9.8041   | 213200     | 0.0038        | -               |
| 9.8087   | 213300     | 0.0043        | -               |
| 9.8133   | 213400     | 0.004         | -               |
| 9.8179   | 213500     | 0.0033        | -               |
| 9.8225   | 213600     | 0.0041        | -               |
| 9.8271   | 213700     | 0.0041        | -               |
| 9.8317   | 213800     | 0.0026        | -               |
| 9.8363   | 213900     | 0.0031        | -               |
| 9.8409   | 214000     | 0.0028        | -               |
| 9.8455   | 214100     | 0.0034        | -               |
| 9.8501   | 214200     | 0.0028        | -               |
| 9.8547   | 214300     | 0.0031        | -               |
| 9.8593   | 214400     | 0.0026        | -               |
| 9.8639   | 214500     | 0.0041        | -               |
| 9.8685   | 214600     | 0.0029        | -               |
| 9.8731   | 214700     | 0.0034        | -               |
| 9.8777   | 214800     | 0.0033        | -               |
| 9.8823   | 214900     | 0.0034        | -               |
| 9.8869   | 215000     | 0.0038        | -               |
| 9.8915   | 215100     | 0.0033        | -               |
| 9.8961   | 215200     | 0.0031        | -               |
| 9.9007   | 215300     | 0.0024        | -               |
| 9.9053   | 215400     | 0.0032        | -               |
| 9.9099   | 215500     | 0.0029        | -               |
| 9.9145   | 215600     | 0.0034        | -               |
| 9.9191   | 215700     | 0.0036        | -               |
| 9.9237   | 215800     | 0.0034        | -               |
| 9.9283   | 215900     | 0.0031        | -               |
| 9.9329   | 216000     | 0.0029        | -               |
| 9.9375   | 216100     | 0.0033        | -               |
| 9.9421   | 216200     | 0.0027        | -               |
| 9.9467   | 216300     | 0.0043        | -               |
| 9.9513   | 216400     | 0.0035        | -               |
| 9.9559   | 216500     | 0.0031        | -               |
| 9.9605   | 216600     | 0.0033        | -               |
| 9.9651   | 216700     | 0.0034        | -               |
| 9.9696   | 216800     | 0.004         | -               |
| 9.9742   | 216900     | 0.0026        | -               |
| 9.9788   | 217000     | 0.0025        | -               |
| 9.9834   | 217100     | 0.003         | -               |
| 9.9880   | 217200     | 0.0026        | -               |
| 9.9926   | 217300     | 0.0029        | -               |
| 9.9972   | 217400     | 0.0027        | -               |
| 10.0     | 217460     | -             | 0.0395          |
| 10.0018  | 217500     | 0.0037        | -               |
| 10.0064  | 217600     | 0.0027        | -               |
| 10.0110  | 217700     | 0.003         | -               |
| 10.0156  | 217800     | 0.0023        | -               |
| 10.0202  | 217900     | 0.0027        | -               |
| 10.0248  | 218000     | 0.0037        | -               |
| 10.0294  | 218100     | 0.0032        | -               |
| 10.0340  | 218200     | 0.0042        | -               |
| 10.0386  | 218300     | 0.0027        | -               |
| 10.0432  | 218400     | 0.0029        | -               |
| 10.0478  | 218500     | 0.0026        | -               |
| 10.0524  | 218600     | 0.0034        | -               |
| 10.0570  | 218700     | 0.0027        | -               |
| 10.0616  | 218800     | 0.0026        | -               |
| 10.0662  | 218900     | 0.0024        | -               |
| 10.0708  | 219000     | 0.0019        | -               |
| 10.0754  | 219100     | 0.0027        | -               |
| 10.0800  | 219200     | 0.0023        | -               |
| 10.0846  | 219300     | 0.0024        | -               |
| 10.0892  | 219400     | 0.0025        | -               |
| 10.0938  | 219500     | 0.0028        | -               |
| 10.0984  | 219600     | 0.0025        | -               |
| 10.1030  | 219700     | 0.0031        | -               |
| 10.1076  | 219800     | 0.0022        | -               |
| 10.1122  | 219900     | 0.0024        | -               |
| 10.1168  | 220000     | 0.0036        | -               |
| 10.1214  | 220100     | 0.0026        | -               |
| 10.1260  | 220200     | 0.0028        | -               |
| 10.1306  | 220300     | 0.0029        | -               |
| 10.1352  | 220400     | 0.0026        | -               |
| 10.1398  | 220500     | 0.0025        | -               |
| 10.1444  | 220600     | 0.0025        | -               |
| 10.1490  | 220700     | 0.0026        | -               |
| 10.1536  | 220800     | 0.003         | -               |
| 10.1582  | 220900     | 0.0026        | -               |
| 10.1628  | 221000     | 0.0026        | -               |
| 10.1674  | 221100     | 0.002         | -               |
| 10.1720  | 221200     | 0.0028        | -               |
| 10.1766  | 221300     | 0.0023        | -               |
| 10.1812  | 221400     | 0.0028        | -               |
| 10.1858  | 221500     | 0.0023        | -               |
| 10.1904  | 221600     | 0.0024        | -               |
| 10.1950  | 221700     | 0.0035        | -               |
| 10.1996  | 221800     | 0.0028        | -               |
| 10.2042  | 221900     | 0.0024        | -               |
| 10.2088  | 222000     | 0.0022        | -               |
| 10.2134  | 222100     | 0.0026        | -               |
| 10.2180  | 222200     | 0.0032        | -               |
| 10.2226  | 222300     | 0.003         | -               |
| 10.2272  | 222400     | 0.0028        | -               |
| 10.2318  | 222500     | 0.0035        | -               |
| 10.2364  | 222600     | 0.0033        | -               |
| 10.2410  | 222700     | 0.0023        | -               |
| 10.2456  | 222800     | 0.0026        | -               |
| 10.2502  | 222900     | 0.0029        | -               |
| 10.2548  | 223000     | 0.0029        | -               |
| 10.2594  | 223100     | 0.0025        | -               |
| 10.2640  | 223200     | 0.0036        | -               |
| 10.2686  | 223300     | 0.0023        | -               |
| 10.2732  | 223400     | 0.0024        | -               |
| 10.2778  | 223500     | 0.0024        | -               |
| 10.2824  | 223600     | 0.0025        | -               |
| 10.2869  | 223700     | 0.0037        | -               |
| 10.2915  | 223800     | 0.0032        | -               |
| 10.2961  | 223900     | 0.0024        | -               |
| 10.3007  | 224000     | 0.0028        | -               |
| 10.3053  | 224100     | 0.003         | -               |
| 10.3099  | 224200     | 0.0025        | -               |
| 10.3145  | 224300     | 0.0029        | -               |
| 10.3191  | 224400     | 0.0025        | -               |
| 10.3237  | 224500     | 0.0021        | -               |
| 10.3283  | 224600     | 0.0024        | -               |
| 10.3329  | 224700     | 0.0024        | -               |
| 10.3375  | 224800     | 0.0026        | -               |
| 10.3421  | 224900     | 0.0033        | -               |
| 10.3467  | 225000     | 0.0029        | -               |
| 10.3513  | 225100     | 0.0029        | -               |
| 10.3559  | 225200     | 0.0023        | -               |
| 10.3605  | 225300     | 0.0027        | -               |
| 10.3651  | 225400     | 0.0024        | -               |
| 10.3697  | 225500     | 0.0032        | -               |
| 10.3743  | 225600     | 0.0027        | -               |
| 10.3789  | 225700     | 0.0031        | -               |
| 10.3835  | 225800     | 0.0023        | -               |
| 10.3881  | 225900     | 0.0026        | -               |
| 10.3927  | 226000     | 0.0038        | -               |
| 10.3973  | 226100     | 0.0026        | -               |
| 10.4019  | 226200     | 0.0027        | -               |
| 10.4065  | 226300     | 0.0022        | -               |
| 10.4111  | 226400     | 0.0033        | -               |
| 10.4157  | 226500     | 0.0038        | -               |
| 10.4203  | 226600     | 0.0037        | -               |
| 10.4249  | 226700     | 0.0024        | -               |
| 10.4295  | 226800     | 0.0026        | -               |
| 10.4341  | 226900     | 0.0022        | -               |
| 10.4387  | 227000     | 0.0029        | -               |
| 10.4433  | 227100     | 0.0027        | -               |
| 10.4479  | 227200     | 0.0024        | -               |
| 10.4525  | 227300     | 0.002         | -               |
| 10.4571  | 227400     | 0.0023        | -               |
| 10.4617  | 227500     | 0.0025        | -               |
| 10.4663  | 227600     | 0.0022        | -               |
| 10.4709  | 227700     | 0.0025        | -               |
| 10.4755  | 227800     | 0.0033        | -               |
| 10.4801  | 227900     | 0.0021        | -               |
| 10.4847  | 228000     | 0.0024        | -               |
| 10.4893  | 228100     | 0.0028        | -               |
| 10.4939  | 228200     | 0.002         | -               |
| 10.4985  | 228300     | 0.0028        | -               |
| 10.5031  | 228400     | 0.0035        | -               |
| 10.5077  | 228500     | 0.0027        | -               |
| 10.5123  | 228600     | 0.0023        | -               |
| 10.5169  | 228700     | 0.0025        | -               |
| 10.5215  | 228800     | 0.002         | -               |
| 10.5261  | 228900     | 0.0024        | -               |
| 10.5307  | 229000     | 0.0026        | -               |
| 10.5353  | 229100     | 0.0023        | -               |
| 10.5399  | 229200     | 0.0031        | -               |
| 10.5445  | 229300     | 0.0024        | -               |
| 10.5491  | 229400     | 0.0027        | -               |
| 10.5537  | 229500     | 0.0031        | -               |
| 10.5583  | 229600     | 0.0026        | -               |
| 10.5629  | 229700     | 0.0026        | -               |
| 10.5675  | 229800     | 0.0025        | -               |
| 10.5721  | 229900     | 0.0031        | -               |
| 10.5767  | 230000     | 0.0028        | -               |
| 10.5813  | 230100     | 0.0022        | -               |
| 10.5859  | 230200     | 0.0028        | -               |
| 10.5905  | 230300     | 0.0032        | -               |
| 10.5951  | 230400     | 0.0023        | -               |
| 10.5997  | 230500     | 0.0024        | -               |
| 10.6042  | 230600     | 0.0032        | -               |
| 10.6088  | 230700     | 0.0028        | -               |
| 10.6134  | 230800     | 0.0027        | -               |
| 10.6180  | 230900     | 0.0029        | -               |
| 10.6226  | 231000     | 0.0026        | -               |
| 10.6272  | 231100     | 0.0028        | -               |
| 10.6318  | 231200     | 0.0027        | -               |
| 10.6364  | 231300     | 0.0025        | -               |
| 10.6410  | 231400     | 0.0024        | -               |
| 10.6456  | 231500     | 0.0023        | -               |
| 10.6502  | 231600     | 0.0032        | -               |
| 10.6548  | 231700     | 0.0025        | -               |
| 10.6594  | 231800     | 0.0035        | -               |
| 10.6640  | 231900     | 0.0033        | -               |
| 10.6686  | 232000     | 0.0025        | -               |
| 10.6732  | 232100     | 0.0033        | -               |
| 10.6778  | 232200     | 0.0031        | -               |
| 10.6824  | 232300     | 0.0027        | -               |
| 10.6870  | 232400     | 0.0031        | -               |
| 10.6916  | 232500     | 0.0029        | -               |
| 10.6962  | 232600     | 0.002         | -               |
| 10.7008  | 232700     | 0.0028        | -               |
| 10.7054  | 232800     | 0.0026        | -               |
| 10.7100  | 232900     | 0.0021        | -               |
| 10.7146  | 233000     | 0.0034        | -               |
| 10.7192  | 233100     | 0.0021        | -               |
| 10.7238  | 233200     | 0.0021        | -               |
| 10.7284  | 233300     | 0.0027        | -               |
| 10.7330  | 233400     | 0.0026        | -               |
| 10.7376  | 233500     | 0.0038        | -               |
| 10.7422  | 233600     | 0.0026        | -               |
| 10.7468  | 233700     | 0.0027        | -               |
| 10.7514  | 233800     | 0.0032        | -               |
| 10.7560  | 233900     | 0.0024        | -               |
| 10.7606  | 234000     | 0.0021        | -               |
| 10.7652  | 234100     | 0.003         | -               |
| 10.7698  | 234200     | 0.0027        | -               |
| 10.7744  | 234300     | 0.0018        | -               |
| 10.7790  | 234400     | 0.003         | -               |
| 10.7836  | 234500     | 0.0032        | -               |
| 10.7882  | 234600     | 0.0031        | -               |
| 10.7928  | 234700     | 0.0028        | -               |
| 10.7974  | 234800     | 0.0029        | -               |
| 10.8020  | 234900     | 0.0035        | -               |
| 10.8066  | 235000     | 0.0027        | -               |
| 10.8112  | 235100     | 0.0023        | -               |
| 10.8158  | 235200     | 0.0024        | -               |
| 10.8204  | 235300     | 0.0034        | -               |
| 10.8250  | 235400     | 0.0022        | -               |
| 10.8296  | 235500     | 0.0024        | -               |
| 10.8342  | 235600     | 0.0024        | -               |
| 10.8388  | 235700     | 0.0024        | -               |
| 10.8434  | 235800     | 0.0031        | -               |
| 10.8480  | 235900     | 0.0023        | -               |
| 10.8526  | 236000     | 0.0024        | -               |
| 10.8572  | 236100     | 0.003         | -               |
| 10.8618  | 236200     | 0.0025        | -               |
| 10.8664  | 236300     | 0.0027        | -               |
| 10.8710  | 236400     | 0.0028        | -               |
| 10.8756  | 236500     | 0.0031        | -               |
| 10.8802  | 236600     | 0.0029        | -               |
| 10.8848  | 236700     | 0.0025        | -               |
| 10.8894  | 236800     | 0.0033        | -               |
| 10.8940  | 236900     | 0.0031        | -               |
| 10.8986  | 237000     | 0.0032        | -               |
| 10.9032  | 237100     | 0.0023        | -               |
| 10.9078  | 237200     | 0.0032        | -               |
| 10.9124  | 237300     | 0.0034        | -               |
| 10.9170  | 237400     | 0.0023        | -               |
| 10.9215  | 237500     | 0.0031        | -               |
| 10.9261  | 237600     | 0.0029        | -               |
| 10.9307  | 237700     | 0.0029        | -               |
| 10.9353  | 237800     | 0.0026        | -               |
| 10.9399  | 237900     | 0.0024        | -               |
| 10.9445  | 238000     | 0.0022        | -               |
| 10.9491  | 238100     | 0.0025        | -               |
| 10.9537  | 238200     | 0.0032        | -               |
| 10.9583  | 238300     | 0.0027        | -               |
| 10.9629  | 238400     | 0.0027        | -               |
| 10.9675  | 238500     | 0.0023        | -               |
| 10.9721  | 238600     | 0.0024        | -               |
| 10.9767  | 238700     | 0.0037        | -               |
| 10.9813  | 238800     | 0.003         | -               |
| 10.9859  | 238900     | 0.0028        | -               |
| 10.9905  | 239000     | 0.0032        | -               |
| 10.9951  | 239100     | 0.0022        | -               |
| 10.9997  | 239200     | 0.003         | -               |
| 11.0     | 239206     | -             | 0.0373          |
| 11.0043  | 239300     | 0.0025        | -               |
| 11.0089  | 239400     | 0.0024        | -               |
| 11.0135  | 239500     | 0.0021        | -               |
| 11.0181  | 239600     | 0.0025        | -               |
| 11.0227  | 239700     | 0.0026        | -               |
| 11.0273  | 239800     | 0.0018        | -               |
| 11.0319  | 239900     | 0.002         | -               |
| 11.0365  | 240000     | 0.0023        | -               |
| 11.0411  | 240100     | 0.0025        | -               |
| 11.0457  | 240200     | 0.0024        | -               |
| 11.0503  | 240300     | 0.0018        | -               |
| 11.0549  | 240400     | 0.0022        | -               |
| 11.0595  | 240500     | 0.0022        | -               |
| 11.0641  | 240600     | 0.0018        | -               |
| 11.0687  | 240700     | 0.002         | -               |
| 11.0733  | 240800     | 0.0023        | -               |
| 11.0779  | 240900     | 0.0022        | -               |
| 11.0825  | 241000     | 0.0024        | -               |
| 11.0871  | 241100     | 0.0023        | -               |
| 11.0917  | 241200     | 0.0025        | -               |
| 11.0963  | 241300     | 0.0026        | -               |
| 11.1009  | 241400     | 0.0022        | -               |
| 11.1055  | 241500     | 0.0021        | -               |
| 11.1101  | 241600     | 0.0025        | -               |
| 11.1147  | 241700     | 0.0019        | -               |
| 11.1193  | 241800     | 0.0017        | -               |
| 11.1239  | 241900     | 0.0028        | -               |
| 11.1285  | 242000     | 0.0022        | -               |
| 11.1331  | 242100     | 0.0029        | -               |
| 11.1377  | 242200     | 0.0021        | -               |
| 11.1423  | 242300     | 0.0021        | -               |
| 11.1469  | 242400     | 0.0025        | -               |
| 11.1515  | 242500     | 0.0024        | -               |
| 11.1561  | 242600     | 0.0022        | -               |
| 11.1607  | 242700     | 0.0025        | -               |
| 11.1653  | 242800     | 0.0023        | -               |
| 11.1699  | 242900     | 0.0028        | -               |
| 11.1745  | 243000     | 0.0021        | -               |
| 11.1791  | 243100     | 0.0024        | -               |
| 11.1837  | 243200     | 0.0018        | -               |
| 11.1883  | 243300     | 0.0031        | -               |
| 11.1929  | 243400     | 0.0026        | -               |
| 11.1975  | 243500     | 0.0023        | -               |
| 11.2021  | 243600     | 0.0024        | -               |
| 11.2067  | 243700     | 0.0017        | -               |
| 11.2113  | 243800     | 0.0027        | -               |
| 11.2159  | 243900     | 0.0025        | -               |
| 11.2205  | 244000     | 0.0034        | -               |
| 11.2251  | 244100     | 0.0026        | -               |
| 11.2297  | 244200     | 0.003         | -               |
| 11.2342  | 244300     | 0.0025        | -               |
| 11.2388  | 244400     | 0.0022        | -               |
| 11.2434  | 244500     | 0.0023        | -               |
| 11.2480  | 244600     | 0.0025        | -               |
| 11.2526  | 244700     | 0.0026        | -               |
| 11.2572  | 244800     | 0.0024        | -               |
| 11.2618  | 244900     | 0.0024        | -               |
| 11.2664  | 245000     | 0.0026        | -               |
| 11.2710  | 245100     | 0.0027        | -               |
| 11.2756  | 245200     | 0.0022        | -               |
| 11.2802  | 245300     | 0.0021        | -               |
| 11.2848  | 245400     | 0.0023        | -               |
| 11.2894  | 245500     | 0.0023        | -               |
| 11.2940  | 245600     | 0.0023        | -               |
| 11.2986  | 245700     | 0.0021        | -               |
| 11.3032  | 245800     | 0.0028        | -               |
| 11.3078  | 245900     | 0.0023        | -               |
| 11.3124  | 246000     | 0.0029        | -               |
| 11.3170  | 246100     | 0.0022        | -               |
| 11.3216  | 246200     | 0.0019        | -               |
| 11.3262  | 246300     | 0.0023        | -               |
| 11.3308  | 246400     | 0.0024        | -               |
| 11.3354  | 246500     | 0.0029        | -               |
| 11.3400  | 246600     | 0.0021        | -               |
| 11.3446  | 246700     | 0.0034        | -               |
| 11.3492  | 246800     | 0.0029        | -               |
| 11.3538  | 246900     | 0.002         | -               |
| 11.3584  | 247000     | 0.0024        | -               |
| 11.3630  | 247100     | 0.0028        | -               |
| 11.3676  | 247200     | 0.0028        | -               |
| 11.3722  | 247300     | 0.0025        | -               |
| 11.3768  | 247400     | 0.002         | -               |
| 11.3814  | 247500     | 0.002         | -               |
| 11.3860  | 247600     | 0.002         | -               |
| 11.3906  | 247700     | 0.0016        | -               |
| 11.3952  | 247800     | 0.0022        | -               |
| 11.3998  | 247900     | 0.0028        | -               |
| 11.4044  | 248000     | 0.0023        | -               |
| 11.4090  | 248100     | 0.0022        | -               |
| 11.4136  | 248200     | 0.0032        | -               |
| 11.4182  | 248300     | 0.0025        | -               |
| 11.4228  | 248400     | 0.0028        | -               |
| 11.4274  | 248500     | 0.0019        | -               |
| 11.4320  | 248600     | 0.0033        | -               |
| 11.4366  | 248700     | 0.0023        | -               |
| 11.4412  | 248800     | 0.0019        | -               |
| 11.4458  | 248900     | 0.002         | -               |
| 11.4504  | 249000     | 0.0027        | -               |
| 11.4550  | 249100     | 0.0026        | -               |
| 11.4596  | 249200     | 0.002         | -               |
| 11.4642  | 249300     | 0.0021        | -               |
| 11.4688  | 249400     | 0.0027        | -               |
| 11.4734  | 249500     | 0.0025        | -               |
| 11.4780  | 249600     | 0.0022        | -               |
| 11.4826  | 249700     | 0.0028        | -               |
| 11.4872  | 249800     | 0.0018        | -               |
| 11.4918  | 249900     | 0.0031        | -               |
| 11.4964  | 250000     | 0.0022        | -               |
| 11.5010  | 250100     | 0.0019        | -               |
| 11.5056  | 250200     | 0.0024        | -               |
| 11.5102  | 250300     | 0.0024        | -               |
| 11.5148  | 250400     | 0.0024        | -               |
| 11.5194  | 250500     | 0.0028        | -               |
| 11.5240  | 250600     | 0.0018        | -               |
| 11.5286  | 250700     | 0.002         | -               |
| 11.5332  | 250800     | 0.0023        | -               |
| 11.5378  | 250900     | 0.0028        | -               |
| 11.5424  | 251000     | 0.003         | -               |
| 11.5470  | 251100     | 0.002         | -               |
| 11.5515  | 251200     | 0.0033        | -               |
| 11.5561  | 251300     | 0.0018        | -               |
| 11.5607  | 251400     | 0.002         | -               |
| 11.5653  | 251500     | 0.0023        | -               |
| 11.5699  | 251600     | 0.0025        | -               |
| 11.5745  | 251700     | 0.0024        | -               |
| 11.5791  | 251800     | 0.0018        | -               |
| 11.5837  | 251900     | 0.0018        | -               |
| 11.5883  | 252000     | 0.0023        | -               |
| 11.5929  | 252100     | 0.0026        | -               |
| 11.5975  | 252200     | 0.0025        | -               |
| 11.6021  | 252300     | 0.0018        | -               |
| 11.6067  | 252400     | 0.0027        | -               |
| 11.6113  | 252500     | 0.0023        | -               |
| 11.6159  | 252600     | 0.0021        | -               |
| 11.6205  | 252700     | 0.0024        | -               |
| 11.6251  | 252800     | 0.0024        | -               |
| 11.6297  | 252900     | 0.0025        | -               |
| 11.6343  | 253000     | 0.0024        | -               |
| 11.6389  | 253100     | 0.0018        | -               |
| 11.6435  | 253200     | 0.0021        | -               |
| 11.6481  | 253300     | 0.0029        | -               |
| 11.6527  | 253400     | 0.0028        | -               |
| 11.6573  | 253500     | 0.0019        | -               |
| 11.6619  | 253600     | 0.0027        | -               |
| 11.6665  | 253700     | 0.0026        | -               |
| 11.6711  | 253800     | 0.0023        | -               |
| 11.6757  | 253900     | 0.0025        | -               |
| 11.6803  | 254000     | 0.0026        | -               |
| 11.6849  | 254100     | 0.0023        | -               |
| 11.6895  | 254200     | 0.0022        | -               |
| 11.6941  | 254300     | 0.0016        | -               |
| 11.6987  | 254400     | 0.0019        | -               |
| 11.7033  | 254500     | 0.0027        | -               |
| 11.7079  | 254600     | 0.002         | -               |
| 11.7125  | 254700     | 0.0029        | -               |
| 11.7171  | 254800     | 0.0023        | -               |
| 11.7217  | 254900     | 0.0024        | -               |
| 11.7263  | 255000     | 0.0027        | -               |
| 11.7309  | 255100     | 0.0024        | -               |
| 11.7355  | 255200     | 0.0025        | -               |
| 11.7401  | 255300     | 0.0024        | -               |
| 11.7447  | 255400     | 0.0024        | -               |
| 11.7493  | 255500     | 0.0027        | -               |
| 11.7539  | 255600     | 0.0023        | -               |
| 11.7585  | 255700     | 0.0021        | -               |
| 11.7631  | 255800     | 0.002         | -               |
| 11.7677  | 255900     | 0.0024        | -               |
| 11.7723  | 256000     | 0.0022        | -               |
| 11.7769  | 256100     | 0.002         | -               |
| 11.7815  | 256200     | 0.003         | -               |
| 11.7861  | 256300     | 0.0024        | -               |
| 11.7907  | 256400     | 0.0022        | -               |
| 11.7953  | 256500     | 0.0025        | -               |
| 11.7999  | 256600     | 0.0024        | -               |
| 11.8045  | 256700     | 0.0026        | -               |
| 11.8091  | 256800     | 0.0019        | -               |
| 11.8137  | 256900     | 0.0021        | -               |
| 11.8183  | 257000     | 0.0032        | -               |
| 11.8229  | 257100     | 0.0026        | -               |
| 11.8275  | 257200     | 0.0018        | -               |
| 11.8321  | 257300     | 0.0026        | -               |
| 11.8367  | 257400     | 0.0019        | -               |
| 11.8413  | 257500     | 0.0024        | -               |
| 11.8459  | 257600     | 0.0029        | -               |
| 11.8505  | 257700     | 0.0022        | -               |
| 11.8551  | 257800     | 0.0027        | -               |
| 11.8597  | 257900     | 0.003         | -               |
| 11.8643  | 258000     | 0.0024        | -               |
| 11.8688  | 258100     | 0.0026        | -               |
| 11.8734  | 258200     | 0.0026        | -               |
| 11.8780  | 258300     | 0.0022        | -               |
| 11.8826  | 258400     | 0.0025        | -               |
| 11.8872  | 258500     | 0.0027        | -               |
| 11.8918  | 258600     | 0.003         | -               |
| 11.8964  | 258700     | 0.0024        | -               |
| 11.9010  | 258800     | 0.002         | -               |
| 11.9056  | 258900     | 0.0021        | -               |
| 11.9102  | 259000     | 0.002         | -               |
| 11.9148  | 259100     | 0.0022        | -               |
| 11.9194  | 259200     | 0.0019        | -               |
| 11.9240  | 259300     | 0.002         | -               |
| 11.9286  | 259400     | 0.0024        | -               |
| 11.9332  | 259500     | 0.0021        | -               |
| 11.9378  | 259600     | 0.002         | -               |
| 11.9424  | 259700     | 0.0024        | -               |
| 11.9470  | 259800     | 0.002         | -               |
| 11.9516  | 259900     | 0.0023        | -               |
| 11.9562  | 260000     | 0.0021        | -               |
| 11.9608  | 260100     | 0.0032        | -               |
| 11.9654  | 260200     | 0.0019        | -               |
| 11.9700  | 260300     | 0.0026        | -               |
| 11.9746  | 260400     | 0.0034        | -               |
| 11.9792  | 260500     | 0.0027        | -               |
| 11.9838  | 260600     | 0.0025        | -               |
| 11.9884  | 260700     | 0.0024        | -               |
| 11.9930  | 260800     | 0.0029        | -               |
| 11.9976  | 260900     | 0.0022        | -               |
| 12.0     | 260952     | -             | 0.0373          |
| 12.0022  | 261000     | 0.0025        | -               |
| 12.0068  | 261100     | 0.0022        | -               |
| 12.0114  | 261200     | 0.0022        | -               |
| 12.0160  | 261300     | 0.0019        | -               |
| 12.0206  | 261400     | 0.0015        | -               |
| 12.0252  | 261500     | 0.0021        | -               |
| 12.0298  | 261600     | 0.0026        | -               |
| 12.0344  | 261700     | 0.0018        | -               |
| 12.0390  | 261800     | 0.0025        | -               |
| 12.0436  | 261900     | 0.0017        | -               |
| 12.0482  | 262000     | 0.0024        | -               |
| 12.0528  | 262100     | 0.0016        | -               |
| 12.0574  | 262200     | 0.002         | -               |
| 12.0620  | 262300     | 0.0017        | -               |
| 12.0666  | 262400     | 0.0018        | -               |
| 12.0712  | 262500     | 0.0021        | -               |
| 12.0758  | 262600     | 0.0017        | -               |
| 12.0804  | 262700     | 0.0017        | -               |
| 12.0850  | 262800     | 0.0025        | -               |
| 12.0896  | 262900     | 0.0015        | -               |
| 12.0942  | 263000     | 0.0017        | -               |
| 12.0988  | 263100     | 0.002         | -               |
| 12.1034  | 263200     | 0.0017        | -               |
| 12.1080  | 263300     | 0.0021        | -               |
| 12.1126  | 263400     | 0.0019        | -               |
| 12.1172  | 263500     | 0.0023        | -               |
| 12.1218  | 263600     | 0.0024        | -               |
| 12.1264  | 263700     | 0.0024        | -               |
| 12.1310  | 263800     | 0.0017        | -               |
| 12.1356  | 263900     | 0.0024        | -               |
| 12.1402  | 264000     | 0.0024        | -               |
| 12.1448  | 264100     | 0.0021        | -               |
| 12.1494  | 264200     | 0.0027        | -               |
| 12.1540  | 264300     | 0.0021        | -               |
| 12.1586  | 264400     | 0.0022        | -               |
| 12.1632  | 264500     | 0.0024        | -               |
| 12.1678  | 264600     | 0.0023        | -               |
| 12.1724  | 264700     | 0.0021        | -               |
| 12.1770  | 264800     | 0.0019        | -               |
| 12.1816  | 264900     | 0.0026        | -               |
| 12.1861  | 265000     | 0.002         | -               |
| 12.1907  | 265100     | 0.0021        | -               |
| 12.1953  | 265200     | 0.0029        | -               |
| 12.1999  | 265300     | 0.002         | -               |
| 12.2045  | 265400     | 0.0015        | -               |
| 12.2091  | 265500     | 0.0015        | -               |
| 12.2137  | 265600     | 0.0019        | -               |
| 12.2183  | 265700     | 0.0024        | -               |
| 12.2229  | 265800     | 0.0014        | -               |
| 12.2275  | 265900     | 0.0022        | -               |
| 12.2321  | 266000     | 0.0016        | -               |
| 12.2367  | 266100     | 0.0022        | -               |
| 12.2413  | 266200     | 0.0021        | -               |
| 12.2459  | 266300     | 0.0023        | -               |
| 12.2505  | 266400     | 0.0022        | -               |
| 12.2551  | 266500     | 0.0022        | -               |
| 12.2597  | 266600     | 0.0024        | -               |
| 12.2643  | 266700     | 0.0018        | -               |
| 12.2689  | 266800     | 0.0015        | -               |
| 12.2735  | 266900     | 0.0025        | -               |
| 12.2781  | 267000     | 0.0019        | -               |
| 12.2827  | 267100     | 0.0015        | -               |
| 12.2873  | 267200     | 0.0017        | -               |
| 12.2919  | 267300     | 0.0019        | -               |
| 12.2965  | 267400     | 0.0019        | -               |
| 12.3011  | 267500     | 0.0025        | -               |
| 12.3057  | 267600     | 0.0022        | -               |
| 12.3103  | 267700     | 0.0028        | -               |
| 12.3149  | 267800     | 0.0022        | -               |
| 12.3195  | 267900     | 0.0023        | -               |
| 12.3241  | 268000     | 0.0022        | -               |
| 12.3287  | 268100     | 0.0022        | -               |
| 12.3333  | 268200     | 0.0021        | -               |
| 12.3379  | 268300     | 0.0017        | -               |
| 12.3425  | 268400     | 0.0015        | -               |
| 12.3471  | 268500     | 0.0022        | -               |
| 12.3517  | 268600     | 0.0021        | -               |
| 12.3563  | 268700     | 0.0017        | -               |
| 12.3609  | 268800     | 0.0016        | -               |
| 12.3655  | 268900     | 0.0014        | -               |
| 12.3701  | 269000     | 0.0021        | -               |
| 12.3747  | 269100     | 0.0022        | -               |
| 12.3793  | 269200     | 0.0021        | -               |
| 12.3839  | 269300     | 0.0018        | -               |
| 12.3885  | 269400     | 0.0025        | -               |
| 12.3931  | 269500     | 0.0014        | -               |
| 12.3977  | 269600     | 0.0016        | -               |
| 12.4023  | 269700     | 0.0018        | -               |
| 12.4069  | 269800     | 0.0018        | -               |
| 12.4115  | 269900     | 0.0019        | -               |
| 12.4161  | 270000     | 0.0025        | -               |
| 12.4207  | 270100     | 0.0019        | -               |
| 12.4253  | 270200     | 0.0028        | -               |
| 12.4299  | 270300     | 0.0022        | -               |
| 12.4345  | 270400     | 0.0019        | -               |
| 12.4391  | 270500     | 0.0021        | -               |
| 12.4437  | 270600     | 0.0024        | -               |
| 12.4483  | 270700     | 0.0018        | -               |
| 12.4529  | 270800     | 0.0017        | -               |
| 12.4575  | 270900     | 0.0019        | -               |
| 12.4621  | 271000     | 0.002         | -               |
| 12.4667  | 271100     | 0.0022        | -               |
| 12.4713  | 271200     | 0.0018        | -               |
| 12.4759  | 271300     | 0.0021        | -               |
| 12.4805  | 271400     | 0.002         | -               |
| 12.4851  | 271500     | 0.0016        | -               |
| 12.4897  | 271600     | 0.0025        | -               |
| 12.4943  | 271700     | 0.0018        | -               |
| 12.4989  | 271800     | 0.0021        | -               |
| 12.5034  | 271900     | 0.002         | -               |
| 12.5080  | 272000     | 0.0017        | -               |
| 12.5126  | 272100     | 0.002         | -               |
| 12.5172  | 272200     | 0.0023        | -               |
| 12.5218  | 272300     | 0.0021        | -               |
| 12.5264  | 272400     | 0.0022        | -               |
| 12.5310  | 272500     | 0.0019        | -               |
| 12.5356  | 272600     | 0.0018        | -               |
| 12.5402  | 272700     | 0.0022        | -               |
| 12.5448  | 272800     | 0.0026        | -               |
| 12.5494  | 272900     | 0.0021        | -               |
| 12.5540  | 273000     | 0.0023        | -               |
| 12.5586  | 273100     | 0.0024        | -               |
| 12.5632  | 273200     | 0.0022        | -               |
| 12.5678  | 273300     | 0.0018        | -               |
| 12.5724  | 273400     | 0.0024        | -               |
| 12.5770  | 273500     | 0.0026        | -               |
| 12.5816  | 273600     | 0.0027        | -               |
| 12.5862  | 273700     | 0.0024        | -               |
| 12.5908  | 273800     | 0.0024        | -               |
| 12.5954  | 273900     | 0.0021        | -               |
| 12.6000  | 274000     | 0.002         | -               |
| 12.6046  | 274100     | 0.0019        | -               |
| 12.6092  | 274200     | 0.0032        | -               |
| 12.6138  | 274300     | 0.0019        | -               |
| 12.6184  | 274400     | 0.0019        | -               |
| 12.6230  | 274500     | 0.0023        | -               |
| 12.6276  | 274600     | 0.0021        | -               |
| 12.6322  | 274700     | 0.0014        | -               |
| 12.6368  | 274800     | 0.0018        | -               |
| 12.6414  | 274900     | 0.002         | -               |
| 12.6460  | 275000     | 0.0023        | -               |
| 12.6506  | 275100     | 0.0021        | -               |
| 12.6552  | 275200     | 0.0019        | -               |
| 12.6598  | 275300     | 0.0023        | -               |
| 12.6644  | 275400     | 0.0031        | -               |
| 12.6690  | 275500     | 0.0023        | -               |
| 12.6736  | 275600     | 0.0022        | -               |
| 12.6782  | 275700     | 0.0016        | -               |
| 12.6828  | 275800     | 0.002         | -               |
| 12.6874  | 275900     | 0.002         | -               |
| 12.6920  | 276000     | 0.0016        | -               |
| 12.6966  | 276100     | 0.0024        | -               |
| 12.7012  | 276200     | 0.0021        | -               |
| 12.7058  | 276300     | 0.002         | -               |
| 12.7104  | 276400     | 0.0016        | -               |
| 12.7150  | 276500     | 0.0024        | -               |
| 12.7196  | 276600     | 0.0018        | -               |
| 12.7242  | 276700     | 0.002         | -               |
| 12.7288  | 276800     | 0.0019        | -               |
| 12.7334  | 276900     | 0.0017        | -               |
| 12.7380  | 277000     | 0.0031        | -               |
| 12.7426  | 277100     | 0.0017        | -               |
| 12.7472  | 277200     | 0.0024        | -               |
| 12.7518  | 277300     | 0.002         | -               |
| 12.7564  | 277400     | 0.002         | -               |
| 12.7610  | 277500     | 0.0024        | -               |
| 12.7656  | 277600     | 0.0023        | -               |
| 12.7702  | 277700     | 0.0019        | -               |
| 12.7748  | 277800     | 0.0019        | -               |
| 12.7794  | 277900     | 0.0022        | -               |
| 12.7840  | 278000     | 0.0015        | -               |
| 12.7886  | 278100     | 0.0026        | -               |
| 12.7932  | 278200     | 0.002         | -               |
| 12.7978  | 278300     | 0.0018        | -               |
| 12.8024  | 278400     | 0.002         | -               |
| 12.8070  | 278500     | 0.0019        | -               |
| 12.8116  | 278600     | 0.0018        | -               |
| 12.8162  | 278700     | 0.0019        | -               |
| 12.8207  | 278800     | 0.0025        | -               |
| 12.8253  | 278900     | 0.0017        | -               |
| 12.8299  | 279000     | 0.0018        | -               |
| 12.8345  | 279100     | 0.0019        | -               |
| 12.8391  | 279200     | 0.0016        | -               |
| 12.8437  | 279300     | 0.0027        | -               |
| 12.8483  | 279400     | 0.0017        | -               |
| 12.8529  | 279500     | 0.0018        | -               |
| 12.8575  | 279600     | 0.0018        | -               |
| 12.8621  | 279700     | 0.0018        | -               |
| 12.8667  | 279800     | 0.0021        | -               |
| 12.8713  | 279900     | 0.0021        | -               |
| 12.8759  | 280000     | 0.0017        | -               |
| 12.8805  | 280100     | 0.0025        | -               |
| 12.8851  | 280200     | 0.0023        | -               |
| 12.8897  | 280300     | 0.0017        | -               |
| 12.8943  | 280400     | 0.0022        | -               |
| 12.8989  | 280500     | 0.0023        | -               |
| 12.9035  | 280600     | 0.002         | -               |
| 12.9081  | 280700     | 0.002         | -               |
| 12.9127  | 280800     | 0.0013        | -               |
| 12.9173  | 280900     | 0.0022        | -               |
| 12.9219  | 281000     | 0.0016        | -               |
| 12.9265  | 281100     | 0.0017        | -               |
| 12.9311  | 281200     | 0.0022        | -               |
| 12.9357  | 281300     | 0.0016        | -               |
| 12.9403  | 281400     | 0.0017        | -               |
| 12.9449  | 281500     | 0.0017        | -               |
| 12.9495  | 281600     | 0.0017        | -               |
| 12.9541  | 281700     | 0.0023        | -               |
| 12.9587  | 281800     | 0.0025        | -               |
| 12.9633  | 281900     | 0.0017        | -               |
| 12.9679  | 282000     | 0.0019        | -               |
| 12.9725  | 282100     | 0.002         | -               |
| 12.9771  | 282200     | 0.0018        | -               |
| 12.9817  | 282300     | 0.0027        | -               |
| 12.9863  | 282400     | 0.0016        | -               |
| 12.9909  | 282500     | 0.0026        | -               |
| 12.9955  | 282600     | 0.002         | -               |
| 13.0     | 282698     | -             | 0.0348          |
| 13.0001  | 282700     | 0.0021        | -               |
| 13.0047  | 282800     | 0.0019        | -               |
| 13.0093  | 282900     | 0.0017        | -               |
| 13.0139  | 283000     | 0.0016        | -               |
| 13.0185  | 283100     | 0.0026        | -               |
| 13.0231  | 283200     | 0.0016        | -               |
| 13.0277  | 283300     | 0.0021        | -               |
| 13.0323  | 283400     | 0.0016        | -               |
| 13.0369  | 283500     | 0.002         | -               |
| 13.0415  | 283600     | 0.0016        | -               |
| 13.0461  | 283700     | 0.0015        | -               |
| 13.0507  | 283800     | 0.0017        | -               |
| 13.0553  | 283900     | 0.0014        | -               |
| 13.0599  | 284000     | 0.0019        | -               |
| 13.0645  | 284100     | 0.002         | -               |
| 13.0691  | 284200     | 0.0015        | -               |
| 13.0737  | 284300     | 0.0015        | -               |
| 13.0783  | 284400     | 0.0021        | -               |
| 13.0829  | 284500     | 0.002         | -               |
| 13.0875  | 284600     | 0.0015        | -               |
| 13.0921  | 284700     | 0.002         | -               |
| 13.0967  | 284800     | 0.0019        | -               |
| 13.1013  | 284900     | 0.0018        | -               |
| 13.1059  | 285000     | 0.0022        | -               |
| 13.1105  | 285100     | 0.0018        | -               |
| 13.1151  | 285200     | 0.0016        | -               |
| 13.1197  | 285300     | 0.0016        | -               |
| 13.1243  | 285400     | 0.0019        | -               |
| 13.1289  | 285500     | 0.0021        | -               |
| 13.1334  | 285600     | 0.0016        | -               |
| 13.1380  | 285700     | 0.0013        | -               |
| 13.1426  | 285800     | 0.0017        | -               |
| 13.1472  | 285900     | 0.0017        | -               |
| 13.1518  | 286000     | 0.0017        | -               |
| 13.1564  | 286100     | 0.0016        | -               |
| 13.1610  | 286200     | 0.0016        | -               |
| 13.1656  | 286300     | 0.0017        | -               |
| 13.1702  | 286400     | 0.0014        | -               |
| 13.1748  | 286500     | 0.0022        | -               |
| 13.1794  | 286600     | 0.0019        | -               |
| 13.1840  | 286700     | 0.0021        | -               |
| 13.1886  | 286800     | 0.0021        | -               |
| 13.1932  | 286900     | 0.002         | -               |
| 13.1978  | 287000     | 0.0021        | -               |
| 13.2024  | 287100     | 0.0018        | -               |
| 13.2070  | 287200     | 0.0015        | -               |
| 13.2116  | 287300     | 0.002         | -               |
| 13.2162  | 287400     | 0.0016        | -               |
| 13.2208  | 287500     | 0.002         | -               |
| 13.2254  | 287600     | 0.0014        | -               |
| 13.2300  | 287700     | 0.0017        | -               |
| 13.2346  | 287800     | 0.0015        | -               |
| 13.2392  | 287900     | 0.0015        | -               |
| 13.2438  | 288000     | 0.002         | -               |
| 13.2484  | 288100     | 0.0015        | -               |
| 13.2530  | 288200     | 0.0014        | -               |
| 13.2576  | 288300     | 0.0015        | -               |
| 13.2622  | 288400     | 0.002         | -               |
| 13.2668  | 288500     | 0.0021        | -               |
| 13.2714  | 288600     | 0.0016        | -               |
| 13.2760  | 288700     | 0.0019        | -               |
| 13.2806  | 288800     | 0.0016        | -               |
| 13.2852  | 288900     | 0.0019        | -               |
| 13.2898  | 289000     | 0.0021        | -               |
| 13.2944  | 289100     | 0.0015        | -               |
| 13.2990  | 289200     | 0.0012        | -               |
| 13.3036  | 289300     | 0.0016        | -               |
| 13.3082  | 289400     | 0.0013        | -               |
| 13.3128  | 289500     | 0.0016        | -               |
| 13.3174  | 289600     | 0.0015        | -               |
| 13.3220  | 289700     | 0.0022        | -               |
| 13.3266  | 289800     | 0.0025        | -               |
| 13.3312  | 289900     | 0.002         | -               |
| 13.3358  | 290000     | 0.0012        | -               |
| 13.3404  | 290100     | 0.0018        | -               |
| 13.3450  | 290200     | 0.0013        | -               |
| 13.3496  | 290300     | 0.0017        | -               |
| 13.3542  | 290400     | 0.0017        | -               |
| 13.3588  | 290500     | 0.0023        | -               |
| 13.3634  | 290600     | 0.0016        | -               |
| 13.3680  | 290700     | 0.0015        | -               |
| 13.3726  | 290800     | 0.0016        | -               |
| 13.3772  | 290900     | 0.0016        | -               |
| 13.3818  | 291000     | 0.0021        | -               |
| 13.3864  | 291100     | 0.0016        | -               |
| 13.3910  | 291200     | 0.0018        | -               |
| 13.3956  | 291300     | 0.0016        | -               |
| 13.4002  | 291400     | 0.0019        | -               |
| 13.4048  | 291500     | 0.0019        | -               |
| 13.4094  | 291600     | 0.0014        | -               |
| 13.4140  | 291700     | 0.0013        | -               |
| 13.4186  | 291800     | 0.0018        | -               |
| 13.4232  | 291900     | 0.0014        | -               |
| 13.4278  | 292000     | 0.0017        | -               |
| 13.4324  | 292100     | 0.0012        | -               |
| 13.4370  | 292200     | 0.0022        | -               |
| 13.4416  | 292300     | 0.0015        | -               |
| 13.4462  | 292400     | 0.0015        | -               |
| 13.4507  | 292500     | 0.0019        | -               |
| 13.4553  | 292600     | 0.0014        | -               |
| 13.4599  | 292700     | 0.0024        | -               |
| 13.4645  | 292800     | 0.0026        | -               |
| 13.4691  | 292900     | 0.0022        | -               |
| 13.4737  | 293000     | 0.0018        | -               |
| 13.4783  | 293100     | 0.0018        | -               |
| 13.4829  | 293200     | 0.0016        | -               |
| 13.4875  | 293300     | 0.0015        | -               |
| 13.4921  | 293400     | 0.0018        | -               |
| 13.4967  | 293500     | 0.0014        | -               |
| 13.5013  | 293600     | 0.0017        | -               |
| 13.5059  | 293700     | 0.0013        | -               |
| 13.5105  | 293800     | 0.0016        | -               |
| 13.5151  | 293900     | 0.0022        | -               |
| 13.5197  | 294000     | 0.0018        | -               |
| 13.5243  | 294100     | 0.0021        | -               |
| 13.5289  | 294200     | 0.0017        | -               |
| 13.5335  | 294300     | 0.0015        | -               |
| 13.5381  | 294400     | 0.0009        | -               |
| 13.5427  | 294500     | 0.0017        | -               |
| 13.5473  | 294600     | 0.0018        | -               |
| 13.5519  | 294700     | 0.0017        | -               |
| 13.5565  | 294800     | 0.002         | -               |
| 13.5611  | 294900     | 0.0017        | -               |
| 13.5657  | 295000     | 0.0012        | -               |
| 13.5703  | 295100     | 0.0021        | -               |
| 13.5749  | 295200     | 0.0019        | -               |
| 13.5795  | 295300     | 0.0022        | -               |
| 13.5841  | 295400     | 0.0016        | -               |
| 13.5887  | 295500     | 0.0019        | -               |
| 13.5933  | 295600     | 0.0025        | -               |
| 13.5979  | 295700     | 0.0017        | -               |
| 13.6025  | 295800     | 0.0022        | -               |
| 13.6071  | 295900     | 0.0021        | -               |
| 13.6117  | 296000     | 0.0019        | -               |
| 13.6163  | 296100     | 0.0015        | -               |
| 13.6209  | 296200     | 0.0021        | -               |
| 13.6255  | 296300     | 0.0015        | -               |
| 13.6301  | 296400     | 0.0014        | -               |
| 13.6347  | 296500     | 0.002         | -               |
| 13.6393  | 296600     | 0.0023        | -               |
| 13.6439  | 296700     | 0.0017        | -               |
| 13.6485  | 296800     | 0.0016        | -               |
| 13.6531  | 296900     | 0.0014        | -               |
| 13.6577  | 297000     | 0.0016        | -               |
| 13.6623  | 297100     | 0.0018        | -               |
| 13.6669  | 297200     | 0.0025        | -               |
| 13.6715  | 297300     | 0.0022        | -               |
| 13.6761  | 297400     | 0.0011        | -               |
| 13.6807  | 297500     | 0.0017        | -               |
| 13.6853  | 297600     | 0.0013        | -               |
| 13.6899  | 297700     | 0.0019        | -               |
| 13.6945  | 297800     | 0.0018        | -               |
| 13.6991  | 297900     | 0.0021        | -               |
| 13.7037  | 298000     | 0.002         | -               |
| 13.7083  | 298100     | 0.002         | -               |
| 13.7129  | 298200     | 0.002         | -               |
| 13.7175  | 298300     | 0.002         | -               |
| 13.7221  | 298400     | 0.0016        | -               |
| 13.7267  | 298500     | 0.0016        | -               |
| 13.7313  | 298600     | 0.0016        | -               |
| 13.7359  | 298700     | 0.0016        | -               |
| 13.7405  | 298800     | 0.0016        | -               |
| 13.7451  | 298900     | 0.0019        | -               |
| 13.7497  | 299000     | 0.0015        | -               |
| 13.7543  | 299100     | 0.0015        | -               |
| 13.7589  | 299200     | 0.0022        | -               |
| 13.7635  | 299300     | 0.0017        | -               |
| 13.7680  | 299400     | 0.0019        | -               |
| 13.7726  | 299500     | 0.0017        | -               |
| 13.7772  | 299600     | 0.0016        | -               |
| 13.7818  | 299700     | 0.0019        | -               |
| 13.7864  | 299800     | 0.0017        | -               |
| 13.7910  | 299900     | 0.0014        | -               |
| 13.7956  | 300000     | 0.0017        | -               |
| 13.8002  | 300100     | 0.0015        | -               |
| 13.8048  | 300200     | 0.0013        | -               |
| 13.8094  | 300300     | 0.0021        | -               |
| 13.8140  | 300400     | 0.0015        | -               |
| 13.8186  | 300500     | 0.0025        | -               |
| 13.8232  | 300600     | 0.002         | -               |
| 13.8278  | 300700     | 0.0019        | -               |
| 13.8324  | 300800     | 0.0019        | -               |
| 13.8370  | 300900     | 0.002         | -               |
| 13.8416  | 301000     | 0.002         | -               |
| 13.8462  | 301100     | 0.0012        | -               |
| 13.8508  | 301200     | 0.0014        | -               |
| 13.8554  | 301300     | 0.0022        | -               |
| 13.8600  | 301400     | 0.0021        | -               |
| 13.8646  | 301500     | 0.0017        | -               |
| 13.8692  | 301600     | 0.0013        | -               |
| 13.8738  | 301700     | 0.0017        | -               |
| 13.8784  | 301800     | 0.0016        | -               |
| 13.8830  | 301900     | 0.0014        | -               |
| 13.8876  | 302000     | 0.0023        | -               |
| 13.8922  | 302100     | 0.0017        | -               |
| 13.8968  | 302200     | 0.0016        | -               |
| 13.9014  | 302300     | 0.0013        | -               |
| 13.9060  | 302400     | 0.0018        | -               |
| 13.9106  | 302500     | 0.0023        | -               |
| 13.9152  | 302600     | 0.0013        | -               |
| 13.9198  | 302700     | 0.002         | -               |
| 13.9244  | 302800     | 0.0018        | -               |
| 13.9290  | 302900     | 0.0017        | -               |
| 13.9336  | 303000     | 0.0016        | -               |
| 13.9382  | 303100     | 0.0019        | -               |
| 13.9428  | 303200     | 0.0016        | -               |
| 13.9474  | 303300     | 0.0018        | -               |
| 13.9520  | 303400     | 0.0012        | -               |
| 13.9566  | 303500     | 0.0019        | -               |
| 13.9612  | 303600     | 0.0016        | -               |
| 13.9658  | 303700     | 0.0016        | -               |
| 13.9704  | 303800     | 0.0018        | -               |
| 13.9750  | 303900     | 0.0016        | -               |
| 13.9796  | 304000     | 0.002         | -               |
| 13.9842  | 304100     | 0.0023        | -               |
| 13.9888  | 304200     | 0.0016        | -               |
| 13.9934  | 304300     | 0.0017        | -               |
| 13.9980  | 304400     | 0.0018        | -               |
| 14.0     | 304444     | -             | 0.0339          |
| 14.0026  | 304500     | 0.0017        | -               |
| 14.0072  | 304600     | 0.0014        | -               |
| 14.0118  | 304700     | 0.0016        | -               |
| 14.0164  | 304800     | 0.0016        | -               |
| 14.0210  | 304900     | 0.0013        | -               |
| 14.0256  | 305000     | 0.0016        | -               |
| 14.0302  | 305100     | 0.0011        | -               |
| 14.0348  | 305200     | 0.0013        | -               |
| 14.0394  | 305300     | 0.0011        | -               |
| 14.0440  | 305400     | 0.0013        | -               |
| 14.0486  | 305500     | 0.0014        | -               |
| 14.0532  | 305600     | 0.0015        | -               |
| 14.0578  | 305700     | 0.0016        | -               |
| 14.0624  | 305800     | 0.0014        | -               |
| 14.0670  | 305900     | 0.0014        | -               |
| 14.0716  | 306000     | 0.0012        | -               |
| 14.0762  | 306100     | 0.0013        | -               |
| 14.0808  | 306200     | 0.0019        | -               |
| 14.0853  | 306300     | 0.0018        | -               |
| 14.0899  | 306400     | 0.0015        | -               |
| 14.0945  | 306500     | 0.0016        | -               |
| 14.0991  | 306600     | 0.0012        | -               |
| 14.1037  | 306700     | 0.0011        | -               |
| 14.1083  | 306800     | 0.0015        | -               |
| 14.1129  | 306900     | 0.0015        | -               |
| 14.1175  | 307000     | 0.0016        | -               |
| 14.1221  | 307100     | 0.0019        | -               |
| 14.1267  | 307200     | 0.0018        | -               |
| 14.1313  | 307300     | 0.002         | -               |
| 14.1359  | 307400     | 0.0015        | -               |
| 14.1405  | 307500     | 0.0017        | -               |
| 14.1451  | 307600     | 0.0016        | -               |
| 14.1497  | 307700     | 0.0014        | -               |
| 14.1543  | 307800     | 0.0017        | -               |
| 14.1589  | 307900     | 0.0015        | -               |
| 14.1635  | 308000     | 0.0015        | -               |
| 14.1681  | 308100     | 0.0017        | -               |
| 14.1727  | 308200     | 0.0019        | -               |
| 14.1773  | 308300     | 0.0014        | -               |
| 14.1819  | 308400     | 0.0016        | -               |
| 14.1865  | 308500     | 0.0012        | -               |
| 14.1911  | 308600     | 0.0015        | -               |
| 14.1957  | 308700     | 0.0016        | -               |
| 14.2003  | 308800     | 0.0013        | -               |
| 14.2049  | 308900     | 0.0016        | -               |
| 14.2095  | 309000     | 0.0016        | -               |
| 14.2141  | 309100     | 0.0016        | -               |
| 14.2187  | 309200     | 0.0016        | -               |
| 14.2233  | 309300     | 0.0014        | -               |
| 14.2279  | 309400     | 0.0012        | -               |
| 14.2325  | 309500     | 0.0019        | -               |
| 14.2371  | 309600     | 0.0015        | -               |
| 14.2417  | 309700     | 0.0012        | -               |
| 14.2463  | 309800     | 0.0017        | -               |
| 14.2509  | 309900     | 0.0014        | -               |
| 14.2555  | 310000     | 0.0019        | -               |
| 14.2601  | 310100     | 0.0019        | -               |
| 14.2647  | 310200     | 0.002         | -               |
| 14.2693  | 310300     | 0.001         | -               |
| 14.2739  | 310400     | 0.0015        | -               |
| 14.2785  | 310500     | 0.0014        | -               |
| 14.2831  | 310600     | 0.0013        | -               |
| 14.2877  | 310700     | 0.0014        | -               |
| 14.2923  | 310800     | 0.0022        | -               |
| 14.2969  | 310900     | 0.0013        | -               |
| 14.3015  | 311000     | 0.0015        | -               |
| 14.3061  | 311100     | 0.0015        | -               |
| 14.3107  | 311200     | 0.0014        | -               |
| 14.3153  | 311300     | 0.0023        | -               |
| 14.3199  | 311400     | 0.0021        | -               |
| 14.3245  | 311500     | 0.0013        | -               |
| 14.3291  | 311600     | 0.0019        | -               |
| 14.3337  | 311700     | 0.0014        | -               |
| 14.3383  | 311800     | 0.0017        | -               |
| 14.3429  | 311900     | 0.0013        | -               |
| 14.3475  | 312000     | 0.0017        | -               |
| 14.3521  | 312100     | 0.0013        | -               |
| 14.3567  | 312200     | 0.0016        | -               |
| 14.3613  | 312300     | 0.0017        | -               |
| 14.3659  | 312400     | 0.0012        | -               |
| 14.3705  | 312500     | 0.0014        | -               |
| 14.3751  | 312600     | 0.0013        | -               |
| 14.3797  | 312700     | 0.0018        | -               |
| 14.3843  | 312800     | 0.0013        | -               |
| 14.3889  | 312900     | 0.0017        | -               |
| 14.3935  | 313000     | 0.0014        | -               |
| 14.3981  | 313100     | 0.0015        | -               |
| 14.4026  | 313200     | 0.0014        | -               |
| 14.4072  | 313300     | 0.002         | -               |
| 14.4118  | 313400     | 0.0018        | -               |
| 14.4164  | 313500     | 0.0019        | -               |
| 14.4210  | 313600     | 0.0018        | -               |
| 14.4256  | 313700     | 0.0013        | -               |
| 14.4302  | 313800     | 0.0017        | -               |
| 14.4348  | 313900     | 0.0013        | -               |
| 14.4394  | 314000     | 0.0012        | -               |
| 14.4440  | 314100     | 0.0011        | -               |
| 14.4486  | 314200     | 0.0011        | -               |
| 14.4532  | 314300     | 0.0016        | -               |
| 14.4578  | 314400     | 0.0016        | -               |
| 14.4624  | 314500     | 0.0019        | -               |
| 14.4670  | 314600     | 0.0016        | -               |
| 14.4716  | 314700     | 0.0015        | -               |
| 14.4762  | 314800     | 0.0019        | -               |
| 14.4808  | 314900     | 0.0014        | -               |
| 14.4854  | 315000     | 0.0018        | -               |
| 14.4900  | 315100     | 0.0018        | -               |
| 14.4946  | 315200     | 0.0016        | -               |
| 14.4992  | 315300     | 0.0018        | -               |
| 14.5038  | 315400     | 0.001         | -               |
| 14.5084  | 315500     | 0.0021        | -               |
| 14.5130  | 315600     | 0.0015        | -               |
| 14.5176  | 315700     | 0.0017        | -               |
| 14.5222  | 315800     | 0.0012        | -               |
| 14.5268  | 315900     | 0.0015        | -               |
| 14.5314  | 316000     | 0.0016        | -               |
| 14.5360  | 316100     | 0.002         | -               |
| 14.5406  | 316200     | 0.0015        | -               |
| 14.5452  | 316300     | 0.0014        | -               |
| 14.5498  | 316400     | 0.0017        | -               |
| 14.5544  | 316500     | 0.0018        | -               |
| 14.5590  | 316600     | 0.0016        | -               |
| 14.5636  | 316700     | 0.0011        | -               |
| 14.5682  | 316800     | 0.0016        | -               |
| 14.5728  | 316900     | 0.0013        | -               |
| 14.5774  | 317000     | 0.0014        | -               |
| 14.5820  | 317100     | 0.0019        | -               |
| 14.5866  | 317200     | 0.0019        | -               |
| 14.5912  | 317300     | 0.0016        | -               |
| 14.5958  | 317400     | 0.0015        | -               |
| 14.6004  | 317500     | 0.0017        | -               |
| 14.6050  | 317600     | 0.0015        | -               |
| 14.6096  | 317700     | 0.0018        | -               |
| 14.6142  | 317800     | 0.0014        | -               |
| 14.6188  | 317900     | 0.0013        | -               |
| 14.6234  | 318000     | 0.0017        | -               |
| 14.6280  | 318100     | 0.0014        | -               |
| 14.6326  | 318200     | 0.0017        | -               |
| 14.6372  | 318300     | 0.0021        | -               |
| 14.6418  | 318400     | 0.0014        | -               |
| 14.6464  | 318500     | 0.0012        | -               |
| 14.6510  | 318600     | 0.0014        | -               |
| 14.6556  | 318700     | 0.0012        | -               |
| 14.6602  | 318800     | 0.0015        | -               |
| 14.6648  | 318900     | 0.0013        | -               |
| 14.6694  | 319000     | 0.0018        | -               |
| 14.6740  | 319100     | 0.0013        | -               |
| 14.6786  | 319200     | 0.0015        | -               |
| 14.6832  | 319300     | 0.0014        | -               |
| 14.6878  | 319400     | 0.0018        | -               |
| 14.6924  | 319500     | 0.0022        | -               |
| 14.6970  | 319600     | 0.0009        | -               |
| 14.7016  | 319700     | 0.0021        | -               |
| 14.7062  | 319800     | 0.0015        | -               |
| 14.7108  | 319900     | 0.0014        | -               |
| 14.7153  | 320000     | 0.0016        | -               |
| 14.7199  | 320100     | 0.0013        | -               |
| 14.7245  | 320200     | 0.0012        | -               |
| 14.7291  | 320300     | 0.0017        | -               |
| 14.7337  | 320400     | 0.0015        | -               |
| 14.7383  | 320500     | 0.0014        | -               |
| 14.7429  | 320600     | 0.0016        | -               |
| 14.7475  | 320700     | 0.0011        | -               |
| 14.7521  | 320800     | 0.0012        | -               |
| 14.7567  | 320900     | 0.0015        | -               |
| 14.7613  | 321000     | 0.0014        | -               |
| 14.7659  | 321100     | 0.0016        | -               |
| 14.7705  | 321200     | 0.0014        | -               |
| 14.7751  | 321300     | 0.0015        | -               |
| 14.7797  | 321400     | 0.0022        | -               |
| 14.7843  | 321500     | 0.0013        | -               |
| 14.7889  | 321600     | 0.0022        | -               |
| 14.7935  | 321700     | 0.0012        | -               |
| 14.7981  | 321800     | 0.0008        | -               |
| 14.8027  | 321900     | 0.0013        | -               |
| 14.8073  | 322000     | 0.0015        | -               |
| 14.8119  | 322100     | 0.0017        | -               |
| 14.8165  | 322200     | 0.0017        | -               |
| 14.8211  | 322300     | 0.0012        | -               |
| 14.8257  | 322400     | 0.0012        | -               |
| 14.8303  | 322500     | 0.0015        | -               |
| 14.8349  | 322600     | 0.0015        | -               |
| 14.8395  | 322700     | 0.0018        | -               |
| 14.8441  | 322800     | 0.002         | -               |
| 14.8487  | 322900     | 0.0015        | -               |
| 14.8533  | 323000     | 0.0016        | -               |
| 14.8579  | 323100     | 0.0011        | -               |
| 14.8625  | 323200     | 0.0012        | -               |
| 14.8671  | 323300     | 0.0014        | -               |
| 14.8717  | 323400     | 0.0017        | -               |
| 14.8763  | 323500     | 0.0016        | -               |
| 14.8809  | 323600     | 0.0018        | -               |
| 14.8855  | 323700     | 0.0023        | -               |
| 14.8901  | 323800     | 0.0011        | -               |
| 14.8947  | 323900     | 0.0014        | -               |
| 14.8993  | 324000     | 0.0013        | -               |
| 14.9039  | 324100     | 0.002         | -               |
| 14.9085  | 324200     | 0.0016        | -               |
| 14.9131  | 324300     | 0.0013        | -               |
| 14.9177  | 324400     | 0.0021        | -               |
| 14.9223  | 324500     | 0.0011        | -               |
| 14.9269  | 324600     | 0.0011        | -               |
| 14.9315  | 324700     | 0.0017        | -               |
| 14.9361  | 324800     | 0.002         | -               |
| 14.9407  | 324900     | 0.0015        | -               |
| 14.9453  | 325000     | 0.0017        | -               |
| 14.9499  | 325100     | 0.0014        | -               |
| 14.9545  | 325200     | 0.002         | -               |
| 14.9591  | 325300     | 0.0015        | -               |
| 14.9637  | 325400     | 0.002         | -               |
| 14.9683  | 325500     | 0.0012        | -               |
| 14.9729  | 325600     | 0.0013        | -               |
| 14.9775  | 325700     | 0.0016        | -               |
| 14.9821  | 325800     | 0.0018        | -               |
| 14.9867  | 325900     | 0.0016        | -               |
| 14.9913  | 326000     | 0.0014        | -               |
| 14.9959  | 326100     | 0.0016        | -               |
| 15.0     | 326190     | -             | 0.0327          |
| 15.0005  | 326200     | 0.0011        | -               |
| 15.0051  | 326300     | 0.0015        | -               |
| 15.0097  | 326400     | 0.0013        | -               |
| 15.0143  | 326500     | 0.002         | -               |
| 15.0189  | 326600     | 0.0015        | -               |
| 15.0235  | 326700     | 0.0017        | -               |
| 15.0281  | 326800     | 0.0015        | -               |
| 15.0326  | 326900     | 0.0009        | -               |
| 15.0372  | 327000     | 0.0011        | -               |
| 15.0418  | 327100     | 0.0014        | -               |
| 15.0464  | 327200     | 0.0011        | -               |
| 15.0510  | 327300     | 0.0014        | -               |
| 15.0556  | 327400     | 0.0012        | -               |
| 15.0602  | 327500     | 0.0009        | -               |
| 15.0648  | 327600     | 0.0013        | -               |
| 15.0694  | 327700     | 0.0014        | -               |
| 15.0740  | 327800     | 0.0014        | -               |
| 15.0786  | 327900     | 0.0009        | -               |
| 15.0832  | 328000     | 0.0013        | -               |
| 15.0878  | 328100     | 0.0014        | -               |
| 15.0924  | 328200     | 0.0016        | -               |
| 15.0970  | 328300     | 0.0013        | -               |
| 15.1016  | 328400     | 0.0012        | -               |
| 15.1062  | 328500     | 0.0013        | -               |
| 15.1108  | 328600     | 0.0011        | -               |
| 15.1154  | 328700     | 0.0014        | -               |
| 15.1200  | 328800     | 0.0019        | -               |
| 15.1246  | 328900     | 0.0016        | -               |
| 15.1292  | 329000     | 0.0012        | -               |
| 15.1338  | 329100     | 0.0019        | -               |
| 15.1384  | 329200     | 0.001         | -               |
| 15.1430  | 329300     | 0.0013        | -               |
| 15.1476  | 329400     | 0.002         | -               |
| 15.1522  | 329500     | 0.0016        | -               |
| 15.1568  | 329600     | 0.0012        | -               |
| 15.1614  | 329700     | 0.0014        | -               |
| 15.1660  | 329800     | 0.0012        | -               |
| 15.1706  | 329900     | 0.0021        | -               |
| 15.1752  | 330000     | 0.0011        | -               |
| 15.1798  | 330100     | 0.0013        | -               |
| 15.1844  | 330200     | 0.0013        | -               |
| 15.1890  | 330300     | 0.0013        | -               |
| 15.1936  | 330400     | 0.0013        | -               |
| 15.1982  | 330500     | 0.0012        | -               |
| 15.2028  | 330600     | 0.0012        | -               |
| 15.2074  | 330700     | 0.0018        | -               |
| 15.2120  | 330800     | 0.0016        | -               |
| 15.2166  | 330900     | 0.0009        | -               |
| 15.2212  | 331000     | 0.0018        | -               |
| 15.2258  | 331100     | 0.0015        | -               |
| 15.2304  | 331200     | 0.0009        | -               |
| 15.2350  | 331300     | 0.0017        | -               |
| 15.2396  | 331400     | 0.0018        | -               |
| 15.2442  | 331500     | 0.0012        | -               |
| 15.2488  | 331600     | 0.001         | -               |
| 15.2534  | 331700     | 0.0016        | -               |
| 15.2580  | 331800     | 0.0019        | -               |
| 15.2626  | 331900     | 0.0016        | -               |
| 15.2672  | 332000     | 0.0013        | -               |
| 15.2718  | 332100     | 0.0013        | -               |
| 15.2764  | 332200     | 0.0015        | -               |
| 15.2810  | 332300     | 0.0013        | -               |
| 15.2856  | 332400     | 0.002         | -               |
| 15.2902  | 332500     | 0.0009        | -               |
| 15.2948  | 332600     | 0.0011        | -               |
| 15.2994  | 332700     | 0.0013        | -               |
| 15.3040  | 332800     | 0.0014        | -               |
| 15.3086  | 332900     | 0.0013        | -               |
| 15.3132  | 333000     | 0.0019        | -               |
| 15.3178  | 333100     | 0.0012        | -               |
| 15.3224  | 333200     | 0.0014        | -               |
| 15.3270  | 333300     | 0.0013        | -               |
| 15.3316  | 333400     | 0.0015        | -               |
| 15.3362  | 333500     | 0.0014        | -               |
| 15.3408  | 333600     | 0.001         | -               |
| 15.3454  | 333700     | 0.0013        | -               |
| 15.3499  | 333800     | 0.0016        | -               |
| 15.3545  | 333900     | 0.0015        | -               |
| 15.3591  | 334000     | 0.0009        | -               |
| 15.3637  | 334100     | 0.0018        | -               |
| 15.3683  | 334200     | 0.0014        | -               |
| 15.3729  | 334300     | 0.0017        | -               |
| 15.3775  | 334400     | 0.0018        | -               |
| 15.3821  | 334500     | 0.0015        | -               |
| 15.3867  | 334600     | 0.0012        | -               |
| 15.3913  | 334700     | 0.0013        | -               |
| 15.3959  | 334800     | 0.001         | -               |
| 15.4005  | 334900     | 0.0013        | -               |
| 15.4051  | 335000     | 0.0011        | -               |
| 15.4097  | 335100     | 0.0011        | -               |
| 15.4143  | 335200     | 0.0015        | -               |
| 15.4189  | 335300     | 0.0018        | -               |
| 15.4235  | 335400     | 0.0011        | -               |
| 15.4281  | 335500     | 0.0018        | -               |
| 15.4327  | 335600     | 0.0013        | -               |
| 15.4373  | 335700     | 0.0014        | -               |
| 15.4419  | 335800     | 0.0011        | -               |
| 15.4465  | 335900     | 0.0016        | -               |
| 15.4511  | 336000     | 0.0015        | -               |
| 15.4557  | 336100     | 0.0012        | -               |
| 15.4603  | 336200     | 0.0014        | -               |
| 15.4649  | 336300     | 0.0011        | -               |
| 15.4695  | 336400     | 0.0011        | -               |
| 15.4741  | 336500     | 0.0014        | -               |
| 15.4787  | 336600     | 0.0013        | -               |
| 15.4833  | 336700     | 0.0012        | -               |
| 15.4879  | 336800     | 0.0011        | -               |
| 15.4925  | 336900     | 0.0012        | -               |
| 15.4971  | 337000     | 0.0017        | -               |
| 15.5017  | 337100     | 0.002         | -               |
| 15.5063  | 337200     | 0.0013        | -               |
| 15.5109  | 337300     | 0.0014        | -               |
| 15.5155  | 337400     | 0.0009        | -               |
| 15.5201  | 337500     | 0.0016        | -               |
| 15.5247  | 337600     | 0.001         | -               |
| 15.5293  | 337700     | 0.0014        | -               |
| 15.5339  | 337800     | 0.001         | -               |
| 15.5385  | 337900     | 0.0013        | -               |
| 15.5431  | 338000     | 0.0014        | -               |
| 15.5477  | 338100     | 0.0016        | -               |
| 15.5523  | 338200     | 0.0014        | -               |
| 15.5569  | 338300     | 0.001         | -               |
| 15.5615  | 338400     | 0.0014        | -               |
| 15.5661  | 338500     | 0.0011        | -               |
| 15.5707  | 338600     | 0.0019        | -               |
| 15.5753  | 338700     | 0.0012        | -               |
| 15.5799  | 338800     | 0.0012        | -               |
| 15.5845  | 338900     | 0.0014        | -               |
| 15.5891  | 339000     | 0.0011        | -               |
| 15.5937  | 339100     | 0.0014        | -               |
| 15.5983  | 339200     | 0.0012        | -               |
| 15.6029  | 339300     | 0.0015        | -               |
| 15.6075  | 339400     | 0.0013        | -               |
| 15.6121  | 339500     | 0.0012        | -               |
| 15.6167  | 339600     | 0.0013        | -               |
| 15.6213  | 339700     | 0.0015        | -               |
| 15.6259  | 339800     | 0.0013        | -               |
| 15.6305  | 339900     | 0.0012        | -               |
| 15.6351  | 340000     | 0.0012        | -               |
| 15.6397  | 340100     | 0.0014        | -               |
| 15.6443  | 340200     | 0.0013        | -               |
| 15.6489  | 340300     | 0.0015        | -               |
| 15.6535  | 340400     | 0.0014        | -               |
| 15.6581  | 340500     | 0.0013        | -               |
| 15.6627  | 340600     | 0.0015        | -               |
| 15.6672  | 340700     | 0.0015        | -               |
| 15.6718  | 340800     | 0.0014        | -               |
| 15.6764  | 340900     | 0.0014        | -               |
| 15.6810  | 341000     | 0.0014        | -               |
| 15.6856  | 341100     | 0.0017        | -               |
| 15.6902  | 341200     | 0.0016        | -               |
| 15.6948  | 341300     | 0.0013        | -               |
| 15.6994  | 341400     | 0.0016        | -               |
| 15.7040  | 341500     | 0.0012        | -               |
| 15.7086  | 341600     | 0.0014        | -               |
| 15.7132  | 341700     | 0.0016        | -               |
| 15.7178  | 341800     | 0.0011        | -               |
| 15.7224  | 341900     | 0.0017        | -               |
| 15.7270  | 342000     | 0.0011        | -               |
| 15.7316  | 342100     | 0.0013        | -               |
| 15.7362  | 342200     | 0.0012        | -               |
| 15.7408  | 342300     | 0.0016        | -               |
| 15.7454  | 342400     | 0.0011        | -               |
| 15.7500  | 342500     | 0.0013        | -               |
| 15.7546  | 342600     | 0.0013        | -               |
| 15.7592  | 342700     | 0.0014        | -               |
| 15.7638  | 342800     | 0.0018        | -               |
| 15.7684  | 342900     | 0.0016        | -               |
| 15.7730  | 343000     | 0.0019        | -               |
| 15.7776  | 343100     | 0.0014        | -               |
| 15.7822  | 343200     | 0.0014        | -               |
| 15.7868  | 343300     | 0.001         | -               |
| 15.7914  | 343400     | 0.0013        | -               |
| 15.7960  | 343500     | 0.0015        | -               |
| 15.8006  | 343600     | 0.0012        | -               |
| 15.8052  | 343700     | 0.001         | -               |
| 15.8098  | 343800     | 0.0014        | -               |
| 15.8144  | 343900     | 0.0011        | -               |
| 15.8190  | 344000     | 0.0013        | -               |
| 15.8236  | 344100     | 0.0013        | -               |
| 15.8282  | 344200     | 0.0015        | -               |
| 15.8328  | 344300     | 0.0018        | -               |
| 15.8374  | 344400     | 0.0016        | -               |
| 15.8420  | 344500     | 0.0012        | -               |
| 15.8466  | 344600     | 0.0014        | -               |
| 15.8512  | 344700     | 0.0012        | -               |
| 15.8558  | 344800     | 0.0017        | -               |
| 15.8604  | 344900     | 0.0015        | -               |
| 15.8650  | 345000     | 0.0012        | -               |
| 15.8696  | 345100     | 0.001         | -               |
| 15.8742  | 345200     | 0.0016        | -               |
| 15.8788  | 345300     | 0.0016        | -               |
| 15.8834  | 345400     | 0.0012        | -               |
| 15.8880  | 345500     | 0.0015        | -               |
| 15.8926  | 345600     | 0.0014        | -               |
| 15.8972  | 345700     | 0.0008        | -               |
| 15.9018  | 345800     | 0.0013        | -               |
| 15.9064  | 345900     | 0.0011        | -               |
| 15.9110  | 346000     | 0.0012        | -               |
| 15.9156  | 346100     | 0.0015        | -               |
| 15.9202  | 346200     | 0.0013        | -               |
| 15.9248  | 346300     | 0.0012        | -               |
| 15.9294  | 346400     | 0.0017        | -               |
| 15.9340  | 346500     | 0.0012        | -               |
| 15.9386  | 346600     | 0.0011        | -               |
| 15.9432  | 346700     | 0.0012        | -               |
| 15.9478  | 346800     | 0.0014        | -               |
| 15.9524  | 346900     | 0.0013        | -               |
| 15.9570  | 347000     | 0.001         | -               |
| 15.9616  | 347100     | 0.0011        | -               |
| 15.9662  | 347200     | 0.0012        | -               |
| 15.9708  | 347300     | 0.0016        | -               |
| 15.9754  | 347400     | 0.001         | -               |
| 15.9800  | 347500     | 0.0009        | -               |
| 15.9845  | 347600     | 0.0012        | -               |
| 15.9891  | 347700     | 0.0012        | -               |
| 15.9937  | 347800     | 0.0012        | -               |
| 15.9983  | 347900     | 0.0014        | -               |
| 16.0     | 347936     | -             | 0.0341          |
| 16.0029  | 348000     | 0.0013        | -               |
| 16.0075  | 348100     | 0.0011        | -               |
| 16.0121  | 348200     | 0.0012        | -               |
| 16.0167  | 348300     | 0.0009        | -               |
| 16.0213  | 348400     | 0.0012        | -               |
| 16.0259  | 348500     | 0.0015        | -               |
| 16.0305  | 348600     | 0.0014        | -               |
| 16.0351  | 348700     | 0.0008        | -               |
| 16.0397  | 348800     | 0.0011        | -               |
| 16.0443  | 348900     | 0.001         | -               |
| 16.0489  | 349000     | 0.0011        | -               |
| 16.0535  | 349100     | 0.0012        | -               |
| 16.0581  | 349200     | 0.0011        | -               |
| 16.0627  | 349300     | 0.0012        | -               |
| 16.0673  | 349400     | 0.0012        | -               |
| 16.0719  | 349500     | 0.0008        | -               |
| 16.0765  | 349600     | 0.001         | -               |
| 16.0811  | 349700     | 0.0013        | -               |
| 16.0857  | 349800     | 0.0016        | -               |
| 16.0903  | 349900     | 0.0013        | -               |
| 16.0949  | 350000     | 0.001         | -               |
| 16.0995  | 350100     | 0.0016        | -               |
| 16.1041  | 350200     | 0.0013        | -               |
| 16.1087  | 350300     | 0.0014        | -               |
| 16.1133  | 350400     | 0.0013        | -               |
| 16.1179  | 350500     | 0.0014        | -               |
| 16.1225  | 350600     | 0.0017        | -               |
| 16.1271  | 350700     | 0.0008        | -               |
| 16.1317  | 350800     | 0.0008        | -               |
| 16.1363  | 350900     | 0.0013        | -               |
| 16.1409  | 351000     | 0.0015        | -               |
| 16.1455  | 351100     | 0.0013        | -               |
| 16.1501  | 351200     | 0.0013        | -               |
| 16.1547  | 351300     | 0.0012        | -               |
| 16.1593  | 351400     | 0.0011        | -               |
| 16.1639  | 351500     | 0.0016        | -               |
| 16.1685  | 351600     | 0.0011        | -               |
| 16.1731  | 351700     | 0.0017        | -               |
| 16.1777  | 351800     | 0.0018        | -               |
| 16.1823  | 351900     | 0.0013        | -               |
| 16.1869  | 352000     | 0.0012        | -               |
| 16.1915  | 352100     | 0.0014        | -               |
| 16.1961  | 352200     | 0.0015        | -               |
| 16.2007  | 352300     | 0.0013        | -               |
| 16.2053  | 352400     | 0.0017        | -               |
| 16.2099  | 352500     | 0.0013        | -               |
| 16.2145  | 352600     | 0.0011        | -               |
| 16.2191  | 352700     | 0.0009        | -               |
| 16.2237  | 352800     | 0.0016        | -               |
| 16.2283  | 352900     | 0.0013        | -               |
| 16.2329  | 353000     | 0.0013        | -               |
| 16.2375  | 353100     | 0.0012        | -               |
| 16.2421  | 353200     | 0.0014        | -               |
| 16.2467  | 353300     | 0.0012        | -               |
| 16.2513  | 353400     | 0.0015        | -               |
| 16.2559  | 353500     | 0.0008        | -               |
| 16.2605  | 353600     | 0.0012        | -               |
| 16.2651  | 353700     | 0.0013        | -               |
| 16.2697  | 353800     | 0.001         | -               |
| 16.2743  | 353900     | 0.0011        | -               |
| 16.2789  | 354000     | 0.0011        | -               |
| 16.2835  | 354100     | 0.0009        | -               |
| 16.2881  | 354200     | 0.0015        | -               |
| 16.2927  | 354300     | 0.0009        | -               |
| 16.2973  | 354400     | 0.0013        | -               |
| 16.3018  | 354500     | 0.0013        | -               |
| 16.3064  | 354600     | 0.0011        | -               |
| 16.3110  | 354700     | 0.001         | -               |
| 16.3156  | 354800     | 0.0009        | -               |
| 16.3202  | 354900     | 0.0008        | -               |
| 16.3248  | 355000     | 0.0011        | -               |
| 16.3294  | 355100     | 0.0015        | -               |
| 16.3340  | 355200     | 0.0015        | -               |
| 16.3386  | 355300     | 0.0012        | -               |
| 16.3432  | 355400     | 0.0012        | -               |
| 16.3478  | 355500     | 0.0008        | -               |
| 16.3524  | 355600     | 0.0009        | -               |
| 16.3570  | 355700     | 0.0013        | -               |
| 16.3616  | 355800     | 0.0012        | -               |
| 16.3662  | 355900     | 0.0012        | -               |
| 16.3708  | 356000     | 0.0012        | -               |
| 16.3754  | 356100     | 0.0013        | -               |
| 16.3800  | 356200     | 0.0012        | -               |
| 16.3846  | 356300     | 0.0013        | -               |
| 16.3892  | 356400     | 0.0011        | -               |
| 16.3938  | 356500     | 0.0012        | -               |
| 16.3984  | 356600     | 0.0009        | -               |
| 16.4030  | 356700     | 0.001         | -               |
| 16.4076  | 356800     | 0.001         | -               |
| 16.4122  | 356900     | 0.001         | -               |
| 16.4168  | 357000     | 0.0015        | -               |
| 16.4214  | 357100     | 0.0012        | -               |
| 16.4260  | 357200     | 0.0014        | -               |
| 16.4306  | 357300     | 0.0015        | -               |
| 16.4352  | 357400     | 0.0012        | -               |
| 16.4398  | 357500     | 0.0011        | -               |
| 16.4444  | 357600     | 0.0012        | -               |
| 16.4490  | 357700     | 0.0012        | -               |
| 16.4536  | 357800     | 0.0013        | -               |
| 16.4582  | 357900     | 0.0014        | -               |
| 16.4628  | 358000     | 0.0009        | -               |
| 16.4674  | 358100     | 0.0012        | -               |
| 16.4720  | 358200     | 0.0013        | -               |
| 16.4766  | 358300     | 0.0008        | -               |
| 16.4812  | 358400     | 0.0012        | -               |
| 16.4858  | 358500     | 0.0009        | -               |
| 16.4904  | 358600     | 0.0013        | -               |
| 16.4950  | 358700     | 0.0016        | -               |
| 16.4996  | 358800     | 0.0013        | -               |
| 16.5042  | 358900     | 0.0013        | -               |
| 16.5088  | 359000     | 0.0013        | -               |
| 16.5134  | 359100     | 0.0012        | -               |
| 16.5180  | 359200     | 0.0012        | -               |
| 16.5226  | 359300     | 0.001         | -               |
| 16.5272  | 359400     | 0.001         | -               |
| 16.5318  | 359500     | 0.0011        | -               |
| 16.5364  | 359600     | 0.0011        | -               |
| 16.5410  | 359700     | 0.0017        | -               |
| 16.5456  | 359800     | 0.0012        | -               |
| 16.5502  | 359900     | 0.0013        | -               |
| 16.5548  | 360000     | 0.0016        | -               |
| 16.5594  | 360100     | 0.0011        | -               |
| 16.5640  | 360200     | 0.0013        | -               |
| 16.5686  | 360300     | 0.0011        | -               |
| 16.5732  | 360400     | 0.0013        | -               |
| 16.5778  | 360500     | 0.0018        | -               |
| 16.5824  | 360600     | 0.0017        | -               |
| 16.5870  | 360700     | 0.0015        | -               |
| 16.5916  | 360800     | 0.0016        | -               |
| 16.5962  | 360900     | 0.0011        | -               |
| 16.6008  | 361000     | 0.0011        | -               |
| 16.6054  | 361100     | 0.0012        | -               |
| 16.6100  | 361200     | 0.0015        | -               |
| 16.6145  | 361300     | 0.0015        | -               |
| 16.6191  | 361400     | 0.0011        | -               |
| 16.6237  | 361500     | 0.0012        | -               |
| 16.6283  | 361600     | 0.001         | -               |
| 16.6329  | 361700     | 0.0011        | -               |
| 16.6375  | 361800     | 0.0014        | -               |
| 16.6421  | 361900     | 0.0012        | -               |
| 16.6467  | 362000     | 0.001         | -               |
| 16.6513  | 362100     | 0.0008        | -               |
| 16.6559  | 362200     | 0.0008        | -               |
| 16.6605  | 362300     | 0.0009        | -               |
| 16.6651  | 362400     | 0.0019        | -               |
| 16.6697  | 362500     | 0.0011        | -               |
| 16.6743  | 362600     | 0.0011        | -               |
| 16.6789  | 362700     | 0.0019        | -               |
| 16.6835  | 362800     | 0.001         | -               |
| 16.6881  | 362900     | 0.0014        | -               |
| 16.6927  | 363000     | 0.001         | -               |
| 16.6973  | 363100     | 0.0009        | -               |
| 16.7019  | 363200     | 0.0011        | -               |
| 16.7065  | 363300     | 0.001         | -               |
| 16.7111  | 363400     | 0.0013        | -               |
| 16.7157  | 363500     | 0.0018        | -               |
| 16.7203  | 363600     | 0.001         | -               |
| 16.7249  | 363700     | 0.0014        | -               |
| 16.7295  | 363800     | 0.0013        | -               |
| 16.7341  | 363900     | 0.001         | -               |
| 16.7387  | 364000     | 0.001         | -               |
| 16.7433  | 364100     | 0.0012        | -               |
| 16.7479  | 364200     | 0.0011        | -               |
| 16.7525  | 364300     | 0.0011        | -               |
| 16.7571  | 364400     | 0.0009        | -               |
| 16.7617  | 364500     | 0.001         | -               |
| 16.7663  | 364600     | 0.0009        | -               |
| 16.7709  | 364700     | 0.001         | -               |
| 16.7755  | 364800     | 0.0008        | -               |
| 16.7801  | 364900     | 0.0014        | -               |
| 16.7847  | 365000     | 0.0017        | -               |
| 16.7893  | 365100     | 0.0013        | -               |
| 16.7939  | 365200     | 0.0014        | -               |
| 16.7985  | 365300     | 0.0012        | -               |
| 16.8031  | 365400     | 0.0009        | -               |
| 16.8077  | 365500     | 0.0011        | -               |
| 16.8123  | 365600     | 0.001         | -               |
| 16.8169  | 365700     | 0.0012        | -               |
| 16.8215  | 365800     | 0.0012        | -               |
| 16.8261  | 365900     | 0.0011        | -               |
| 16.8307  | 366000     | 0.0012        | -               |
| 16.8353  | 366100     | 0.0009        | -               |
| 16.8399  | 366200     | 0.0014        | -               |
| 16.8445  | 366300     | 0.0013        | -               |
| 16.8491  | 366400     | 0.0012        | -               |
| 16.8537  | 366500     | 0.0012        | -               |
| 16.8583  | 366600     | 0.001         | -               |
| 16.8629  | 366700     | 0.0012        | -               |
| 16.8675  | 366800     | 0.0008        | -               |
| 16.8721  | 366900     | 0.0011        | -               |
| 16.8767  | 367000     | 0.0012        | -               |
| 16.8813  | 367100     | 0.0011        | -               |
| 16.8859  | 367200     | 0.0011        | -               |
| 16.8905  | 367300     | 0.0012        | -               |
| 16.8951  | 367400     | 0.0012        | -               |
| 16.8997  | 367500     | 0.001         | -               |
| 16.9043  | 367600     | 0.001         | -               |
| 16.9089  | 367700     | 0.0018        | -               |
| 16.9135  | 367800     | 0.001         | -               |
| 16.9181  | 367900     | 0.0013        | -               |
| 16.9227  | 368000     | 0.0013        | -               |
| 16.9273  | 368100     | 0.0011        | -               |
| 16.9318  | 368200     | 0.001         | -               |
| 16.9364  | 368300     | 0.0013        | -               |
| 16.9410  | 368400     | 0.0012        | -               |
| 16.9456  | 368500     | 0.0012        | -               |
| 16.9502  | 368600     | 0.0012        | -               |
| 16.9548  | 368700     | 0.0012        | -               |
| 16.9594  | 368800     | 0.0013        | -               |
| 16.9640  | 368900     | 0.001         | -               |
| 16.9686  | 369000     | 0.0013        | -               |
| 16.9732  | 369100     | 0.0011        | -               |
| 16.9778  | 369200     | 0.001         | -               |
| 16.9824  | 369300     | 0.0016        | -               |
| 16.9870  | 369400     | 0.0013        | -               |
| 16.9916  | 369500     | 0.0013        | -               |
| 16.9962  | 369600     | 0.0015        | -               |
| 17.0     | 369682     | -             | 0.0325          |
| 17.0008  | 369700     | 0.0016        | -               |
| 17.0054  | 369800     | 0.0012        | -               |
| 17.0100  | 369900     | 0.0012        | -               |
| 17.0146  | 370000     | 0.0016        | -               |
| 17.0192  | 370100     | 0.0008        | -               |
| 17.0238  | 370200     | 0.0009        | -               |
| 17.0284  | 370300     | 0.0012        | -               |
| 17.0330  | 370400     | 0.001         | -               |
| 17.0376  | 370500     | 0.0012        | -               |
| 17.0422  | 370600     | 0.0014        | -               |
| 17.0468  | 370700     | 0.0015        | -               |
| 17.0514  | 370800     | 0.0013        | -               |
| 17.0560  | 370900     | 0.0012        | -               |
| 17.0606  | 371000     | 0.0011        | -               |
| 17.0652  | 371100     | 0.0011        | -               |
| 17.0698  | 371200     | 0.001         | -               |
| 17.0744  | 371300     | 0.0009        | -               |
| 17.0790  | 371400     | 0.0008        | -               |
| 17.0836  | 371500     | 0.0008        | -               |
| 17.0882  | 371600     | 0.001         | -               |
| 17.0928  | 371700     | 0.0009        | -               |
| 17.0974  | 371800     | 0.001         | -               |
| 17.1020  | 371900     | 0.0011        | -               |
| 17.1066  | 372000     | 0.0008        | -               |
| 17.1112  | 372100     | 0.0013        | -               |
| 17.1158  | 372200     | 0.0011        | -               |
| 17.1204  | 372300     | 0.0012        | -               |
| 17.1250  | 372400     | 0.001         | -               |
| 17.1296  | 372500     | 0.0015        | -               |
| 17.1342  | 372600     | 0.0011        | -               |
| 17.1388  | 372700     | 0.0012        | -               |
| 17.1434  | 372800     | 0.0014        | -               |
| 17.1480  | 372900     | 0.001         | -               |
| 17.1526  | 373000     | 0.0011        | -               |
| 17.1572  | 373100     | 0.001         | -               |
| 17.1618  | 373200     | 0.0012        | -               |
| 17.1664  | 373300     | 0.0011        | -               |
| 17.1710  | 373400     | 0.0013        | -               |
| 17.1756  | 373500     | 0.0009        | -               |
| 17.1802  | 373600     | 0.0013        | -               |
| 17.1848  | 373700     | 0.0014        | -               |
| 17.1894  | 373800     | 0.001         | -               |
| 17.1940  | 373900     | 0.0011        | -               |
| 17.1986  | 374000     | 0.0011        | -               |
| 17.2032  | 374100     | 0.0012        | -               |
| 17.2078  | 374200     | 0.0008        | -               |
| 17.2124  | 374300     | 0.001         | -               |
| 17.2170  | 374400     | 0.0011        | -               |
| 17.2216  | 374500     | 0.0012        | -               |
| 17.2262  | 374600     | 0.0011        | -               |
| 17.2308  | 374700     | 0.0012        | -               |
| 17.2354  | 374800     | 0.001         | -               |
| 17.2400  | 374900     | 0.0012        | -               |
| 17.2446  | 375000     | 0.0008        | -               |
| 17.2491  | 375100     | 0.001         | -               |
| 17.2537  | 375200     | 0.0012        | -               |
| 17.2583  | 375300     | 0.0007        | -               |
| 17.2629  | 375400     | 0.0013        | -               |
| 17.2675  | 375500     | 0.0008        | -               |
| 17.2721  | 375600     | 0.0021        | -               |
| 17.2767  | 375700     | 0.0007        | -               |
| 17.2813  | 375800     | 0.0013        | -               |
| 17.2859  | 375900     | 0.0014        | -               |
| 17.2905  | 376000     | 0.0013        | -               |
| 17.2951  | 376100     | 0.0011        | -               |
| 17.2997  | 376200     | 0.0017        | -               |
| 17.3043  | 376300     | 0.0012        | -               |
| 17.3089  | 376400     | 0.0009        | -               |
| 17.3135  | 376500     | 0.0012        | -               |
| 17.3181  | 376600     | 0.0011        | -               |
| 17.3227  | 376700     | 0.0012        | -               |
| 17.3273  | 376800     | 0.0008        | -               |
| 17.3319  | 376900     | 0.001         | -               |
| 17.3365  | 377000     | 0.0011        | -               |
| 17.3411  | 377100     | 0.001         | -               |
| 17.3457  | 377200     | 0.0009        | -               |
| 17.3503  | 377300     | 0.001         | -               |
| 17.3549  | 377400     | 0.0013        | -               |
| 17.3595  | 377500     | 0.0014        | -               |
| 17.3641  | 377600     | 0.0011        | -               |
| 17.3687  | 377700     | 0.0009        | -               |
| 17.3733  | 377800     | 0.0008        | -               |
| 17.3779  | 377900     | 0.0013        | -               |
| 17.3825  | 378000     | 0.0011        | -               |
| 17.3871  | 378100     | 0.0014        | -               |
| 17.3917  | 378200     | 0.001         | -               |
| 17.3963  | 378300     | 0.0012        | -               |
| 17.4009  | 378400     | 0.001         | -               |
| 17.4055  | 378500     | 0.0014        | -               |
| 17.4101  | 378600     | 0.001         | -               |
| 17.4147  | 378700     | 0.001         | -               |
| 17.4193  | 378800     | 0.001         | -               |
| 17.4239  | 378900     | 0.0012        | -               |
| 17.4285  | 379000     | 0.0014        | -               |
| 17.4331  | 379100     | 0.0013        | -               |
| 17.4377  | 379200     | 0.0008        | -               |
| 17.4423  | 379300     | 0.0012        | -               |
| 17.4469  | 379400     | 0.0013        | -               |
| 17.4515  | 379500     | 0.0013        | -               |
| 17.4561  | 379600     | 0.0012        | -               |
| 17.4607  | 379700     | 0.001         | -               |
| 17.4653  | 379800     | 0.0008        | -               |
| 17.4699  | 379900     | 0.0011        | -               |
| 17.4745  | 380000     | 0.0013        | -               |
| 17.4791  | 380100     | 0.0013        | -               |
| 17.4837  | 380200     | 0.0007        | -               |
| 17.4883  | 380300     | 0.0009        | -               |
| 17.4929  | 380400     | 0.0011        | -               |
| 17.4975  | 380500     | 0.001         | -               |
| 17.5021  | 380600     | 0.0007        | -               |
| 17.5067  | 380700     | 0.001         | -               |
| 17.5113  | 380800     | 0.0016        | -               |
| 17.5159  | 380900     | 0.0012        | -               |
| 17.5205  | 381000     | 0.001         | -               |
| 17.5251  | 381100     | 0.0007        | -               |
| 17.5297  | 381200     | 0.0009        | -               |
| 17.5343  | 381300     | 0.0008        | -               |
| 17.5389  | 381400     | 0.001         | -               |
| 17.5435  | 381500     | 0.0008        | -               |
| 17.5481  | 381600     | 0.001         | -               |
| 17.5527  | 381700     | 0.0008        | -               |
| 17.5573  | 381800     | 0.0009        | -               |
| 17.5619  | 381900     | 0.0014        | -               |
| 17.5664  | 382000     | 0.001         | -               |
| 17.5710  | 382100     | 0.001         | -               |
| 17.5756  | 382200     | 0.0007        | -               |
| 17.5802  | 382300     | 0.0013        | -               |
| 17.5848  | 382400     | 0.0011        | -               |
| 17.5894  | 382500     | 0.0015        | -               |
| 17.5940  | 382600     | 0.0011        | -               |
| 17.5986  | 382700     | 0.0008        | -               |
| 17.6032  | 382800     | 0.0007        | -               |
| 17.6078  | 382900     | 0.0013        | -               |
| 17.6124  | 383000     | 0.0011        | -               |
| 17.6170  | 383100     | 0.0013        | -               |
| 17.6216  | 383200     | 0.0011        | -               |
| 17.6262  | 383300     | 0.001         | -               |
| 17.6308  | 383400     | 0.0012        | -               |
| 17.6354  | 383500     | 0.0008        | -               |
| 17.6400  | 383600     | 0.0013        | -               |
| 17.6446  | 383700     | 0.0012        | -               |
| 17.6492  | 383800     | 0.0011        | -               |
| 17.6538  | 383900     | 0.0013        | -               |
| 17.6584  | 384000     | 0.0012        | -               |
| 17.6630  | 384100     | 0.0009        | -               |
| 17.6676  | 384200     | 0.0009        | -               |
| 17.6722  | 384300     | 0.0009        | -               |
| 17.6768  | 384400     | 0.0017        | -               |
| 17.6814  | 384500     | 0.0009        | -               |
| 17.6860  | 384600     | 0.001         | -               |
| 17.6906  | 384700     | 0.0013        | -               |
| 17.6952  | 384800     | 0.0011        | -               |
| 17.6998  | 384900     | 0.001         | -               |
| 17.7044  | 385000     | 0.0012        | -               |
| 17.7090  | 385100     | 0.001         | -               |
| 17.7136  | 385200     | 0.0009        | -               |
| 17.7182  | 385300     | 0.0013        | -               |
| 17.7228  | 385400     | 0.0008        | -               |
| 17.7274  | 385500     | 0.0011        | -               |
| 17.7320  | 385600     | 0.0011        | -               |
| 17.7366  | 385700     | 0.0011        | -               |
| 17.7412  | 385800     | 0.0008        | -               |
| 17.7458  | 385900     | 0.0012        | -               |
| 17.7504  | 386000     | 0.0014        | -               |
| 17.7550  | 386100     | 0.001         | -               |
| 17.7596  | 386200     | 0.001         | -               |
| 17.7642  | 386300     | 0.0007        | -               |
| 17.7688  | 386400     | 0.0009        | -               |
| 17.7734  | 386500     | 0.0019        | -               |
| 17.7780  | 386600     | 0.0009        | -               |
| 17.7826  | 386700     | 0.0012        | -               |
| 17.7872  | 386800     | 0.0009        | -               |
| 17.7918  | 386900     | 0.0013        | -               |
| 17.7964  | 387000     | 0.001         | -               |
| 17.8010  | 387100     | 0.0011        | -               |
| 17.8056  | 387200     | 0.001         | -               |
| 17.8102  | 387300     | 0.0011        | -               |
| 17.8148  | 387400     | 0.0015        | -               |
| 17.8194  | 387500     | 0.0008        | -               |
| 17.8240  | 387600     | 0.0012        | -               |
| 17.8286  | 387700     | 0.0009        | -               |
| 17.8332  | 387800     | 0.0016        | -               |
| 17.8378  | 387900     | 0.0013        | -               |
| 17.8424  | 388000     | 0.0008        | -               |
| 17.8470  | 388100     | 0.001         | -               |
| 17.8516  | 388200     | 0.0009        | -               |
| 17.8562  | 388300     | 0.0009        | -               |
| 17.8608  | 388400     | 0.0013        | -               |
| 17.8654  | 388500     | 0.001         | -               |
| 17.8700  | 388600     | 0.0016        | -               |
| 17.8746  | 388700     | 0.001         | -               |
| 17.8792  | 388800     | 0.0013        | -               |
| 17.8837  | 388900     | 0.0012        | -               |
| 17.8883  | 389000     | 0.0011        | -               |
| 17.8929  | 389100     | 0.0012        | -               |
| 17.8975  | 389200     | 0.0012        | -               |
| 17.9021  | 389300     | 0.0009        | -               |
| 17.9067  | 389400     | 0.0011        | -               |
| 17.9113  | 389500     | 0.0015        | -               |
| 17.9159  | 389600     | 0.0012        | -               |
| 17.9205  | 389700     | 0.0008        | -               |
| 17.9251  | 389800     | 0.0009        | -               |
| 17.9297  | 389900     | 0.0009        | -               |
| 17.9343  | 390000     | 0.0009        | -               |
| 17.9389  | 390100     | 0.0012        | -               |
| 17.9435  | 390200     | 0.0014        | -               |
| 17.9481  | 390300     | 0.0007        | -               |
| 17.9527  | 390400     | 0.0006        | -               |
| 17.9573  | 390500     | 0.0014        | -               |
| 17.9619  | 390600     | 0.0008        | -               |
| 17.9665  | 390700     | 0.0009        | -               |
| 17.9711  | 390800     | 0.0011        | -               |
| 17.9757  | 390900     | 0.0012        | -               |
| 17.9803  | 391000     | 0.0012        | -               |
| 17.9849  | 391100     | 0.0009        | -               |
| 17.9895  | 391200     | 0.0012        | -               |
| 17.9941  | 391300     | 0.001         | -               |
| 17.9987  | 391400     | 0.0012        | -               |
| 18.0     | 391428     | -             | 0.0329          |
| 18.0033  | 391500     | 0.0007        | -               |
| 18.0079  | 391600     | 0.0011        | -               |
| 18.0125  | 391700     | 0.0009        | -               |
| 18.0171  | 391800     | 0.0007        | -               |
| 18.0217  | 391900     | 0.0012        | -               |
| 18.0263  | 392000     | 0.0009        | -               |
| 18.0309  | 392100     | 0.0014        | -               |
| 18.0355  | 392200     | 0.0008        | -               |
| 18.0401  | 392300     | 0.0012        | -               |
| 18.0447  | 392400     | 0.001         | -               |
| 18.0493  | 392500     | 0.001         | -               |
| 18.0539  | 392600     | 0.0011        | -               |
| 18.0585  | 392700     | 0.0012        | -               |
| 18.0631  | 392800     | 0.0011        | -               |
| 18.0677  | 392900     | 0.001         | -               |
| 18.0723  | 393000     | 0.0008        | -               |
| 18.0769  | 393100     | 0.001         | -               |
| 18.0815  | 393200     | 0.001         | -               |
| 18.0861  | 393300     | 0.0011        | -               |
| 18.0907  | 393400     | 0.0012        | -               |
| 18.0953  | 393500     | 0.0008        | -               |
| 18.0999  | 393600     | 0.0011        | -               |
| 18.1045  | 393700     | 0.0008        | -               |
| 18.1091  | 393800     | 0.0009        | -               |
| 18.1137  | 393900     | 0.0013        | -               |
| 18.1183  | 394000     | 0.001         | -               |
| 18.1229  | 394100     | 0.0011        | -               |
| 18.1275  | 394200     | 0.001         | -               |
| 18.1321  | 394300     | 0.0008        | -               |
| 18.1367  | 394400     | 0.0012        | -               |
| 18.1413  | 394500     | 0.001         | -               |
| 18.1459  | 394600     | 0.0008        | -               |
| 18.1505  | 394700     | 0.0008        | -               |
| 18.1551  | 394800     | 0.0008        | -               |
| 18.1597  | 394900     | 0.0007        | -               |
| 18.1643  | 395000     | 0.0013        | -               |
| 18.1689  | 395100     | 0.0011        | -               |
| 18.1735  | 395200     | 0.001         | -               |
| 18.1781  | 395300     | 0.0008        | -               |
| 18.1827  | 395400     | 0.0008        | -               |
| 18.1873  | 395500     | 0.0011        | -               |
| 18.1919  | 395600     | 0.0008        | -               |
| 18.1964  | 395700     | 0.001         | -               |
| 18.2010  | 395800     | 0.0011        | -               |
| 18.2056  | 395900     | 0.0008        | -               |
| 18.2102  | 396000     | 0.0009        | -               |
| 18.2148  | 396100     | 0.0012        | -               |
| 18.2194  | 396200     | 0.0009        | -               |
| 18.2240  | 396300     | 0.0007        | -               |
| 18.2286  | 396400     | 0.0016        | -               |
| 18.2332  | 396500     | 0.0011        | -               |
| 18.2378  | 396600     | 0.0016        | -               |
| 18.2424  | 396700     | 0.0008        | -               |
| 18.2470  | 396800     | 0.0007        | -               |
| 18.2516  | 396900     | 0.0007        | -               |
| 18.2562  | 397000     | 0.001         | -               |
| 18.2608  | 397100     | 0.001         | -               |
| 18.2654  | 397200     | 0.0008        | -               |
| 18.2700  | 397300     | 0.0011        | -               |
| 18.2746  | 397400     | 0.0014        | -               |
| 18.2792  | 397500     | 0.0009        | -               |
| 18.2838  | 397600     | 0.0012        | -               |
| 18.2884  | 397700     | 0.001         | -               |
| 18.2930  | 397800     | 0.0008        | -               |
| 18.2976  | 397900     | 0.0019        | -               |
| 18.3022  | 398000     | 0.0008        | -               |
| 18.3068  | 398100     | 0.0012        | -               |
| 18.3114  | 398200     | 0.001         | -               |
| 18.3160  | 398300     | 0.0009        | -               |
| 18.3206  | 398400     | 0.0007        | -               |
| 18.3252  | 398500     | 0.001         | -               |
| 18.3298  | 398600     | 0.001         | -               |
| 18.3344  | 398700     | 0.0009        | -               |
| 18.3390  | 398800     | 0.0009        | -               |
| 18.3436  | 398900     | 0.0008        | -               |
| 18.3482  | 399000     | 0.0007        | -               |
| 18.3528  | 399100     | 0.0013        | -               |
| 18.3574  | 399200     | 0.001         | -               |
| 18.3620  | 399300     | 0.001         | -               |
| 18.3666  | 399400     | 0.0009        | -               |
| 18.3712  | 399500     | 0.0012        | -               |
| 18.3758  | 399600     | 0.0007        | -               |
| 18.3804  | 399700     | 0.0006        | -               |
| 18.3850  | 399800     | 0.0009        | -               |
| 18.3896  | 399900     | 0.0011        | -               |
| 18.3942  | 400000     | 0.0008        | -               |
| 18.3988  | 400100     | 0.0009        | -               |
| 18.4034  | 400200     | 0.0007        | -               |
| 18.4080  | 400300     | 0.0008        | -               |
| 18.4126  | 400400     | 0.0011        | -               |
| 18.4172  | 400500     | 0.0009        | -               |
| 18.4218  | 400600     | 0.001         | -               |
| 18.4264  | 400700     | 0.0011        | -               |
| 18.4310  | 400800     | 0.001         | -               |
| 18.4356  | 400900     | 0.0011        | -               |
| 18.4402  | 401000     | 0.0011        | -               |
| 18.4448  | 401100     | 0.001         | -               |
| 18.4494  | 401200     | 0.0008        | -               |
| 18.4540  | 401300     | 0.0011        | -               |
| 18.4586  | 401400     | 0.0009        | -               |
| 18.4632  | 401500     | 0.0011        | -               |
| 18.4678  | 401600     | 0.001         | -               |
| 18.4724  | 401700     | 0.0011        | -               |
| 18.4770  | 401800     | 0.0009        | -               |
| 18.4816  | 401900     | 0.0012        | -               |
| 18.4862  | 402000     | 0.0007        | -               |
| 18.4908  | 402100     | 0.0013        | -               |
| 18.4954  | 402200     | 0.0009        | -               |
| 18.5000  | 402300     | 0.0009        | -               |
| 18.5046  | 402400     | 0.0008        | -               |
| 18.5092  | 402500     | 0.001         | -               |
| 18.5137  | 402600     | 0.0009        | -               |
| 18.5183  | 402700     | 0.001         | -               |
| 18.5229  | 402800     | 0.0009        | -               |
| 18.5275  | 402900     | 0.0007        | -               |
| 18.5321  | 403000     | 0.0009        | -               |
| 18.5367  | 403100     | 0.0007        | -               |
| 18.5413  | 403200     | 0.0015        | -               |
| 18.5459  | 403300     | 0.0014        | -               |
| 18.5505  | 403400     | 0.0009        | -               |
| 18.5551  | 403500     | 0.0007        | -               |
| 18.5597  | 403600     | 0.0006        | -               |
| 18.5643  | 403700     | 0.001         | -               |
| 18.5689  | 403800     | 0.0008        | -               |
| 18.5735  | 403900     | 0.0007        | -               |
| 18.5781  | 404000     | 0.001         | -               |
| 18.5827  | 404100     | 0.0011        | -               |
| 18.5873  | 404200     | 0.0011        | -               |
| 18.5919  | 404300     | 0.0007        | -               |
| 18.5965  | 404400     | 0.0008        | -               |
| 18.6011  | 404500     | 0.0009        | -               |
| 18.6057  | 404600     | 0.0012        | -               |
| 18.6103  | 404700     | 0.001         | -               |
| 18.6149  | 404800     | 0.0008        | -               |
| 18.6195  | 404900     | 0.0011        | -               |
| 18.6241  | 405000     | 0.0012        | -               |
| 18.6287  | 405100     | 0.0009        | -               |
| 18.6333  | 405200     | 0.001         | -               |
| 18.6379  | 405300     | 0.0009        | -               |
| 18.6425  | 405400     | 0.001         | -               |
| 18.6471  | 405500     | 0.0007        | -               |
| 18.6517  | 405600     | 0.0011        | -               |
| 18.6563  | 405700     | 0.001         | -               |
| 18.6609  | 405800     | 0.001         | -               |
| 18.6655  | 405900     | 0.0008        | -               |
| 18.6701  | 406000     | 0.001         | -               |
| 18.6747  | 406100     | 0.0011        | -               |
| 18.6793  | 406200     | 0.0009        | -               |
| 18.6839  | 406300     | 0.0008        | -               |
| 18.6885  | 406400     | 0.0011        | -               |
| 18.6931  | 406500     | 0.0006        | -               |
| 18.6977  | 406600     | 0.0007        | -               |
| 18.7023  | 406700     | 0.0008        | -               |
| 18.7069  | 406800     | 0.0012        | -               |
| 18.7115  | 406900     | 0.0009        | -               |
| 18.7161  | 407000     | 0.0012        | -               |
| 18.7207  | 407100     | 0.0011        | -               |
| 18.7253  | 407200     | 0.0013        | -               |
| 18.7299  | 407300     | 0.001         | -               |
| 18.7345  | 407400     | 0.001         | -               |
| 18.7391  | 407500     | 0.0011        | -               |
| 18.7437  | 407600     | 0.0012        | -               |
| 18.7483  | 407700     | 0.0011        | -               |
| 18.7529  | 407800     | 0.0009        | -               |
| 18.7575  | 407900     | 0.0013        | -               |
| 18.7621  | 408000     | 0.0006        | -               |
| 18.7667  | 408100     | 0.0007        | -               |
| 18.7713  | 408200     | 0.0009        | -               |
| 18.7759  | 408300     | 0.0006        | -               |
| 18.7805  | 408400     | 0.001         | -               |
| 18.7851  | 408500     | 0.001         | -               |
| 18.7897  | 408600     | 0.001         | -               |
| 18.7943  | 408700     | 0.0008        | -               |
| 18.7989  | 408800     | 0.0011        | -               |
| 18.8035  | 408900     | 0.0013        | -               |
| 18.8081  | 409000     | 0.0009        | -               |
| 18.8127  | 409100     | 0.001         | -               |
| 18.8173  | 409200     | 0.0008        | -               |
| 18.8219  | 409300     | 0.0012        | -               |
| 18.8265  | 409400     | 0.0011        | -               |
| 18.8310  | 409500     | 0.001         | -               |
| 18.8356  | 409600     | 0.0012        | -               |
| 18.8402  | 409700     | 0.0008        | -               |
| 18.8448  | 409800     | 0.0014        | -               |
| 18.8494  | 409900     | 0.0005        | -               |
| 18.8540  | 410000     | 0.0008        | -               |
| 18.8586  | 410100     | 0.0006        | -               |
| 18.8632  | 410200     | 0.0007        | -               |
| 18.8678  | 410300     | 0.0008        | -               |
| 18.8724  | 410400     | 0.0008        | -               |
| 18.8770  | 410500     | 0.001         | -               |
| 18.8816  | 410600     | 0.0008        | -               |
| 18.8862  | 410700     | 0.0009        | -               |
| 18.8908  | 410800     | 0.0009        | -               |
| 18.8954  | 410900     | 0.001         | -               |
| 18.9000  | 411000     | 0.0009        | -               |
| 18.9046  | 411100     | 0.0014        | -               |
| 18.9092  | 411200     | 0.0009        | -               |
| 18.9138  | 411300     | 0.0009        | -               |
| 18.9184  | 411400     | 0.0014        | -               |
| 18.9230  | 411500     | 0.0012        | -               |
| 18.9276  | 411600     | 0.0006        | -               |
| 18.9322  | 411700     | 0.0009        | -               |
| 18.9368  | 411800     | 0.0008        | -               |
| 18.9414  | 411900     | 0.0011        | -               |
| 18.9460  | 412000     | 0.001         | -               |
| 18.9506  | 412100     | 0.0008        | -               |
| 18.9552  | 412200     | 0.0009        | -               |
| 18.9598  | 412300     | 0.0008        | -               |
| 18.9644  | 412400     | 0.0011        | -               |
| 18.9690  | 412500     | 0.0008        | -               |
| 18.9736  | 412600     | 0.0013        | -               |
| 18.9782  | 412700     | 0.0012        | -               |
| 18.9828  | 412800     | 0.001         | -               |
| 18.9874  | 412900     | 0.0014        | -               |
| 18.9920  | 413000     | 0.0008        | -               |
| 18.9966  | 413100     | 0.0011        | -               |
| **19.0** | **413174** | **-**         | **0.0322**      |
| 19.0012  | 413200     | 0.0009        | -               |
| 19.0058  | 413300     | 0.0008        | -               |
| 19.0104  | 413400     | 0.0008        | -               |
| 19.0150  | 413500     | 0.0006        | -               |
| 19.0196  | 413600     | 0.0009        | -               |
| 19.0242  | 413700     | 0.0009        | -               |
| 19.0288  | 413800     | 0.0006        | -               |
| 19.0334  | 413900     | 0.0008        | -               |
| 19.0380  | 414000     | 0.0009        | -               |
| 19.0426  | 414100     | 0.0013        | -               |
| 19.0472  | 414200     | 0.0012        | -               |
| 19.0518  | 414300     | 0.0013        | -               |
| 19.0564  | 414400     | 0.0007        | -               |
| 19.0610  | 414500     | 0.0013        | -               |
| 19.0656  | 414600     | 0.0009        | -               |
| 19.0702  | 414700     | 0.001         | -               |
| 19.0748  | 414800     | 0.0007        | -               |
| 19.0794  | 414900     | 0.0007        | -               |
| 19.0840  | 415000     | 0.0009        | -               |
| 19.0886  | 415100     | 0.001         | -               |
| 19.0932  | 415200     | 0.001         | -               |
| 19.0978  | 415300     | 0.0008        | -               |
| 19.1024  | 415400     | 0.0014        | -               |
| 19.1070  | 415500     | 0.0009        | -               |
| 19.1116  | 415600     | 0.001         | -               |
| 19.1162  | 415700     | 0.0012        | -               |
| 19.1208  | 415800     | 0.0006        | -               |
| 19.1254  | 415900     | 0.0008        | -               |
| 19.1300  | 416000     | 0.0008        | -               |
| 19.1346  | 416100     | 0.0009        | -               |
| 19.1392  | 416200     | 0.0009        | -               |
| 19.1438  | 416300     | 0.0012        | -               |
| 19.1483  | 416400     | 0.001         | -               |
| 19.1529  | 416500     | 0.001         | -               |
| 19.1575  | 416600     | 0.0012        | -               |
| 19.1621  | 416700     | 0.0008        | -               |
| 19.1667  | 416800     | 0.0007        | -               |
| 19.1713  | 416900     | 0.001         | -               |
| 19.1759  | 417000     | 0.0009        | -               |
| 19.1805  | 417100     | 0.0011        | -               |
| 19.1851  | 417200     | 0.0012        | -               |
| 19.1897  | 417300     | 0.001         | -               |
| 19.1943  | 417400     | 0.0008        | -               |
| 19.1989  | 417500     | 0.0013        | -               |
| 19.2035  | 417600     | 0.0009        | -               |
| 19.2081  | 417700     | 0.0006        | -               |
| 19.2127  | 417800     | 0.0006        | -               |
| 19.2173  | 417900     | 0.0006        | -               |
| 19.2219  | 418000     | 0.001         | -               |
| 19.2265  | 418100     | 0.0012        | -               |
| 19.2311  | 418200     | 0.001         | -               |
| 19.2357  | 418300     | 0.0011        | -               |
| 19.2403  | 418400     | 0.001         | -               |
| 19.2449  | 418500     | 0.0009        | -               |
| 19.2495  | 418600     | 0.0007        | -               |
| 19.2541  | 418700     | 0.0012        | -               |
| 19.2587  | 418800     | 0.0009        | -               |
| 19.2633  | 418900     | 0.0009        | -               |
| 19.2679  | 419000     | 0.0013        | -               |
| 19.2725  | 419100     | 0.0008        | -               |
| 19.2771  | 419200     | 0.0012        | -               |
| 19.2817  | 419300     | 0.0009        | -               |
| 19.2863  | 419400     | 0.0012        | -               |
| 19.2909  | 419500     | 0.0007        | -               |
| 19.2955  | 419600     | 0.0009        | -               |
| 19.3001  | 419700     | 0.0008        | -               |
| 19.3047  | 419800     | 0.0012        | -               |
| 19.3093  | 419900     | 0.0008        | -               |
| 19.3139  | 420000     | 0.001         | -               |
| 19.3185  | 420100     | 0.0009        | -               |
| 19.3231  | 420200     | 0.0006        | -               |
| 19.3277  | 420300     | 0.0012        | -               |
| 19.3323  | 420400     | 0.0009        | -               |
| 19.3369  | 420500     | 0.0008        | -               |
| 19.3415  | 420600     | 0.001         | -               |
| 19.3461  | 420700     | 0.0012        | -               |
| 19.3507  | 420800     | 0.0008        | -               |
| 19.3553  | 420900     | 0.0016        | -               |
| 19.3599  | 421000     | 0.0009        | -               |
| 19.3645  | 421100     | 0.0009        | -               |
| 19.3691  | 421200     | 0.0011        | -               |
| 19.3737  | 421300     | 0.0008        | -               |
| 19.3783  | 421400     | 0.0009        | -               |
| 19.3829  | 421500     | 0.0009        | -               |
| 19.3875  | 421600     | 0.0007        | -               |
| 19.3921  | 421700     | 0.0008        | -               |
| 19.3967  | 421800     | 0.0009        | -               |
| 19.4013  | 421900     | 0.0008        | -               |
| 19.4059  | 422000     | 0.001         | -               |
| 19.4105  | 422100     | 0.0007        | -               |
| 19.4151  | 422200     | 0.0008        | -               |
| 19.4197  | 422300     | 0.0008        | -               |
| 19.4243  | 422400     | 0.0008        | -               |
| 19.4289  | 422500     | 0.0008        | -               |
| 19.4335  | 422600     | 0.0012        | -               |
| 19.4381  | 422700     | 0.0008        | -               |
| 19.4427  | 422800     | 0.0007        | -               |
| 19.4473  | 422900     | 0.0008        | -               |
| 19.4519  | 423000     | 0.0009        | -               |
| 19.4565  | 423100     | 0.001         | -               |
| 19.4611  | 423200     | 0.0008        | -               |
| 19.4656  | 423300     | 0.0008        | -               |
| 19.4702  | 423400     | 0.001         | -               |
| 19.4748  | 423500     | 0.0008        | -               |
| 19.4794  | 423600     | 0.0013        | -               |
| 19.4840  | 423700     | 0.0013        | -               |
| 19.4886  | 423800     | 0.0009        | -               |
| 19.4932  | 423900     | 0.0009        | -               |
| 19.4978  | 424000     | 0.0006        | -               |
| 19.5024  | 424100     | 0.0011        | -               |
| 19.5070  | 424200     | 0.0008        | -               |
| 19.5116  | 424300     | 0.001         | -               |
| 19.5162  | 424400     | 0.0009        | -               |
| 19.5208  | 424500     | 0.0009        | -               |
| 19.5254  | 424600     | 0.0008        | -               |
| 19.5300  | 424700     | 0.0006        | -               |
| 19.5346  | 424800     | 0.0005        | -               |
| 19.5392  | 424900     | 0.0008        | -               |
| 19.5438  | 425000     | 0.0008        | -               |
| 19.5484  | 425100     | 0.0008        | -               |
| 19.5530  | 425200     | 0.0006        | -               |
| 19.5576  | 425300     | 0.0009        | -               |
| 19.5622  | 425400     | 0.0008        | -               |
| 19.5668  | 425500     | 0.0013        | -               |
| 19.5714  | 425600     | 0.0007        | -               |
| 19.5760  | 425700     | 0.0006        | -               |
| 19.5806  | 425800     | 0.0006        | -               |
| 19.5852  | 425900     | 0.0012        | -               |
| 19.5898  | 426000     | 0.001         | -               |
| 19.5944  | 426100     | 0.0011        | -               |
| 19.5990  | 426200     | 0.0008        | -               |
| 19.6036  | 426300     | 0.0009        | -               |
| 19.6082  | 426400     | 0.0012        | -               |
| 19.6128  | 426500     | 0.0009        | -               |
| 19.6174  | 426600     | 0.0008        | -               |
| 19.6220  | 426700     | 0.0014        | -               |
| 19.6266  | 426800     | 0.0009        | -               |
| 19.6312  | 426900     | 0.001         | -               |
| 19.6358  | 427000     | 0.0006        | -               |
| 19.6404  | 427100     | 0.0007        | -               |
| 19.6450  | 427200     | 0.0015        | -               |
| 19.6496  | 427300     | 0.0009        | -               |
| 19.6542  | 427400     | 0.0008        | -               |
| 19.6588  | 427500     | 0.001         | -               |
| 19.6634  | 427600     | 0.0008        | -               |
| 19.6680  | 427700     | 0.0007        | -               |
| 19.6726  | 427800     | 0.0008        | -               |
| 19.6772  | 427900     | 0.0013        | -               |
| 19.6818  | 428000     | 0.0007        | -               |
| 19.6864  | 428100     | 0.0006        | -               |
| 19.6910  | 428200     | 0.0008        | -               |
| 19.6956  | 428300     | 0.0008        | -               |
| 19.7002  | 428400     | 0.0007        | -               |
| 19.7048  | 428500     | 0.0008        | -               |
| 19.7094  | 428600     | 0.0015        | -               |
| 19.7140  | 428700     | 0.0007        | -               |
| 19.7186  | 428800     | 0.0011        | -               |
| 19.7232  | 428900     | 0.0009        | -               |
| 19.7278  | 429000     | 0.0008        | -               |
| 19.7324  | 429100     | 0.0007        | -               |
| 19.7370  | 429200     | 0.001         | -               |
| 19.7416  | 429300     | 0.0011        | -               |
| 19.7462  | 429400     | 0.0005        | -               |
| 19.7508  | 429500     | 0.0009        | -               |
| 19.7554  | 429600     | 0.0009        | -               |
| 19.7600  | 429700     | 0.0007        | -               |
| 19.7646  | 429800     | 0.0007        | -               |
| 19.7692  | 429900     | 0.0006        | -               |
| 19.7738  | 430000     | 0.0009        | -               |
| 19.7784  | 430100     | 0.001         | -               |
| 19.7829  | 430200     | 0.0008        | -               |
| 19.7875  | 430300     | 0.0009        | -               |
| 19.7921  | 430400     | 0.0009        | -               |
| 19.7967  | 430500     | 0.001         | -               |
| 19.8013  | 430600     | 0.0008        | -               |
| 19.8059  | 430700     | 0.0006        | -               |
| 19.8105  | 430800     | 0.0011        | -               |
| 19.8151  | 430900     | 0.001         | -               |
| 19.8197  | 431000     | 0.0011        | -               |
| 19.8243  | 431100     | 0.0017        | -               |
| 19.8289  | 431200     | 0.0007        | -               |
| 19.8335  | 431300     | 0.0008        | -               |
| 19.8381  | 431400     | 0.0012        | -               |
| 19.8427  | 431500     | 0.0012        | -               |
| 19.8473  | 431600     | 0.0012        | -               |
| 19.8519  | 431700     | 0.0008        | -               |
| 19.8565  | 431800     | 0.0011        | -               |
| 19.8611  | 431900     | 0.0008        | -               |
| 19.8657  | 432000     | 0.0012        | -               |
| 19.8703  | 432100     | 0.0007        | -               |
| 19.8749  | 432200     | 0.001         | -               |
| 19.8795  | 432300     | 0.0011        | -               |
| 19.8841  | 432400     | 0.0009        | -               |
| 19.8887  | 432500     | 0.0006        | -               |
| 19.8933  | 432600     | 0.0011        | -               |
| 19.8979  | 432700     | 0.001         | -               |
| 19.9025  | 432800     | 0.001         | -               |
| 19.9071  | 432900     | 0.001         | -               |
| 19.9117  | 433000     | 0.0009        | -               |
| 19.9163  | 433100     | 0.0011        | -               |
| 19.9209  | 433200     | 0.001         | -               |
| 19.9255  | 433300     | 0.001         | -               |
| 19.9301  | 433400     | 0.0008        | -               |
| 19.9347  | 433500     | 0.0009        | -               |
| 19.9393  | 433600     | 0.0009        | -               |
| 19.9439  | 433700     | 0.0009        | -               |
| 19.9485  | 433800     | 0.0011        | -               |
| 19.9531  | 433900     | 0.001         | -               |
| 19.9577  | 434000     | 0.0014        | -               |
| 19.9623  | 434100     | 0.0012        | -               |
| 19.9669  | 434200     | 0.0011        | -               |
| 19.9715  | 434300     | 0.0007        | -               |
| 19.9761  | 434400     | 0.0009        | -               |
| 19.9807  | 434500     | 0.0007        | -               |
| 19.9853  | 434600     | 0.0009        | -               |
| 19.9899  | 434700     | 0.0008        | -               |
| 19.9945  | 434800     | 0.001         | -               |
| 19.9991  | 434900     | 0.0008        | -               |
| 20.0     | 434920     | -             | 0.0317          |

* The bold row denotes the saved checkpoint.
</details>

### Framework Versions
- Python: 3.12.11
- Sentence Transformers: 4.1.0
- Transformers: 4.55.0
- PyTorch: 2.7.1+cu126
- Accelerate: 1.10.0
- Datasets: 4.0.0
- Tokenizers: 0.21.4

## Citation

### BibTeX

#### Sentence Transformers
```bibtex
@inproceedings{reimers-2019-sentence-bert,
    title = "Sentence-BERT: Sentence Embeddings using Siamese BERT-Networks",
    author = "Reimers, Nils and Gurevych, Iryna",
    booktitle = "Proceedings of the 2019 Conference on Empirical Methods in Natural Language Processing",
    month = "11",
    year = "2019",
    publisher = "Association for Computational Linguistics",
    url = "https://arxiv.org/abs/1908.10084",
}
```

#### HierarchyTransformerLoss
```bibtex
@article{he2024language,
  title={Language models as hierarchy encoders},
  author={He, Yuan and Yuan, Zhangdie and Chen, Jiaoyan and Horrocks, Ian},
  journal={arXiv preprint arXiv:2401.11374},
  year={2024}
}
```

<!--
## Glossary

*Clearly define terms in order to be accessible across audiences.*
-->

<!--
## Model Card Authors

*Lists the people who create the model card, providing recognition and accountability for the detailed work that goes into its construction.*
-->

<!--
## Model Card Contact

*Provides a way for people who have updates to the Model Card, suggestions, or questions, to contact the Model Card authors.*
-->