---
tags:
- sentence-transformers
- sentence-similarity
- feature-extraction
- generated_from_trainer
- dataset_size:5566780
- loss:HierarchyTransformerLoss
base_model: sentence-transformers/all-MiniLM-L12-v2
widget:
- source_sentence: peripheral neurophysiological procedures
  sentences:
  - assessment of cardiac status using monitoring device
  - evaluation procedure
  - infection of tendon sheath
- source_sentence: celiac artery embolus
  sentences:
  - vascular disease of abdomen
  - celiac artery compression syndrome
  - assessment scales
- source_sentence: 'animal inoculation: virus'
  sentences:
  - salmonella i, group o:30
  - finding of growth of viruses
  - structure of muscular branches of occipital artery
- source_sentence: solicitors report status
  sentences:
  - operative procedure on anterior segment of eye
  - medical report requested
  - report status
- source_sentence: 'animal inoculation: virus'
  sentences:
  - structure of pulmonary artery zones
  - finding of growth of viruses
  - specimen virus identified
pipeline_tag: sentence-similarity
library_name: sentence-transformers
---

# HierarchyTransformer based on sentence-transformers/all-MiniLM-L12-v2

This is a [sentence-transformers](https://www.SBERT.net) model finetuned from [sentence-transformers/all-MiniLM-L12-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L12-v2). It maps sentences & paragraphs to a 384-dimensional dense vector space and can be used for semantic textual similarity, semantic search, paraphrase mining, text classification, clustering, and more.

## Model Details

### Model Description
- **Model Type:** Sentence Transformer
- **Base model:** [sentence-transformers/all-MiniLM-L12-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L12-v2) <!-- at revision c004d8e3e901237d8fa7e9fff12774962e391ce5 -->
- **Maximum Sequence Length:** 128 tokens
- **Output Dimensionality:** 384 dimensions
- **Similarity Function:** Cosine Similarity
<!-- - **Training Dataset:** Unknown -->
<!-- - **Language:** Unknown -->
<!-- - **License:** Unknown -->

### Model Sources

- **Documentation:** [Sentence Transformers Documentation](https://sbert.net)
- **Repository:** [Sentence Transformers on GitHub](https://github.com/UKPLab/sentence-transformers)
- **Hugging Face:** [Sentence Transformers on Hugging Face](https://huggingface.co/models?library=sentence-transformers)

### Full Model Architecture

```
HierarchyTransformer(
  (0): Transformer({'max_seq_length': 128, 'do_lower_case': False}) with Transformer model: BertModel 
  (1): Pooling({'word_embedding_dimension': 384, 'pooling_mode_cls_token': False, 'pooling_mode_mean_tokens': True, 'pooling_mode_max_tokens': False, 'pooling_mode_mean_sqrt_len_tokens': False, 'pooling_mode_weightedmean_tokens': False, 'pooling_mode_lasttoken': False, 'include_prompt': True})
)
```

## Usage

### Direct Usage (Sentence Transformers)

First install the Sentence Transformers library:

```bash
pip install -U sentence-transformers
```

Then you can load this model and run inference.
```python
from sentence_transformers import SentenceTransformer

# Download from the 🤗 Hub
model = SentenceTransformer("sentence_transformers_model_id")
# Run inference
sentences = [
    'animal inoculation: virus',
    'finding of growth of viruses',
    'specimen virus identified',
]
embeddings = model.encode(sentences)
print(embeddings.shape)
# [3, 384]

# Get the similarity scores for the embeddings
similarities = model.similarity(embeddings, embeddings)
print(similarities.shape)
# [3, 3]
```

<!--
### Direct Usage (Transformers)

<details><summary>Click to see the direct usage in Transformers</summary>

</details>
-->

<!--
### Downstream Usage (Sentence Transformers)

You can finetune this model on your own dataset.

<details><summary>Click to expand</summary>

</details>
-->

<!--
### Out-of-Scope Use

*List how the model may foreseeably be misused and address what users ought not to do with the model.*
-->

<!--
## Bias, Risks and Limitations

*What are the known or foreseeable issues stemming from this model? You could also flag here known failure cases or weaknesses of the model.*
-->

<!--
### Recommendations

*What are recommendations with respect to the foreseeable issues? For example, filtering explicit content.*
-->

## Training Details

### Training Dataset

#### Unnamed Dataset

* Size: 5,566,780 training samples
* Columns: <code>child</code>, <code>parent</code>, and <code>negative</code>
* Approximate statistics based on the first 1000 samples:
  |         | child                                                                             | parent                                                                           | negative                                                                          |
  |:--------|:----------------------------------------------------------------------------------|:---------------------------------------------------------------------------------|:----------------------------------------------------------------------------------|
  | type    | string                                                                            | string                                                                           | string                                                                            |
  | details | <ul><li>min: 3 tokens</li><li>mean: 10.94 tokens</li><li>max: 33 tokens</li></ul> | <ul><li>min: 4 tokens</li><li>mean: 8.32 tokens</li><li>max: 22 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 10.33 tokens</li><li>max: 35 tokens</li></ul> |
* Samples:
  | child                                      | parent                                        | negative                                           |
  |:-------------------------------------------|:----------------------------------------------|:---------------------------------------------------|
  | <code>entire skin of shaft of penis</code> | <code>skin structure of shaft of penis</code> | <code>skin of part of shaft of penis</code>        |
  | <code>entire skin of shaft of penis</code> | <code>skin structure of shaft of penis</code> | <code>off-line blood photoimmunotherapy bag</code> |
  | <code>entire skin of shaft of penis</code> | <code>skin structure of shaft of penis</code> | <code>small vessel vasculitis</code>               |
* Loss: <code>hierarchy_transformers.losses.hit_loss.HierarchyTransformerLoss</code> with these parameters:
  ```json
  {
      "distance_metric": "PoincareBall(c=0.0026041900273412466).dist and dist0",
      "HyperbolicClusteringLoss": {
          "weight": 1.0,
          "distance_metric": "PoincareBall(c=0.0026041900273412466).dist",
          "margin": 5.0
      },
      "HyperbolicCentripetalLoss": {
          "weight": 1.0,
          "distance_metric": "PoincareBall(c=0.0026041900273412466).dist0",
          "margin": 0.1
      }
  }
  ```

### Evaluation Dataset

#### Unnamed Dataset

* Size: 3,948,520 evaluation samples
* Columns: <code>child</code>, <code>parent</code>, and <code>negative</code>
* Approximate statistics based on the first 1000 samples:
  |         | child                                                                            | parent                                                                           | negative                                                                         |
  |:--------|:---------------------------------------------------------------------------------|:---------------------------------------------------------------------------------|:---------------------------------------------------------------------------------|
  | type    | string                                                                           | string                                                                           | string                                                                           |
  | details | <ul><li>min: 4 tokens</li><li>mean: 9.94 tokens</li><li>max: 24 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 8.22 tokens</li><li>max: 22 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 9.92 tokens</li><li>max: 34 tokens</li></ul> |
* Samples:
  | child                              | parent                         | negative                                     |
  |:-----------------------------------|:-------------------------------|:---------------------------------------------|
  | <code>phosphatidyl glycerol</code> | <code>phosphatidic acid</code> | <code>palmitoylphosphatidyl choline</code>   |
  | <code>phosphatidyl glycerol</code> | <code>phosphatidic acid</code> | <code>phosphatidyl ethanolamine</code>       |
  | <code>phosphatidyl glycerol</code> | <code>phosphatidic acid</code> | <code>phosphatidyl 3-0-alanylglycerol</code> |
* Loss: <code>hierarchy_transformers.losses.hit_loss.HierarchyTransformerLoss</code> with these parameters:
  ```json
  {
      "distance_metric": "PoincareBall(c=0.0026041900273412466).dist and dist0",
      "HyperbolicClusteringLoss": {
          "weight": 1.0,
          "distance_metric": "PoincareBall(c=0.0026041900273412466).dist",
          "margin": 5.0
      },
      "HyperbolicCentripetalLoss": {
          "weight": 1.0,
          "distance_metric": "PoincareBall(c=0.0026041900273412466).dist0",
          "margin": 0.1
      }
  }
  ```

### Training Hyperparameters
#### Non-Default Hyperparameters

- `eval_strategy`: epoch
- `per_device_train_batch_size`: 256
- `per_device_eval_batch_size`: 512
- `learning_rate`: 1e-05
- `num_train_epochs`: 2
- `warmup_steps`: 500
- `load_best_model_at_end`: True

#### All Hyperparameters
<details><summary>Click to expand</summary>

- `overwrite_output_dir`: False
- `do_predict`: False
- `eval_strategy`: epoch
- `prediction_loss_only`: True
- `per_device_train_batch_size`: 256
- `per_device_eval_batch_size`: 512
- `per_gpu_train_batch_size`: None
- `per_gpu_eval_batch_size`: None
- `gradient_accumulation_steps`: 1
- `eval_accumulation_steps`: None
- `torch_empty_cache_steps`: None
- `learning_rate`: 1e-05
- `weight_decay`: 0.0
- `adam_beta1`: 0.9
- `adam_beta2`: 0.999
- `adam_epsilon`: 1e-08
- `max_grad_norm`: 1.0
- `num_train_epochs`: 2
- `max_steps`: -1
- `lr_scheduler_type`: linear
- `lr_scheduler_kwargs`: {}
- `warmup_ratio`: 0.0
- `warmup_steps`: 500
- `log_level`: passive
- `log_level_replica`: warning
- `log_on_each_node`: True
- `logging_nan_inf_filter`: True
- `save_safetensors`: True
- `save_on_each_node`: False
- `save_only_model`: False
- `restore_callback_states_from_checkpoint`: False
- `no_cuda`: False
- `use_cpu`: False
- `use_mps_device`: False
- `seed`: 42
- `data_seed`: None
- `jit_mode_eval`: False
- `use_ipex`: False
- `bf16`: False
- `fp16`: False
- `fp16_opt_level`: O1
- `half_precision_backend`: auto
- `bf16_full_eval`: False
- `fp16_full_eval`: False
- `tf32`: None
- `local_rank`: 0
- `ddp_backend`: None
- `tpu_num_cores`: None
- `tpu_metrics_debug`: False
- `debug`: []
- `dataloader_drop_last`: False
- `dataloader_num_workers`: 0
- `dataloader_prefetch_factor`: None
- `past_index`: -1
- `disable_tqdm`: False
- `remove_unused_columns`: True
- `label_names`: None
- `load_best_model_at_end`: True
- `ignore_data_skip`: False
- `fsdp`: []
- `fsdp_min_num_params`: 0
- `fsdp_config`: {'min_num_params': 0, 'xla': False, 'xla_fsdp_v2': False, 'xla_fsdp_grad_ckpt': False}
- `fsdp_transformer_layer_cls_to_wrap`: None
- `accelerator_config`: {'split_batches': False, 'dispatch_batches': None, 'even_batches': True, 'use_seedable_sampler': True, 'non_blocking': False, 'gradient_accumulation_kwargs': None}
- `deepspeed`: None
- `label_smoothing_factor`: 0.0
- `optim`: adamw_torch
- `optim_args`: None
- `adafactor`: False
- `group_by_length`: False
- `length_column_name`: length
- `ddp_find_unused_parameters`: None
- `ddp_bucket_cap_mb`: None
- `ddp_broadcast_buffers`: False
- `dataloader_pin_memory`: True
- `dataloader_persistent_workers`: False
- `skip_memory_metrics`: True
- `use_legacy_prediction_loop`: False
- `push_to_hub`: False
- `resume_from_checkpoint`: None
- `hub_model_id`: None
- `hub_strategy`: every_save
- `hub_private_repo`: None
- `hub_always_push`: False
- `hub_revision`: None
- `gradient_checkpointing`: False
- `gradient_checkpointing_kwargs`: None
- `include_inputs_for_metrics`: False
- `include_for_metrics`: []
- `eval_do_concat_batches`: True
- `fp16_backend`: auto
- `push_to_hub_model_id`: None
- `push_to_hub_organization`: None
- `mp_parameters`: 
- `auto_find_batch_size`: False
- `full_determinism`: False
- `torchdynamo`: None
- `ray_scope`: last
- `ddp_timeout`: 1800
- `torch_compile`: False
- `torch_compile_backend`: None
- `torch_compile_mode`: None
- `include_tokens_per_second`: False
- `include_num_input_tokens_seen`: False
- `neftune_noise_alpha`: None
- `optim_target_modules`: None
- `batch_eval_metrics`: False
- `eval_on_start`: False
- `use_liger_kernel`: False
- `liger_kernel_config`: None
- `eval_use_gather_object`: False
- `average_tokens_across_devices`: False
- `prompts`: None
- `batch_sampler`: batch_sampler
- `multi_dataset_batch_sampler`: proportional

</details>

### Training Logs
<details><summary>Click to expand</summary>

| Epoch   | Step      | Training Loss | Validation Loss |
|:-------:|:---------:|:-------------:|:---------------:|
| 0.0046  | 100       | 4.1715        | -               |
| 0.0092  | 200       | 3.1561        | -               |
| 0.0138  | 300       | 2.4565        | -               |
| 0.0184  | 400       | 2.15          | -               |
| 0.0230  | 500       | 1.9476        | -               |
| 0.0276  | 600       | 1.7987        | -               |
| 0.0322  | 700       | 1.7242        | -               |
| 0.0368  | 800       | 1.6755        | -               |
| 0.0414  | 900       | 1.6015        | -               |
| 0.0460  | 1000      | 1.5475        | -               |
| 0.0506  | 1100      | 1.5346        | -               |
| 0.0552  | 1200      | 1.4953        | -               |
| 0.0598  | 1300      | 1.4453        | -               |
| 0.0644  | 1400      | 1.4277        | -               |
| 0.0690  | 1500      | 1.4174        | -               |
| 0.0736  | 1600      | 1.3901        | -               |
| 0.0782  | 1700      | 1.3582        | -               |
| 0.0828  | 1800      | 1.3238        | -               |
| 0.0874  | 1900      | 1.3337        | -               |
| 0.0920  | 2000      | 1.3039        | -               |
| 0.0966  | 2100      | 1.2731        | -               |
| 0.1012  | 2200      | 1.2751        | -               |
| 0.1058  | 2300      | 1.267         | -               |
| 0.1104  | 2400      | 1.2497        | -               |
| 0.1150  | 2500      | 1.2363        | -               |
| 0.1196  | 2600      | 1.2304        | -               |
| 0.1242  | 2700      | 1.2024        | -               |
| 0.1288  | 2800      | 1.1726        | -               |
| 0.1334  | 2900      | 1.1699        | -               |
| 0.1380  | 3000      | 1.1925        | -               |
| 0.1426  | 3100      | 1.132         | -               |
| 0.1472  | 3200      | 1.1603        | -               |
| 0.1518  | 3300      | 1.1193        | -               |
| 0.1564  | 3400      | 1.1307        | -               |
| 0.1609  | 3500      | 1.1331        | -               |
| 0.1655  | 3600      | 1.0956        | -               |
| 0.1701  | 3700      | 1.0972        | -               |
| 0.1747  | 3800      | 1.086         | -               |
| 0.1793  | 3900      | 1.0873        | -               |
| 0.1839  | 4000      | 1.0826        | -               |
| 0.1885  | 4100      | 1.0813        | -               |
| 0.1931  | 4200      | 1.0653        | -               |
| 0.1977  | 4300      | 1.0815        | -               |
| 0.2023  | 4400      | 1.0618        | -               |
| 0.2069  | 4500      | 1.0354        | -               |
| 0.2115  | 4600      | 1.0389        | -               |
| 0.2161  | 4700      | 1.0654        | -               |
| 0.2207  | 4800      | 1.0385        | -               |
| 0.2253  | 4900      | 1.022         | -               |
| 0.2299  | 5000      | 1.0358        | -               |
| 0.2345  | 5100      | 1.0239        | -               |
| 0.2391  | 5200      | 1.0064        | -               |
| 0.2437  | 5300      | 1.0042        | -               |
| 0.2483  | 5400      | 1.0167        | -               |
| 0.2529  | 5500      | 0.9975        | -               |
| 0.2575  | 5600      | 0.9818        | -               |
| 0.2621  | 5700      | 0.9848        | -               |
| 0.2667  | 5800      | 0.9873        | -               |
| 0.2713  | 5900      | 0.9855        | -               |
| 0.2759  | 6000      | 0.9559        | -               |
| 0.2805  | 6100      | 0.9356        | -               |
| 0.2851  | 6200      | 0.9598        | -               |
| 0.2897  | 6300      | 0.9519        | -               |
| 0.2943  | 6400      | 0.9546        | -               |
| 0.2989  | 6500      | 0.9509        | -               |
| 0.3035  | 6600      | 0.9235        | -               |
| 0.3081  | 6700      | 0.9285        | -               |
| 0.3127  | 6800      | 0.9271        | -               |
| 0.3173  | 6900      | 0.9077        | -               |
| 0.3219  | 7000      | 0.9463        | -               |
| 0.3265  | 7100      | 0.9151        | -               |
| 0.3311  | 7200      | 0.9147        | -               |
| 0.3357  | 7300      | 0.9068        | -               |
| 0.3403  | 7400      | 0.8882        | -               |
| 0.3449  | 7500      | 0.9122        | -               |
| 0.3495  | 7600      | 0.9183        | -               |
| 0.3541  | 7700      | 0.9061        | -               |
| 0.3587  | 7800      | 0.8986        | -               |
| 0.3633  | 7900      | 0.8776        | -               |
| 0.3679  | 8000      | 0.8612        | -               |
| 0.3725  | 8100      | 0.8887        | -               |
| 0.3771  | 8200      | 0.8894        | -               |
| 0.3817  | 8300      | 0.8516        | -               |
| 0.3863  | 8400      | 0.8505        | -               |
| 0.3909  | 8500      | 0.8557        | -               |
| 0.3955  | 8600      | 0.8567        | -               |
| 0.4001  | 8700      | 0.8521        | -               |
| 0.4047  | 8800      | 0.8322        | -               |
| 0.4093  | 8900      | 0.8378        | -               |
| 0.4139  | 9000      | 0.8472        | -               |
| 0.4185  | 9100      | 0.8394        | -               |
| 0.4231  | 9200      | 0.8494        | -               |
| 0.4277  | 9300      | 0.8367        | -               |
| 0.4323  | 9400      | 0.839         | -               |
| 0.4369  | 9500      | 0.8195        | -               |
| 0.4415  | 9600      | 0.8292        | -               |
| 0.4461  | 9700      | 0.8105        | -               |
| 0.4507  | 9800      | 0.8368        | -               |
| 0.4553  | 9900      | 0.8227        | -               |
| 0.4599  | 10000     | 0.8033        | -               |
| 0.4645  | 10100     | 0.8147        | -               |
| 0.4691  | 10200     | 0.8155        | -               |
| 0.4737  | 10300     | 0.805         | -               |
| 0.4782  | 10400     | 0.813         | -               |
| 0.4828  | 10500     | 0.8078        | -               |
| 0.4874  | 10600     | 0.7871        | -               |
| 0.4920  | 10700     | 0.7903        | -               |
| 0.4966  | 10800     | 0.8066        | -               |
| 0.5012  | 10900     | 0.7726        | -               |
| 0.5058  | 11000     | 0.7671        | -               |
| 0.5104  | 11100     | 0.7767        | -               |
| 0.5150  | 11200     | 0.7703        | -               |
| 0.5196  | 11300     | 0.7625        | -               |
| 0.5242  | 11400     | 0.7789        | -               |
| 0.5288  | 11500     | 0.7672        | -               |
| 0.5334  | 11600     | 0.7549        | -               |
| 0.5380  | 11700     | 0.7733        | -               |
| 0.5426  | 11800     | 0.7518        | -               |
| 0.5472  | 11900     | 0.7624        | -               |
| 0.5518  | 12000     | 0.7322        | -               |
| 0.5564  | 12100     | 0.7592        | -               |
| 0.5610  | 12200     | 0.7659        | -               |
| 0.5656  | 12300     | 0.7436        | -               |
| 0.5702  | 12400     | 0.7551        | -               |
| 0.5748  | 12500     | 0.7349        | -               |
| 0.5794  | 12600     | 0.7552        | -               |
| 0.5840  | 12700     | 0.7165        | -               |
| 0.5886  | 12800     | 0.7345        | -               |
| 0.5932  | 12900     | 0.7242        | -               |
| 0.5978  | 13000     | 0.7146        | -               |
| 0.6024  | 13100     | 0.7322        | -               |
| 0.6070  | 13200     | 0.7361        | -               |
| 0.6116  | 13300     | 0.717         | -               |
| 0.6162  | 13400     | 0.7132        | -               |
| 0.6208  | 13500     | 0.7234        | -               |
| 0.6254  | 13600     | 0.7122        | -               |
| 0.6300  | 13700     | 0.7426        | -               |
| 0.6346  | 13800     | 0.7144        | -               |
| 0.6392  | 13900     | 0.7115        | -               |
| 0.6438  | 14000     | 0.72          | -               |
| 0.6484  | 14100     | 0.7325        | -               |
| 0.6530  | 14200     | 0.716         | -               |
| 0.6576  | 14300     | 0.7307        | -               |
| 0.6622  | 14400     | 0.7088        | -               |
| 0.6668  | 14500     | 0.698         | -               |
| 0.6714  | 14600     | 0.6981        | -               |
| 0.6760  | 14700     | 0.6822        | -               |
| 0.6806  | 14800     | 0.7054        | -               |
| 0.6852  | 14900     | 0.6915        | -               |
| 0.6898  | 15000     | 0.6907        | -               |
| 0.6944  | 15100     | 0.6989        | -               |
| 0.6990  | 15200     | 0.688         | -               |
| 0.7036  | 15300     | 0.6919        | -               |
| 0.7082  | 15400     | 0.7037        | -               |
| 0.7128  | 15500     | 0.6742        | -               |
| 0.7174  | 15600     | 0.6872        | -               |
| 0.7220  | 15700     | 0.6715        | -               |
| 0.7266  | 15800     | 0.6689        | -               |
| 0.7312  | 15900     | 0.6909        | -               |
| 0.7358  | 16000     | 0.6913        | -               |
| 0.7404  | 16100     | 0.6804        | -               |
| 0.7450  | 16200     | 0.6584        | -               |
| 0.7496  | 16300     | 0.675         | -               |
| 0.7542  | 16400     | 0.6775        | -               |
| 0.7588  | 16500     | 0.6562        | -               |
| 0.7634  | 16600     | 0.6526        | -               |
| 0.7680  | 16700     | 0.679         | -               |
| 0.7726  | 16800     | 0.6503        | -               |
| 0.7772  | 16900     | 0.6625        | -               |
| 0.7818  | 17000     | 0.6777        | -               |
| 0.7864  | 17100     | 0.6642        | -               |
| 0.7910  | 17200     | 0.6625        | -               |
| 0.7955  | 17300     | 0.6678        | -               |
| 0.8001  | 17400     | 0.656         | -               |
| 0.8047  | 17500     | 0.6524        | -               |
| 0.8093  | 17600     | 0.6379        | -               |
| 0.8139  | 17700     | 0.6465        | -               |
| 0.8185  | 17800     | 0.6316        | -               |
| 0.8231  | 17900     | 0.6627        | -               |
| 0.8277  | 18000     | 0.6332        | -               |
| 0.8323  | 18100     | 0.6282        | -               |
| 0.8369  | 18200     | 0.6288        | -               |
| 0.8415  | 18300     | 0.6376        | -               |
| 0.8461  | 18400     | 0.6533        | -               |
| 0.8507  | 18500     | 0.6517        | -               |
| 0.8553  | 18600     | 0.6213        | -               |
| 0.8599  | 18700     | 0.6348        | -               |
| 0.8645  | 18800     | 0.6329        | -               |
| 0.8691  | 18900     | 0.6324        | -               |
| 0.8737  | 19000     | 0.6163        | -               |
| 0.8783  | 19100     | 0.6257        | -               |
| 0.8829  | 19200     | 0.6192        | -               |
| 0.8875  | 19300     | 0.6335        | -               |
| 0.8921  | 19400     | 0.6342        | -               |
| 0.8967  | 19500     | 0.6056        | -               |
| 0.9013  | 19600     | 0.6264        | -               |
| 0.9059  | 19700     | 0.6269        | -               |
| 0.9105  | 19800     | 0.5992        | -               |
| 0.9151  | 19900     | 0.6125        | -               |
| 0.9197  | 20000     | 0.6256        | -               |
| 0.9243  | 20100     | 0.6364        | -               |
| 0.9289  | 20200     | 0.6316        | -               |
| 0.9335  | 20300     | 0.6012        | -               |
| 0.9381  | 20400     | 0.6232        | -               |
| 0.9427  | 20500     | 0.6257        | -               |
| 0.9473  | 20600     | 0.6052        | -               |
| 0.9519  | 20700     | 0.5901        | -               |
| 0.9565  | 20800     | 0.6102        | -               |
| 0.9611  | 20900     | 0.6092        | -               |
| 0.9657  | 21000     | 0.5869        | -               |
| 0.9703  | 21100     | 0.6096        | -               |
| 0.9749  | 21200     | 0.5991        | -               |
| 0.9795  | 21300     | 0.608         | -               |
| 0.9841  | 21400     | 0.5971        | -               |
| 0.9887  | 21500     | 0.5873        | -               |
| 0.9933  | 21600     | 0.5914        | -               |
| 0.9979  | 21700     | 0.5844        | -               |
| 1.0     | 21746     | -             | 1.4115          |
| 1.0025  | 21800     | 0.6014        | -               |
| 1.0071  | 21900     | 0.5876        | -               |
| 1.0117  | 22000     | 0.5721        | -               |
| 1.0163  | 22100     | 0.5809        | -               |
| 1.0209  | 22200     | 0.585         | -               |
| 1.0255  | 22300     | 0.5689        | -               |
| 1.0301  | 22400     | 0.5818        | -               |
| 1.0347  | 22500     | 0.5612        | -               |
| 1.0393  | 22600     | 0.5781        | -               |
| 1.0439  | 22700     | 0.5831        | -               |
| 1.0485  | 22800     | 0.5931        | -               |
| 1.0531  | 22900     | 0.5765        | -               |
| 1.0577  | 23000     | 0.5594        | -               |
| 1.0623  | 23100     | 0.557         | -               |
| 1.0669  | 23200     | 0.5849        | -               |
| 1.0715  | 23300     | 0.5837        | -               |
| 1.0761  | 23400     | 0.5673        | -               |
| 1.0807  | 23500     | 0.5585        | -               |
| 1.0853  | 23600     | 0.5566        | -               |
| 1.0899  | 23700     | 0.5684        | -               |
| 1.0945  | 23800     | 0.5726        | -               |
| 1.0991  | 23900     | 0.5623        | -               |
| 1.1037  | 24000     | 0.5638        | -               |
| 1.1082  | 24100     | 0.5656        | -               |
| 1.1128  | 24200     | 0.5735        | -               |
| 1.1174  | 24300     | 0.5554        | -               |
| 1.1220  | 24400     | 0.5741        | -               |
| 1.1266  | 24500     | 0.553         | -               |
| 1.1312  | 24600     | 0.5756        | -               |
| 1.1358  | 24700     | 0.5603        | -               |
| 1.1404  | 24800     | 0.5594        | -               |
| 1.1450  | 24900     | 0.5617        | -               |
| 1.1496  | 25000     | 0.5463        | -               |
| 1.1542  | 25100     | 0.5387        | -               |
| 1.1588  | 25200     | 0.5628        | -               |
| 1.1634  | 25300     | 0.5632        | -               |
| 1.1680  | 25400     | 0.5518        | -               |
| 1.1726  | 25500     | 0.5383        | -               |
| 1.1772  | 25600     | 0.5647        | -               |
| 1.1818  | 25700     | 0.5288        | -               |
| 1.1864  | 25800     | 0.5403        | -               |
| 1.1910  | 25900     | 0.5561        | -               |
| 1.1956  | 26000     | 0.5384        | -               |
| 1.2002  | 26100     | 0.5329        | -               |
| 1.2048  | 26200     | 0.5254        | -               |
| 1.2094  | 26300     | 0.5376        | -               |
| 1.2140  | 26400     | 0.5465        | -               |
| 1.2186  | 26500     | 0.5476        | -               |
| 1.2232  | 26600     | 0.5378        | -               |
| 1.2278  | 26700     | 0.5492        | -               |
| 1.2324  | 26800     | 0.5353        | -               |
| 1.2370  | 26900     | 0.526         | -               |
| 1.2416  | 27000     | 0.5363        | -               |
| 1.2462  | 27100     | 0.5399        | -               |
| 1.2508  | 27200     | 0.546         | -               |
| 1.2554  | 27300     | 0.5364        | -               |
| 1.2600  | 27400     | 0.5292        | -               |
| 1.2646  | 27500     | 0.5452        | -               |
| 1.2692  | 27600     | 0.5422        | -               |
| 1.2738  | 27700     | 0.5439        | -               |
| 1.2784  | 27800     | 0.5374        | -               |
| 1.2830  | 27900     | 0.5187        | -               |
| 1.2876  | 28000     | 0.5394        | -               |
| 1.2922  | 28100     | 0.541         | -               |
| 1.2968  | 28200     | 0.5243        | -               |
| 1.3014  | 28300     | 0.5435        | -               |
| 1.3060  | 28400     | 0.5217        | -               |
| 1.3106  | 28500     | 0.5276        | -               |
| 1.3152  | 28600     | 0.5399        | -               |
| 1.3198  | 28700     | 0.5195        | -               |
| 1.3244  | 28800     | 0.5344        | -               |
| 1.3290  | 28900     | 0.5328        | -               |
| 1.3336  | 29000     | 0.5294        | -               |
| 1.3382  | 29100     | 0.5322        | -               |
| 1.3428  | 29200     | 0.5284        | -               |
| 1.3474  | 29300     | 0.5174        | -               |
| 1.3520  | 29400     | 0.5388        | -               |
| 1.3566  | 29500     | 0.5203        | -               |
| 1.3612  | 29600     | 0.5051        | -               |
| 1.3658  | 29700     | 0.5275        | -               |
| 1.3704  | 29800     | 0.5232        | -               |
| 1.3750  | 29900     | 0.5161        | -               |
| 1.3796  | 30000     | 0.5107        | -               |
| 1.3842  | 30100     | 0.5448        | -               |
| 1.3888  | 30200     | 0.5131        | -               |
| 1.3934  | 30300     | 0.5132        | -               |
| 1.3980  | 30400     | 0.5251        | -               |
| 1.4026  | 30500     | 0.5065        | -               |
| 1.4072  | 30600     | 0.5043        | -               |
| 1.4118  | 30700     | 0.5049        | -               |
| 1.4164  | 30800     | 0.516         | -               |
| 1.4210  | 30900     | 0.5158        | -               |
| 1.4255  | 31000     | 0.5259        | -               |
| 1.4301  | 31100     | 0.5185        | -               |
| 1.4347  | 31200     | 0.5229        | -               |
| 1.4393  | 31300     | 0.5097        | -               |
| 1.4439  | 31400     | 0.5181        | -               |
| 1.4485  | 31500     | 0.4948        | -               |
| 1.4531  | 31600     | 0.4955        | -               |
| 1.4577  | 31700     | 0.5022        | -               |
| 1.4623  | 31800     | 0.5112        | -               |
| 1.4669  | 31900     | 0.5078        | -               |
| 1.4715  | 32000     | 0.4976        | -               |
| 1.4761  | 32100     | 0.5051        | -               |
| 1.4807  | 32200     | 0.5014        | -               |
| 1.4853  | 32300     | 0.5122        | -               |
| 1.4899  | 32400     | 0.5007        | -               |
| 1.4945  | 32500     | 0.5166        | -               |
| 1.4991  | 32600     | 0.5059        | -               |
| 1.5037  | 32700     | 0.4934        | -               |
| 1.5083  | 32800     | 0.5113        | -               |
| 1.5129  | 32900     | 0.5004        | -               |
| 1.5175  | 33000     | 0.5025        | -               |
| 1.5221  | 33100     | 0.5063        | -               |
| 1.5267  | 33200     | 0.5119        | -               |
| 1.5313  | 33300     | 0.4973        | -               |
| 1.5359  | 33400     | 0.5037        | -               |
| 1.5405  | 33500     | 0.5038        | -               |
| 1.5451  | 33600     | 0.5116        | -               |
| 1.5497  | 33700     | 0.5112        | -               |
| 1.5543  | 33800     | 0.4955        | -               |
| 1.5589  | 33900     | 0.5035        | -               |
| 1.5635  | 34000     | 0.4962        | -               |
| 1.5681  | 34100     | 0.5086        | -               |
| 1.5727  | 34200     | 0.4906        | -               |
| 1.5773  | 34300     | 0.5173        | -               |
| 1.5819  | 34400     | 0.4894        | -               |
| 1.5865  | 34500     | 0.4961        | -               |
| 1.5911  | 34600     | 0.4914        | -               |
| 1.5957  | 34700     | 0.4936        | -               |
| 1.6003  | 34800     | 0.4819        | -               |
| 1.6049  | 34900     | 0.4832        | -               |
| 1.6095  | 35000     | 0.5109        | -               |
| 1.6141  | 35100     | 0.4968        | -               |
| 1.6187  | 35200     | 0.4866        | -               |
| 1.6233  | 35300     | 0.4898        | -               |
| 1.6279  | 35400     | 0.5082        | -               |
| 1.6325  | 35500     | 0.4925        | -               |
| 1.6371  | 35600     | 0.5119        | -               |
| 1.6417  | 35700     | 0.506         | -               |
| 1.6463  | 35800     | 0.4953        | -               |
| 1.6509  | 35900     | 0.486         | -               |
| 1.6555  | 36000     | 0.4839        | -               |
| 1.6601  | 36100     | 0.4889        | -               |
| 1.6647  | 36200     | 0.4794        | -               |
| 1.6693  | 36300     | 0.5033        | -               |
| 1.6739  | 36400     | 0.487         | -               |
| 1.6785  | 36500     | 0.4877        | -               |
| 1.6831  | 36600     | 0.4747        | -               |
| 1.6877  | 36700     | 0.4901        | -               |
| 1.6923  | 36800     | 0.4812        | -               |
| 1.6969  | 36900     | 0.5002        | -               |
| 1.7015  | 37000     | 0.4933        | -               |
| 1.7061  | 37100     | 0.4758        | -               |
| 1.7107  | 37200     | 0.4868        | -               |
| 1.7153  | 37300     | 0.4906        | -               |
| 1.7199  | 37400     | 0.4907        | -               |
| 1.7245  | 37500     | 0.4852        | -               |
| 1.7291  | 37600     | 0.4901        | -               |
| 1.7337  | 37700     | 0.486         | -               |
| 1.7383  | 37800     | 0.4756        | -               |
| 1.7428  | 37900     | 0.476         | -               |
| 1.7474  | 38000     | 0.4777        | -               |
| 1.7520  | 38100     | 0.4837        | -               |
| 1.7566  | 38200     | 0.4916        | -               |
| 1.7612  | 38300     | 0.488         | -               |
| 1.7658  | 38400     | 0.4777        | -               |
| 1.7704  | 38500     | 0.4829        | -               |
| 1.7750  | 38600     | 0.463         | -               |
| 1.7796  | 38700     | 0.4996        | -               |
| 1.7842  | 38800     | 0.4959        | -               |
| 1.7888  | 38900     | 0.4872        | -               |
| 1.7934  | 39000     | 0.499         | -               |
| 1.7980  | 39100     | 0.4814        | -               |
| 1.8026  | 39200     | 0.4911        | -               |
| 1.8072  | 39300     | 0.4818        | -               |
| 1.8118  | 39400     | 0.4809        | -               |
| 1.8164  | 39500     | 0.4853        | -               |
| 1.8210  | 39600     | 0.4923        | -               |
| 1.8256  | 39700     | 0.4804        | -               |
| 1.8302  | 39800     | 0.4991        | -               |
| 1.8348  | 39900     | 0.4881        | -               |
| 1.8394  | 40000     | 0.4855        | -               |
| 1.8440  | 40100     | 0.4843        | -               |
| 1.8486  | 40200     | 0.4806        | -               |
| 1.8532  | 40300     | 0.476         | -               |
| 1.8578  | 40400     | 0.467         | -               |
| 1.8624  | 40500     | 0.4735        | -               |
| 1.8670  | 40600     | 0.4903        | -               |
| 1.8716  | 40700     | 0.4863        | -               |
| 1.8762  | 40800     | 0.4865        | -               |
| 1.8808  | 40900     | 0.496         | -               |
| 1.8854  | 41000     | 0.4884        | -               |
| 1.8900  | 41100     | 0.4707        | -               |
| 1.8946  | 41200     | 0.4988        | -               |
| 1.8992  | 41300     | 0.4873        | -               |
| 1.9038  | 41400     | 0.4883        | -               |
| 1.9084  | 41500     | 0.4936        | -               |
| 1.9130  | 41600     | 0.4891        | -               |
| 1.9176  | 41700     | 0.482         | -               |
| 1.9222  | 41800     | 0.4942        | -               |
| 1.9268  | 41900     | 0.4715        | -               |
| 1.9314  | 42000     | 0.489         | -               |
| 1.9360  | 42100     | 0.4792        | -               |
| 1.9406  | 42200     | 0.4652        | -               |
| 1.9452  | 42300     | 0.4911        | -               |
| 1.9498  | 42400     | 0.4894        | -               |
| 1.9544  | 42500     | 0.4763        | -               |
| 1.9590  | 42600     | 0.4739        | -               |
| 1.9636  | 42700     | 0.476         | -               |
| 1.9682  | 42800     | 0.4764        | -               |
| 1.9728  | 42900     | 0.4764        | -               |
| 1.9774  | 43000     | 0.4842        | -               |
| 1.9820  | 43100     | 0.4844        | -               |
| 1.9866  | 43200     | 0.4862        | -               |
| 1.9912  | 43300     | 0.4794        | -               |
| 1.9958  | 43400     | 0.4749        | -               |
| **2.0** | **43492** | **-**         | **1.148**       |

* The bold row denotes the saved checkpoint.
</details>

### Framework Versions
- Python: 3.12.11
- Sentence Transformers: 4.1.0
- Transformers: 4.55.0
- PyTorch: 2.7.1+cu126
- Accelerate: 1.10.0
- Datasets: 4.0.0
- Tokenizers: 0.21.4

## Citation

### BibTeX

#### Sentence Transformers
```bibtex
@inproceedings{reimers-2019-sentence-bert,
    title = "Sentence-BERT: Sentence Embeddings using Siamese BERT-Networks",
    author = "Reimers, Nils and Gurevych, Iryna",
    booktitle = "Proceedings of the 2019 Conference on Empirical Methods in Natural Language Processing",
    month = "11",
    year = "2019",
    publisher = "Association for Computational Linguistics",
    url = "https://arxiv.org/abs/1908.10084",
}
```

#### HierarchyTransformerLoss
```bibtex
@article{he2024language,
  title={Language models as hierarchy encoders},
  author={He, Yuan and Yuan, Zhangdie and Chen, Jiaoyan and Horrocks, Ian},
  journal={arXiv preprint arXiv:2401.11374},
  year={2024}
}
```

<!--
## Glossary

*Clearly define terms in order to be accessible across audiences.*
-->

<!--
## Model Card Authors

*Lists the people who create the model card, providing recognition and accountability for the detailed work that goes into its construction.*
-->

<!--
## Model Card Contact

*Provides a way for people who have updates to the Model Card, suggestions, or questions, to contact the Model Card authors.*
-->