---
tags:
- sentence-transformers
- sentence-similarity
- feature-extraction
- generated_from_trainer
- dataset_size:1272371
- loss:LogicalConstraintLoss
base_model: sentence-transformers/all-MiniLM-L12-v2
widget:
- source_sentence: salmonella aesch
  sentences:
  - salmonella i, group o:8
  - antigen of bacteria
  - reformation of anterior chamber of eye
- source_sentence: escherichia coli heat-stable toxin
  sentences:
  - escherichia coli toxin
  - role group some something that associated morphology some inflammatory morphology
    and causative agent some sweat and finding site some skin structure and pathological
    process some non-allergic contact hypersensitivity process
  - disease
- source_sentence: congenital non bullous ichthyosiform erythroderma
  sentences:
  - substance with benzene structure
  - panic disorder with agoraphobia and severe panic attacks
  - genodermatosis
- source_sentence: genus chromobacterium
  sentences:
  - combined immunodeficiency disease
  - facultatively anaerobic gram-negative rod
  - amsler chart
- source_sentence: necrotizing keratitis
  sentences:
  - visual pathway structure
  - disease
  - intraperitoneal
pipeline_tag: sentence-similarity
library_name: sentence-transformers
---

# HierarchyTransformer based on sentence-transformers/all-MiniLM-L12-v2

This is a [sentence-transformers](https://www.SBERT.net) model finetuned from [sentence-transformers/all-MiniLM-L12-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L12-v2). It maps sentences & paragraphs to a 384-dimensional dense vector space and can be used for semantic textual similarity, semantic search, paraphrase mining, text classification, clustering, and more.

## Model Details

### Model Description
- **Model Type:** Sentence Transformer
- **Base model:** [sentence-transformers/all-MiniLM-L12-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L12-v2) <!-- at revision c004d8e3e901237d8fa7e9fff12774962e391ce5 -->
- **Maximum Sequence Length:** 128 tokens
- **Output Dimensionality:** 384 dimensions
- **Similarity Function:** Cosine Similarity
<!-- - **Training Dataset:** Unknown -->
<!-- - **Language:** Unknown -->
<!-- - **License:** Unknown -->

### Model Sources

- **Documentation:** [Sentence Transformers Documentation](https://sbert.net)
- **Repository:** [Sentence Transformers on GitHub](https://github.com/UKPLab/sentence-transformers)
- **Hugging Face:** [Sentence Transformers on Hugging Face](https://huggingface.co/models?library=sentence-transformers)

### Full Model Architecture

```
HierarchyTransformer(
  (0): Transformer({'max_seq_length': 128, 'do_lower_case': False}) with Transformer model: BertModel 
  (1): Pooling({'word_embedding_dimension': 384, 'pooling_mode_cls_token': False, 'pooling_mode_mean_tokens': True, 'pooling_mode_max_tokens': False, 'pooling_mode_mean_sqrt_len_tokens': False, 'pooling_mode_weightedmean_tokens': False, 'pooling_mode_lasttoken': False, 'include_prompt': True})
)
```

## Usage

### Direct Usage (Sentence Transformers)

First install the Sentence Transformers library:

```bash
pip install -U sentence-transformers
```

Then you can load this model and run inference.
```python
from sentence_transformers import SentenceTransformer

# Download from the 🤗 Hub
model = SentenceTransformer("sentence_transformers_model_id")
# Run inference
sentences = [
    'necrotizing keratitis',
    'disease',
    'intraperitoneal',
]
embeddings = model.encode(sentences)
print(embeddings.shape)
# [3, 384]

# Get the similarity scores for the embeddings
similarities = model.similarity(embeddings, embeddings)
print(similarities.shape)
# [3, 3]
```

<!--
### Direct Usage (Transformers)

<details><summary>Click to see the direct usage in Transformers</summary>

</details>
-->

<!--
### Downstream Usage (Sentence Transformers)

You can finetune this model on your own dataset.

<details><summary>Click to expand</summary>

</details>
-->

<!--
### Out-of-Scope Use

*List how the model may foreseeably be misused and address what users ought not to do with the model.*
-->

<!--
## Bias, Risks and Limitations

*What are the known or foreseeable issues stemming from this model? You could also flag here known failure cases or weaknesses of the model.*
-->

<!--
### Recommendations

*What are recommendations with respect to the foreseeable issues? For example, filtering explicit content.*
-->

## Training Details

### Training Dataset

#### Unnamed Dataset

* Size: 1,272,371 training samples
* Columns: <code>child</code>, <code>parent</code>, and <code>negative</code>
* Approximate statistics based on the first 1000 samples:
  |         | child                                                                             | parent                                                                           | negative                                                                           |
  |:--------|:----------------------------------------------------------------------------------|:---------------------------------------------------------------------------------|:-----------------------------------------------------------------------------------|
  | type    | string                                                                            | string                                                                           | string                                                                             |
  | details | <ul><li>min: 3 tokens</li><li>mean: 10.06 tokens</li><li>max: 34 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 6.67 tokens</li><li>max: 24 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 20.76 tokens</li><li>max: 128 tokens</li></ul> |
* Samples:
  | child                                                             | parent                                            | negative                                                                                                                                                                                                          |
  |:------------------------------------------------------------------|:--------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | <code>entire posterior epiglottis</code>                          | <code>structure of posterior epiglottis</code>    | <code>role group some something that causative agent some genus staphylococcus and pathological process some infectious process and something that clinical course some sudden onset and/or short duration</code> |
  | <code>vascular headache</code>                                    | <code>disease</code>                              | <code>infection caused by globocephalus urosubulatus</code>                                                                                                                                                       |
  | <code>administration of drug or medicament via nasal route</code> | <code>administration of drug or medicament</code> | <code>argon fluoride excimer laser device</code>                                                                                                                                                                  |
* Loss: <code>hierarchy_transformers.losses.logical_constraint_loss.LogicalConstraintLoss</code> with these parameters:
  ```json
  {
      "conj_weight": 1.0,
      "exist_weight": 1.0,
      "cluster_weight": 1.0,
      "centri_weight": 1.0
  }
  ```

### Training Hyperparameters
#### Non-Default Hyperparameters

- `eval_strategy`: epoch
- `per_device_train_batch_size`: 64
- `per_device_eval_batch_size`: 32
- `learning_rate`: 5e-06
- `num_train_epochs`: 2
- `warmup_steps`: 500
- `load_best_model_at_end`: True

#### All Hyperparameters
<details><summary>Click to expand</summary>

- `overwrite_output_dir`: False
- `do_predict`: False
- `eval_strategy`: epoch
- `prediction_loss_only`: True
- `per_device_train_batch_size`: 64
- `per_device_eval_batch_size`: 32
- `per_gpu_train_batch_size`: None
- `per_gpu_eval_batch_size`: None
- `gradient_accumulation_steps`: 1
- `eval_accumulation_steps`: None
- `torch_empty_cache_steps`: None
- `learning_rate`: 5e-06
- `weight_decay`: 0.0
- `adam_beta1`: 0.9
- `adam_beta2`: 0.999
- `adam_epsilon`: 1e-08
- `max_grad_norm`: 1.0
- `num_train_epochs`: 2
- `max_steps`: -1
- `lr_scheduler_type`: linear
- `lr_scheduler_kwargs`: {}
- `warmup_ratio`: 0.0
- `warmup_steps`: 500
- `log_level`: passive
- `log_level_replica`: warning
- `log_on_each_node`: True
- `logging_nan_inf_filter`: True
- `save_safetensors`: True
- `save_on_each_node`: False
- `save_only_model`: False
- `restore_callback_states_from_checkpoint`: False
- `no_cuda`: False
- `use_cpu`: False
- `use_mps_device`: False
- `seed`: 42
- `data_seed`: None
- `jit_mode_eval`: False
- `use_ipex`: False
- `bf16`: False
- `fp16`: False
- `fp16_opt_level`: O1
- `half_precision_backend`: auto
- `bf16_full_eval`: False
- `fp16_full_eval`: False
- `tf32`: None
- `local_rank`: 0
- `ddp_backend`: None
- `tpu_num_cores`: None
- `tpu_metrics_debug`: False
- `debug`: []
- `dataloader_drop_last`: False
- `dataloader_num_workers`: 0
- `dataloader_prefetch_factor`: None
- `past_index`: -1
- `disable_tqdm`: False
- `remove_unused_columns`: True
- `label_names`: None
- `load_best_model_at_end`: True
- `ignore_data_skip`: False
- `fsdp`: []
- `fsdp_min_num_params`: 0
- `fsdp_config`: {'min_num_params': 0, 'xla': False, 'xla_fsdp_v2': False, 'xla_fsdp_grad_ckpt': False}
- `fsdp_transformer_layer_cls_to_wrap`: None
- `accelerator_config`: {'split_batches': False, 'dispatch_batches': None, 'even_batches': True, 'use_seedable_sampler': True, 'non_blocking': False, 'gradient_accumulation_kwargs': None}
- `deepspeed`: None
- `label_smoothing_factor`: 0.0
- `optim`: adamw_torch
- `optim_args`: None
- `adafactor`: False
- `group_by_length`: False
- `length_column_name`: length
- `ddp_find_unused_parameters`: None
- `ddp_bucket_cap_mb`: None
- `ddp_broadcast_buffers`: False
- `dataloader_pin_memory`: True
- `dataloader_persistent_workers`: False
- `skip_memory_metrics`: True
- `use_legacy_prediction_loop`: False
- `push_to_hub`: False
- `resume_from_checkpoint`: None
- `hub_model_id`: None
- `hub_strategy`: every_save
- `hub_private_repo`: None
- `hub_always_push`: False
- `hub_revision`: None
- `gradient_checkpointing`: False
- `gradient_checkpointing_kwargs`: None
- `include_inputs_for_metrics`: False
- `include_for_metrics`: []
- `eval_do_concat_batches`: True
- `fp16_backend`: auto
- `push_to_hub_model_id`: None
- `push_to_hub_organization`: None
- `mp_parameters`: 
- `auto_find_batch_size`: False
- `full_determinism`: False
- `torchdynamo`: None
- `ray_scope`: last
- `ddp_timeout`: 1800
- `torch_compile`: False
- `torch_compile_backend`: None
- `torch_compile_mode`: None
- `include_tokens_per_second`: False
- `include_num_input_tokens_seen`: False
- `neftune_noise_alpha`: None
- `optim_target_modules`: None
- `batch_eval_metrics`: False
- `eval_on_start`: False
- `use_liger_kernel`: False
- `liger_kernel_config`: None
- `eval_use_gather_object`: False
- `average_tokens_across_devices`: False
- `prompts`: None
- `batch_sampler`: batch_sampler
- `multi_dataset_batch_sampler`: proportional

</details>

### Training Logs
<details><summary>Click to expand</summary>

| Epoch  | Step  | Training Loss |
|:------:|:-----:|:-------------:|
| 0.0050 | 100   | 5.4505        |
| 0.0101 | 200   | 2.0595        |
| 0.0151 | 300   | 1.1622        |
| 0.0201 | 400   | 0.9073        |
| 0.0251 | 500   | 0.8175        |
| 0.0302 | 600   | 0.7635        |
| 0.0352 | 700   | 0.7256        |
| 0.0402 | 800   | 0.7003        |
| 0.0453 | 900   | 0.6973        |
| 0.0503 | 1000  | 0.6731        |
| 0.0553 | 1100  | 0.6677        |
| 0.0604 | 1200  | 0.6638        |
| 0.0654 | 1300  | 0.6491        |
| 0.0704 | 1400  | 0.6417        |
| 0.0754 | 1500  | 0.6331        |
| 0.0805 | 1600  | 0.637         |
| 0.0855 | 1700  | 0.6313        |
| 0.0905 | 1800  | 0.6312        |
| 0.0956 | 1900  | 0.6313        |
| 0.1006 | 2000  | 0.6321        |
| 0.1056 | 2100  | 0.6076        |
| 0.1107 | 2200  | 0.619         |
| 0.1157 | 2300  | 0.6165        |
| 0.1207 | 2400  | 0.6069        |
| 0.1257 | 2500  | 0.6156        |
| 0.1308 | 2600  | 0.6143        |
| 0.1358 | 2700  | 0.6183        |
| 0.1408 | 2800  | 0.6096        |
| 0.1459 | 2900  | 0.6071        |
| 0.1509 | 3000  | 0.5977        |
| 0.1559 | 3100  | 0.6051        |
| 0.1610 | 3200  | 0.6105        |
| 0.1660 | 3300  | 0.6099        |
| 0.1710 | 3400  | 0.6053        |
| 0.1760 | 3500  | 0.5997        |
| 0.1811 | 3600  | 0.6047        |
| 0.1861 | 3700  | 0.5902        |
| 0.1911 | 3800  | 0.5997        |
| 0.1962 | 3900  | 0.5874        |
| 0.2012 | 4000  | 0.595         |
| 0.2062 | 4100  | 0.5983        |
| 0.2113 | 4200  | 0.592         |
| 0.2163 | 4300  | 0.5934        |
| 0.2213 | 4400  | 0.5946        |
| 0.2263 | 4500  | 0.5908        |
| 0.2314 | 4600  | 0.5963        |
| 0.2364 | 4700  | 0.5878        |
| 0.2414 | 4800  | 0.5925        |
| 0.2465 | 4900  | 0.5912        |
| 0.2515 | 5000  | 0.5885        |
| 0.2565 | 5100  | 0.5948        |
| 0.2616 | 5200  | 0.5875        |
| 0.2666 | 5300  | 0.5935        |
| 0.2716 | 5400  | 0.5871        |
| 0.2766 | 5500  | 0.5817        |
| 0.2817 | 5600  | 0.5829        |
| 0.2867 | 5700  | 0.5868        |
| 0.2917 | 5800  | 0.581         |
| 0.2968 | 5900  | 0.5946        |
| 0.3018 | 6000  | 0.5918        |
| 0.3068 | 6100  | 0.58          |
| 0.3119 | 6200  | 0.5826        |
| 0.3169 | 6300  | 0.583         |
| 0.3219 | 6400  | 0.5774        |
| 0.3269 | 6500  | 0.5854        |
| 0.3320 | 6600  | 0.5799        |
| 0.3370 | 6700  | 0.5802        |
| 0.3420 | 6800  | 0.5739        |
| 0.3471 | 6900  | 0.5786        |
| 0.3521 | 7000  | 0.5752        |
| 0.3571 | 7100  | 0.577         |
| 0.3622 | 7200  | 0.591         |
| 0.3672 | 7300  | 0.5785        |
| 0.3722 | 7400  | 0.582         |
| 0.3772 | 7500  | 0.5823        |
| 0.3823 | 7600  | 0.5757        |
| 0.3873 | 7700  | 0.5742        |
| 0.3923 | 7800  | 0.5774        |
| 0.3974 | 7900  | 0.5789        |
| 0.4024 | 8000  | 0.5778        |
| 0.4074 | 8100  | 0.5795        |
| 0.4125 | 8200  | 0.5813        |
| 0.4175 | 8300  | 0.5765        |
| 0.4225 | 8400  | 0.5763        |
| 0.4275 | 8500  | 0.578         |
| 0.4326 | 8600  | 0.5792        |
| 0.4376 | 8700  | 0.5694        |
| 0.4426 | 8800  | 0.5699        |
| 0.4477 | 8900  | 0.5726        |
| 0.4527 | 9000  | 0.5757        |
| 0.4577 | 9100  | 0.573         |
| 0.4628 | 9200  | 0.577         |
| 0.4678 | 9300  | 0.5788        |
| 0.4728 | 9400  | 0.5803        |
| 0.4778 | 9500  | 0.5812        |
| 0.4829 | 9600  | 0.5676        |
| 0.4879 | 9700  | 0.5677        |
| 0.4929 | 9800  | 0.5672        |
| 0.4980 | 9900  | 0.5762        |
| 0.5030 | 10000 | 0.5806        |
| 0.5080 | 10100 | 0.5712        |
| 0.5131 | 10200 | 0.5744        |
| 0.5181 | 10300 | 0.5684        |
| 0.5231 | 10400 | 0.5696        |
| 0.5281 | 10500 | 0.5701        |
| 0.5332 | 10600 | 0.5713        |
| 0.5382 | 10700 | 0.5759        |
| 0.5432 | 10800 | 0.574         |
| 0.5483 | 10900 | 0.5686        |
| 0.5533 | 11000 | 0.5717        |
| 0.5583 | 11100 | 0.5686        |
| 0.5634 | 11200 | 0.573         |
| 0.5684 | 11300 | 0.5727        |
| 0.5734 | 11400 | 0.5671        |
| 0.5784 | 11500 | 0.5704        |
| 0.5835 | 11600 | 0.5682        |
| 0.5885 | 11700 | 0.5727        |
| 0.5935 | 11800 | 0.5658        |
| 0.5986 | 11900 | 0.5625        |
| 0.6036 | 12000 | 0.5633        |
| 0.6086 | 12100 | 0.5708        |
| 0.6137 | 12200 | 0.5589        |
| 0.6187 | 12300 | 0.5771        |
| 0.6237 | 12400 | 0.5742        |
| 0.6287 | 12500 | 0.5666        |
| 0.6338 | 12600 | 0.5681        |
| 0.6388 | 12700 | 0.5644        |
| 0.6438 | 12800 | 0.5679        |
| 0.6489 | 12900 | 0.5696        |
| 0.6539 | 13000 | 0.5762        |
| 0.6589 | 13100 | 0.5738        |
| 0.6640 | 13200 | 0.5665        |
| 0.6690 | 13300 | 0.5644        |
| 0.6740 | 13400 | 0.5649        |
| 0.6790 | 13500 | 0.5717        |
| 0.6841 | 13600 | 0.5642        |
| 0.6891 | 13700 | 0.5734        |
| 0.6941 | 13800 | 0.5633        |
| 0.6992 | 13900 | 0.5688        |
| 0.7042 | 14000 | 0.565         |
| 0.7092 | 14100 | 0.5599        |
| 0.7142 | 14200 | 0.5644        |
| 0.7193 | 14300 | 0.5705        |
| 0.7243 | 14400 | 0.5655        |
| 0.7293 | 14500 | 0.57          |
| 0.7344 | 14600 | 0.5652        |
| 0.7394 | 14700 | 0.5636        |
| 0.7444 | 14800 | 0.5646        |
| 0.7495 | 14900 | 0.5618        |
| 0.7545 | 15000 | 0.5682        |
| 0.7595 | 15100 | 0.5677        |
| 0.7645 | 15200 | 0.5652        |
| 0.7696 | 15300 | 0.5619        |
| 0.7746 | 15400 | 0.5669        |
| 0.7796 | 15500 | 0.5655        |
| 0.7847 | 15600 | 0.5653        |
| 0.7897 | 15700 | 0.5651        |
| 0.7947 | 15800 | 0.5656        |
| 0.7998 | 15900 | 0.5665        |
| 0.8048 | 16000 | 0.5646        |
| 0.8098 | 16100 | 0.5663        |
| 0.8148 | 16200 | 0.5627        |
| 0.8199 | 16300 | 0.562         |
| 0.8249 | 16400 | 0.5614        |
| 0.8299 | 16500 | 0.5645        |
| 0.8350 | 16600 | 0.5661        |
| 0.8400 | 16700 | 0.5577        |
| 0.8450 | 16800 | 0.5623        |
| 0.8501 | 16900 | 0.559         |
| 0.8551 | 17000 | 0.5648        |
| 0.8601 | 17100 | 0.5594        |
| 0.8651 | 17200 | 0.5661        |
| 0.8702 | 17300 | 0.558         |
| 0.8752 | 17400 | 0.562         |
| 0.8802 | 17500 | 0.5541        |
| 0.8853 | 17600 | 0.5723        |
| 0.8903 | 17700 | 0.5632        |
| 0.8953 | 17800 | 0.5692        |
| 0.9004 | 17900 | 0.5637        |
| 0.9054 | 18000 | 0.5575        |
| 0.9104 | 18100 | 0.5567        |
| 0.9154 | 18200 | 0.5575        |
| 0.9205 | 18300 | 0.5618        |
| 0.9255 | 18400 | 0.567         |
| 0.9305 | 18500 | 0.5604        |
| 0.9356 | 18600 | 0.5645        |
| 0.9406 | 18700 | 0.5617        |
| 0.9456 | 18800 | 0.5602        |
| 0.9507 | 18900 | 0.5614        |
| 0.9557 | 19000 | 0.562         |
| 0.9607 | 19100 | 0.5529        |
| 0.9657 | 19200 | 0.5668        |
| 0.9708 | 19300 | 0.5674        |
| 0.9758 | 19400 | 0.5625        |
| 0.9808 | 19500 | 0.5641        |
| 0.9859 | 19600 | 0.5599        |
| 0.9909 | 19700 | 0.5582        |
| 0.9959 | 19800 | 0.5586        |
| 1.0    | 19881 | -             |

</details>

### Framework Versions
- Python: 3.12.11
- Sentence Transformers: 4.1.0
- Transformers: 4.55.0
- PyTorch: 2.7.1+cu126
- Accelerate: 1.10.0
- Datasets: 4.0.0
- Tokenizers: 0.21.4

## Citation

### BibTeX

#### Sentence Transformers
```bibtex
@inproceedings{reimers-2019-sentence-bert,
    title = "Sentence-BERT: Sentence Embeddings using Siamese BERT-Networks",
    author = "Reimers, Nils and Gurevych, Iryna",
    booktitle = "Proceedings of the 2019 Conference on Empirical Methods in Natural Language Processing",
    month = "11",
    year = "2019",
    publisher = "Association for Computational Linguistics",
    url = "https://arxiv.org/abs/1908.10084",
}
```

<!--
## Glossary

*Clearly define terms in order to be accessible across audiences.*
-->

<!--
## Model Card Authors

*Lists the people who create the model card, providing recognition and accountability for the detailed work that goes into its construction.*
-->

<!--
## Model Card Contact

*Provides a way for people who have updates to the Model Card, suggestions, or questions, to contact the Model Card authors.*
-->