---
tags:
- sentence-transformers
- sentence-similarity
- feature-extraction
- generated_from_trainer
- dataset_size:1272371
- loss:LogicalConstraintLoss
base_model: sentence-transformers/all-MiniLM-L12-v2
widget:
- source_sentence: salmonella aesch
  sentences:
  - salmonella i, group o:8
  - antigen of bacteria
  - reformation of anterior chamber of eye
- source_sentence: escherichia coli heat-stable toxin
  sentences:
  - escherichia coli toxin
  - role group some something that associated morphology some inflammatory morphology
    and causative agent some sweat and finding site some skin structure and pathological
    process some non-allergic contact hypersensitivity process
  - disease
- source_sentence: congenital non bullous ichthyosiform erythroderma
  sentences:
  - substance with benzene structure
  - panic disorder with agoraphobia and severe panic attacks
  - genodermatosis
- source_sentence: genus chromobacterium
  sentences:
  - combined immunodeficiency disease
  - facultatively anaerobic gram-negative rod
  - amsler chart
- source_sentence: necrotizing keratitis
  sentences:
  - visual pathway structure
  - disease
  - intraperitoneal
pipeline_tag: sentence-similarity
library_name: sentence-transformers
---

# HierarchyTransformer based on sentence-transformers/all-MiniLM-L12-v2

This is a [sentence-transformers](https://www.SBERT.net) model finetuned from [sentence-transformers/all-MiniLM-L12-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L12-v2). It maps sentences & paragraphs to a 384-dimensional dense vector space and can be used for semantic textual similarity, semantic search, paraphrase mining, text classification, clustering, and more.

## Model Details

### Model Description
- **Model Type:** Sentence Transformer
- **Base model:** [sentence-transformers/all-MiniLM-L12-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L12-v2) <!-- at revision c004d8e3e901237d8fa7e9fff12774962e391ce5 -->
- **Maximum Sequence Length:** 128 tokens
- **Output Dimensionality:** 384 dimensions
- **Similarity Function:** Cosine Similarity
<!-- - **Training Dataset:** Unknown -->
<!-- - **Language:** Unknown -->
<!-- - **License:** Unknown -->

### Model Sources

- **Documentation:** [Sentence Transformers Documentation](https://sbert.net)
- **Repository:** [Sentence Transformers on GitHub](https://github.com/UKPLab/sentence-transformers)
- **Hugging Face:** [Sentence Transformers on Hugging Face](https://huggingface.co/models?library=sentence-transformers)

### Full Model Architecture

```
HierarchyTransformer(
  (0): Transformer({'max_seq_length': 128, 'do_lower_case': False}) with Transformer model: BertModel 
  (1): Pooling({'word_embedding_dimension': 384, 'pooling_mode_cls_token': False, 'pooling_mode_mean_tokens': True, 'pooling_mode_max_tokens': False, 'pooling_mode_mean_sqrt_len_tokens': False, 'pooling_mode_weightedmean_tokens': False, 'pooling_mode_lasttoken': False, 'include_prompt': True})
)
```

## Usage

### Direct Usage (Sentence Transformers)

First install the Sentence Transformers library:

```bash
pip install -U sentence-transformers
```

Then you can load this model and run inference.
```python
from sentence_transformers import SentenceTransformer

# Download from the 🤗 Hub
model = SentenceTransformer("sentence_transformers_model_id")
# Run inference
sentences = [
    'necrotizing keratitis',
    'disease',
    'intraperitoneal',
]
embeddings = model.encode(sentences)
print(embeddings.shape)
# [3, 384]

# Get the similarity scores for the embeddings
similarities = model.similarity(embeddings, embeddings)
print(similarities.shape)
# [3, 3]
```

<!--
### Direct Usage (Transformers)

<details><summary>Click to see the direct usage in Transformers</summary>

</details>
-->

<!--
### Downstream Usage (Sentence Transformers)

You can finetune this model on your own dataset.

<details><summary>Click to expand</summary>

</details>
-->

<!--
### Out-of-Scope Use

*List how the model may foreseeably be misused and address what users ought not to do with the model.*
-->

<!--
## Bias, Risks and Limitations

*What are the known or foreseeable issues stemming from this model? You could also flag here known failure cases or weaknesses of the model.*
-->

<!--
### Recommendations

*What are recommendations with respect to the foreseeable issues? For example, filtering explicit content.*
-->

## Training Details

### Training Dataset

#### Unnamed Dataset

* Size: 1,272,371 training samples
* Columns: <code>child</code>, <code>parent</code>, and <code>negative</code>
* Approximate statistics based on the first 1000 samples:
  |         | child                                                                             | parent                                                                           | negative                                                                           |
  |:--------|:----------------------------------------------------------------------------------|:---------------------------------------------------------------------------------|:-----------------------------------------------------------------------------------|
  | type    | string                                                                            | string                                                                           | string                                                                             |
  | details | <ul><li>min: 3 tokens</li><li>mean: 10.06 tokens</li><li>max: 34 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 6.67 tokens</li><li>max: 24 tokens</li></ul> | <ul><li>min: 3 tokens</li><li>mean: 20.76 tokens</li><li>max: 128 tokens</li></ul> |
* Samples:
  | child                                                             | parent                                            | negative                                                                                                                                                                                                          |
  |:------------------------------------------------------------------|:--------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | <code>entire posterior epiglottis</code>                          | <code>structure of posterior epiglottis</code>    | <code>role group some something that causative agent some genus staphylococcus and pathological process some infectious process and something that clinical course some sudden onset and/or short duration</code> |
  | <code>vascular headache</code>                                    | <code>disease</code>                              | <code>infection caused by globocephalus urosubulatus</code>                                                                                                                                                       |
  | <code>administration of drug or medicament via nasal route</code> | <code>administration of drug or medicament</code> | <code>argon fluoride excimer laser device</code>                                                                                                                                                                  |
* Loss: <code>hierarchy_transformers.losses.logical_constraint_loss.LogicalConstraintLoss</code> with these parameters:
  ```json
  {
      "conj_weight": 0.75,
      "exist_weight": 0.75,
      "cluster_weight": 1.0,
      "centri_weight": 0.85
  }
  ```

### Training Hyperparameters
#### Non-Default Hyperparameters

- `eval_strategy`: epoch
- `per_device_train_batch_size`: 64
- `per_device_eval_batch_size`: 32
- `gradient_accumulation_steps`: 8
- `learning_rate`: 5e-06
- `num_train_epochs`: 20
- `lr_scheduler_type`: cosine
- `warmup_steps`: 500
- `load_best_model_at_end`: True

#### All Hyperparameters
<details><summary>Click to expand</summary>

- `overwrite_output_dir`: False
- `do_predict`: False
- `eval_strategy`: epoch
- `prediction_loss_only`: True
- `per_device_train_batch_size`: 64
- `per_device_eval_batch_size`: 32
- `per_gpu_train_batch_size`: None
- `per_gpu_eval_batch_size`: None
- `gradient_accumulation_steps`: 8
- `eval_accumulation_steps`: None
- `torch_empty_cache_steps`: None
- `learning_rate`: 5e-06
- `weight_decay`: 0.0
- `adam_beta1`: 0.9
- `adam_beta2`: 0.999
- `adam_epsilon`: 1e-08
- `max_grad_norm`: 1.0
- `num_train_epochs`: 20
- `max_steps`: -1
- `lr_scheduler_type`: cosine
- `lr_scheduler_kwargs`: {}
- `warmup_ratio`: 0.0
- `warmup_steps`: 500
- `log_level`: passive
- `log_level_replica`: warning
- `log_on_each_node`: True
- `logging_nan_inf_filter`: True
- `save_safetensors`: True
- `save_on_each_node`: False
- `save_only_model`: False
- `restore_callback_states_from_checkpoint`: False
- `no_cuda`: False
- `use_cpu`: False
- `use_mps_device`: False
- `seed`: 42
- `data_seed`: None
- `jit_mode_eval`: False
- `use_ipex`: False
- `bf16`: False
- `fp16`: False
- `fp16_opt_level`: O1
- `half_precision_backend`: auto
- `bf16_full_eval`: False
- `fp16_full_eval`: False
- `tf32`: None
- `local_rank`: 0
- `ddp_backend`: None
- `tpu_num_cores`: None
- `tpu_metrics_debug`: False
- `debug`: []
- `dataloader_drop_last`: False
- `dataloader_num_workers`: 0
- `dataloader_prefetch_factor`: None
- `past_index`: -1
- `disable_tqdm`: False
- `remove_unused_columns`: True
- `label_names`: None
- `load_best_model_at_end`: True
- `ignore_data_skip`: False
- `fsdp`: []
- `fsdp_min_num_params`: 0
- `fsdp_config`: {'min_num_params': 0, 'xla': False, 'xla_fsdp_v2': False, 'xla_fsdp_grad_ckpt': False}
- `fsdp_transformer_layer_cls_to_wrap`: None
- `accelerator_config`: {'split_batches': False, 'dispatch_batches': None, 'even_batches': True, 'use_seedable_sampler': True, 'non_blocking': False, 'gradient_accumulation_kwargs': None}
- `deepspeed`: None
- `label_smoothing_factor`: 0.0
- `optim`: adamw_torch
- `optim_args`: None
- `adafactor`: False
- `group_by_length`: False
- `length_column_name`: length
- `ddp_find_unused_parameters`: None
- `ddp_bucket_cap_mb`: None
- `ddp_broadcast_buffers`: False
- `dataloader_pin_memory`: True
- `dataloader_persistent_workers`: False
- `skip_memory_metrics`: True
- `use_legacy_prediction_loop`: False
- `push_to_hub`: False
- `resume_from_checkpoint`: None
- `hub_model_id`: None
- `hub_strategy`: every_save
- `hub_private_repo`: None
- `hub_always_push`: False
- `hub_revision`: None
- `gradient_checkpointing`: False
- `gradient_checkpointing_kwargs`: None
- `include_inputs_for_metrics`: False
- `include_for_metrics`: []
- `eval_do_concat_batches`: True
- `fp16_backend`: auto
- `push_to_hub_model_id`: None
- `push_to_hub_organization`: None
- `mp_parameters`: 
- `auto_find_batch_size`: False
- `full_determinism`: False
- `torchdynamo`: None
- `ray_scope`: last
- `ddp_timeout`: 1800
- `torch_compile`: False
- `torch_compile_backend`: None
- `torch_compile_mode`: None
- `include_tokens_per_second`: False
- `include_num_input_tokens_seen`: False
- `neftune_noise_alpha`: None
- `optim_target_modules`: None
- `batch_eval_metrics`: False
- `eval_on_start`: False
- `use_liger_kernel`: False
- `liger_kernel_config`: None
- `eval_use_gather_object`: False
- `average_tokens_across_devices`: False
- `prompts`: None
- `batch_sampler`: batch_sampler
- `multi_dataset_batch_sampler`: proportional

</details>

### Training Logs
<details><summary>Click to expand</summary>

| Epoch  | Step  | Training Loss |
|:------:|:-----:|:-------------:|
| 0.0402 | 100   | 4.1744        |
| 0.0805 | 200   | 1.3871        |
| 0.1207 | 300   | 0.6815        |
| 0.1610 | 400   | 0.5503        |
| 0.2012 | 500   | 0.4957        |
| 0.2414 | 600   | 0.4663        |
| 0.2817 | 700   | 0.4463        |
| 0.3219 | 800   | 0.4351        |
| 0.3622 | 900   | 0.425         |
| 0.4024 | 1000  | 0.4218        |
| 0.4426 | 1100  | 0.4161        |
| 0.4829 | 1200  | 0.4119        |
| 0.5231 | 1300  | 0.4077        |
| 0.5634 | 1400  | 0.4059        |
| 0.6036 | 1500  | 0.4002        |
| 0.6438 | 1600  | 0.4003        |
| 0.6841 | 1700  | 0.4011        |
| 0.7243 | 1800  | 0.3972        |
| 0.7645 | 1900  | 0.3955        |
| 0.8048 | 2000  | 0.3944        |
| 0.8450 | 2100  | 0.3912        |
| 0.8853 | 2200  | 0.3906        |
| 0.9255 | 2300  | 0.3901        |
| 0.9657 | 2400  | 0.3887        |
| 1.0    | 2486  | -             |
| 1.0056 | 2500  | 0.3902        |
| 1.0459 | 2600  | 0.3849        |
| 1.0861 | 2700  | 0.3852        |
| 1.1264 | 2800  | 0.3838        |
| 1.1666 | 2900  | 0.383         |
| 1.2068 | 3000  | 0.3814        |
| 1.2471 | 3100  | 0.3814        |
| 1.2873 | 3200  | 0.3811        |
| 1.3275 | 3300  | 0.378         |
| 1.3678 | 3400  | 0.3796        |
| 1.4080 | 3500  | 0.3794        |
| 1.4483 | 3600  | 0.3787        |
| 1.4885 | 3700  | 0.376         |
| 1.5287 | 3800  | 0.38          |
| 1.5690 | 3900  | 0.3759        |
| 1.6092 | 4000  | 0.3759        |
| 1.6495 | 4100  | 0.3759        |
| 1.6897 | 4200  | 0.377         |
| 1.7299 | 4300  | 0.3757        |
| 1.7702 | 4400  | 0.375         |
| 1.8104 | 4500  | 0.3755        |
| 1.8507 | 4600  | 0.3752        |
| 1.8909 | 4700  | 0.3746        |
| 1.9311 | 4800  | 0.3745        |
| 1.9714 | 4900  | 0.3754        |
| 2.0    | 4972  | -             |
| 2.0113 | 5000  | 0.3721        |
| 2.0515 | 5100  | 0.3698        |
| 2.0917 | 5200  | 0.3707        |
| 2.1320 | 5300  | 0.3706        |
| 2.1722 | 5400  | 0.3704        |
| 2.2125 | 5500  | 0.3687        |
| 2.2527 | 5600  | 0.3703        |
| 2.2929 | 5700  | 0.3706        |
| 2.3332 | 5800  | 0.3707        |
| 2.3734 | 5900  | 0.3703        |
| 2.4137 | 6000  | 0.3694        |
| 2.4539 | 6100  | 0.3681        |
| 2.4941 | 6200  | 0.3682        |
| 2.5344 | 6300  | 0.3663        |
| 2.5746 | 6400  | 0.3676        |
| 2.6149 | 6500  | 0.366         |
| 2.6551 | 6600  | 0.3664        |
| 2.6953 | 6700  | 0.3672        |
| 2.7356 | 6800  | 0.3664        |
| 2.7758 | 6900  | 0.3661        |
| 2.8161 | 7000  | 0.3671        |
| 2.8563 | 7100  | 0.367         |
| 2.8965 | 7200  | 0.3661        |
| 2.9368 | 7300  | 0.3668        |
| 2.9770 | 7400  | 0.3648        |
| 3.0    | 7458  | -             |
| 3.0169 | 7500  | 0.3646        |
| 3.0571 | 7600  | 0.3634        |
| 3.0974 | 7700  | 0.3631        |
| 3.1376 | 7800  | 0.3637        |
| 3.1779 | 7900  | 0.3652        |
| 3.2181 | 8000  | 0.364         |
| 3.2583 | 8100  | 0.3641        |
| 3.2986 | 8200  | 0.3637        |
| 3.3388 | 8300  | 0.3609        |
| 3.3791 | 8400  | 0.3623        |
| 3.4193 | 8500  | 0.3624        |
| 3.4595 | 8600  | 0.362         |
| 3.4998 | 8700  | 0.3618        |
| 3.5400 | 8800  | 0.3621        |
| 3.5803 | 8900  | 0.3642        |
| 3.6205 | 9000  | 0.3621        |
| 3.6607 | 9100  | 0.3607        |
| 3.7010 | 9200  | 0.3625        |
| 3.7412 | 9300  | 0.3625        |
| 3.7814 | 9400  | 0.3621        |
| 3.8217 | 9500  | 0.3611        |
| 3.8619 | 9600  | 0.3618        |
| 3.9022 | 9700  | 0.3597        |
| 3.9424 | 9800  | 0.3595        |
| 3.9826 | 9900  | 0.3619        |
| 4.0    | 9944  | -             |
| 4.0225 | 10000 | 0.3593        |
| 4.0628 | 10100 | 0.3584        |
| 4.1030 | 10200 | 0.3596        |
| 4.1433 | 10300 | 0.3577        |
| 4.1835 | 10400 | 0.3586        |
| 4.2237 | 10500 | 0.3589        |
| 4.2640 | 10600 | 0.3575        |
| 4.3042 | 10700 | 0.359         |
| 4.3444 | 10800 | 0.359         |
| 4.3847 | 10900 | 0.359         |
| 4.4249 | 11000 | 0.3567        |
| 4.4652 | 11100 | 0.359         |
| 4.5054 | 11200 | 0.3572        |
| 4.5456 | 11300 | 0.3581        |
| 4.5859 | 11400 | 0.3585        |
| 4.6261 | 11500 | 0.3579        |
| 4.6664 | 11600 | 0.3579        |
| 4.7066 | 11700 | 0.3585        |
| 4.7468 | 11800 | 0.3581        |
| 4.7871 | 11900 | 0.3576        |
| 4.8273 | 12000 | 0.3574        |
| 4.8676 | 12100 | 0.357         |
| 4.9078 | 12200 | 0.3573        |
| 4.9480 | 12300 | 0.3565        |
| 4.9883 | 12400 | 0.3578        |
| 5.0    | 12430 | -             |
| 5.0282 | 12500 | 0.3548        |
| 5.0684 | 12600 | 0.3575        |
| 5.1086 | 12700 | 0.3561        |
| 5.1489 | 12800 | 0.3548        |
| 5.1891 | 12900 | 0.3555        |
| 5.2294 | 13000 | 0.3556        |
| 5.2696 | 13100 | 0.3558        |
| 5.3098 | 13200 | 0.3552        |
| 5.3501 | 13300 | 0.3559        |
| 5.3903 | 13400 | 0.3555        |
| 5.4306 | 13500 | 0.3548        |
| 5.4708 | 13600 | 0.3539        |
| 5.5110 | 13700 | 0.3553        |
| 5.5513 | 13800 | 0.3539        |
| 5.5915 | 13900 | 0.3531        |
| 5.6318 | 14000 | 0.3556        |
| 5.6720 | 14100 | 0.3548        |
| 5.7122 | 14200 | 0.3544        |
| 5.7525 | 14300 | 0.3542        |
| 5.7927 | 14400 | 0.3555        |
| 5.8330 | 14500 | 0.3571        |
| 5.8732 | 14600 | 0.3554        |
| 5.9134 | 14700 | 0.3549        |
| 5.9537 | 14800 | 0.3548        |
| 5.9939 | 14900 | 0.3537        |
| 6.0    | 14916 | -             |
| 6.0338 | 15000 | 0.3535        |
| 6.0740 | 15100 | 0.3546        |
| 6.1143 | 15200 | 0.3547        |
| 6.1545 | 15300 | 0.3545        |
| 6.1948 | 15400 | 0.354         |
| 6.2350 | 15500 | 0.3522        |
| 6.2752 | 15600 | 0.3534        |
| 6.3155 | 15700 | 0.352         |
| 6.3557 | 15800 | 0.3529        |
| 6.3960 | 15900 | 0.3509        |
| 6.4362 | 16000 | 0.3525        |
| 6.4764 | 16100 | 0.3525        |
| 6.5167 | 16200 | 0.3523        |
| 6.5569 | 16300 | 0.3534        |
| 6.5972 | 16400 | 0.3532        |
| 6.6374 | 16500 | 0.3504        |
| 6.6776 | 16600 | 0.3521        |
| 6.7179 | 16700 | 0.354         |
| 6.7581 | 16800 | 0.3538        |
| 6.7984 | 16900 | 0.3526        |
| 6.8386 | 17000 | 0.3537        |
| 6.8788 | 17100 | 0.3518        |
| 6.9191 | 17200 | 0.3511        |
| 6.9593 | 17300 | 0.3531        |
| 6.9995 | 17400 | 0.3533        |
| 7.0    | 17402 | -             |
| 7.0394 | 17500 | 0.3513        |
| 7.0797 | 17600 | 0.3504        |
| 7.1199 | 17700 | 0.35          |
| 7.1602 | 17800 | 0.3507        |
| 7.2004 | 17900 | 0.3505        |
| 7.2406 | 18000 | 0.3514        |
| 7.2809 | 18100 | 0.3503        |
| 7.3211 | 18200 | 0.3494        |
| 7.3614 | 18300 | 0.3515        |
| 7.4016 | 18400 | 0.3507        |
| 7.4418 | 18500 | 0.3515        |
| 7.4821 | 18600 | 0.352         |
| 7.5223 | 18700 | 0.3517        |
| 7.5625 | 18800 | 0.3499        |
| 7.6028 | 18900 | 0.3513        |
| 7.6430 | 19000 | 0.3508        |
| 7.6833 | 19100 | 0.3519        |
| 7.7235 | 19200 | 0.3513        |
| 7.7637 | 19300 | 0.3494        |
| 7.8040 | 19400 | 0.3511        |
| 7.8442 | 19500 | 0.3507        |
| 7.8845 | 19600 | 0.3514        |
| 7.9247 | 19700 | 0.3509        |
| 7.9649 | 19800 | 0.3512        |
| 8.0    | 19888 | -             |
| 8.0048 | 19900 | 0.3525        |
| 8.0451 | 20000 | 0.3493        |
| 8.0853 | 20100 | 0.349         |
| 8.1255 | 20200 | 0.3486        |
| 8.1658 | 20300 | 0.3502        |
| 8.2060 | 20400 | 0.349         |
| 8.2463 | 20500 | 0.3493        |
| 8.2865 | 20600 | 0.3508        |
| 8.3267 | 20700 | 0.3491        |
| 8.3670 | 20800 | 0.3491        |
| 8.4072 | 20900 | 0.349         |
| 8.4475 | 21000 | 0.35          |
| 8.4877 | 21100 | 0.3492        |
| 8.5279 | 21200 | 0.3497        |
| 8.5682 | 21300 | 0.3499        |
| 8.6084 | 21400 | 0.3497        |
| 8.6487 | 21500 | 0.3483        |
| 8.6889 | 21600 | 0.3493        |
| 8.7291 | 21700 | 0.3492        |
| 8.7694 | 21800 | 0.349         |
| 8.8096 | 21900 | 0.3486        |
| 8.8499 | 22000 | 0.3496        |
| 8.8901 | 22100 | 0.3504        |
| 8.9303 | 22200 | 0.3498        |
| 8.9706 | 22300 | 0.3491        |
| 9.0    | 22374 | -             |

</details>

### Framework Versions
- Python: 3.12.11
- Sentence Transformers: 4.1.0
- Transformers: 4.55.0
- PyTorch: 2.7.1+cu126
- Accelerate: 1.10.0
- Datasets: 4.0.0
- Tokenizers: 0.21.4

## Citation

### BibTeX

#### Sentence Transformers
```bibtex
@inproceedings{reimers-2019-sentence-bert,
    title = "Sentence-BERT: Sentence Embeddings using Siamese BERT-Networks",
    author = "Reimers, Nils and Gurevych, Iryna",
    booktitle = "Proceedings of the 2019 Conference on Empirical Methods in Natural Language Processing",
    month = "11",
    year = "2019",
    publisher = "Association for Computational Linguistics",
    url = "https://arxiv.org/abs/1908.10084",
}
```

<!--
## Glossary

*Clearly define terms in order to be accessible across audiences.*
-->

<!--
## Model Card Authors

*Lists the people who create the model card, providing recognition and accountability for the detailed work that goes into its construction.*
-->

<!--
## Model Card Contact

*Provides a way for people who have updates to the Model Card, suggestions, or questions, to contact the Model Card authors.*
-->